/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityCanvas;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class RenderEntityCanvas
extends Render<EntityCanvas> {
    private static final ResourceLocation backLocation = new ResourceLocation("minecraft", "textures/blocks/planks_birch.png");
    private final TextureManager textureManager;
    private final Map<String, Instance> loadedCanvases = Maps.newHashMap();

    RenderEntityCanvas(RenderManager renderManager) {
        super(renderManager);
        this.textureManager = Minecraft.func_71410_x().func_110434_K();
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityCanvas canvas) {
        return this.getMapRendererInstance(canvas).location;
    }

    public void doRender(EntityCanvas canvas, double x, double y, double z, float yaw, float partialTick) {
        NBTTagCompound tag = canvas.getCanvasNBT();
        if (tag != null && tag.func_74764_b("name")) {
            this.getMapRendererInstance(canvas).render(x, y, z, yaw, partialTick, canvas.func_174811_aO());
        }
        super.func_76986_a((Entity)canvas, x, y, z, yaw, partialTick);
    }

    private Instance getMapRendererInstance(EntityCanvas canvas) {
        NBTTagCompound textureData = canvas.getCanvasNBT();
        Instance instance = this.loadedCanvases.get(textureData.func_74779_i("name"));
        if (instance == null) {
            instance = new Instance(canvas);
            this.loadedCanvases.put(textureData.func_74779_i("name"), instance);
        } else {
            int currentVersion = textureData.func_74762_e("v");
            if (instance.version != currentVersion) {
                instance.updateCanvasTexture(textureData);
            }
        }
        return instance;
    }

    @Nullable
    public Instance getMapInstanceIfExists(String name) {
        return this.loadedCanvases.get(name);
    }

    public void clearLoadedMaps() {
        for (Instance instance : this.loadedCanvases.values()) {
            instance.close();
        }
        this.loadedCanvases.clear();
    }

    public void close() {
        this.clearLoadedMaps();
    }

    @SideOnly(value=Side.CLIENT)
    class Instance
    implements AutoCloseable {
        int version = 0;
        int width;
        int height;
        private final DynamicTexture canvasTexture;
        private final ResourceLocation location;

        private Instance(EntityCanvas canvas) {
            NBTTagCompound tag = canvas.getCanvasNBT();
            this.width = canvas.func_82329_d();
            this.height = canvas.func_82330_g();
            this.canvasTexture = new DynamicTexture(this.width, this.height);
            this.location = RenderEntityCanvas.this.textureManager.func_110578_a("canvas/" + tag.func_74779_i("name"), this.canvasTexture);
            this.updateCanvasTexture(tag);
        }

        private void updateCanvasTexture(NBTTagCompound textureData) {
            this.version = textureData.func_74762_e("v");
            int[] pixels = textureData.func_74759_k("pixels");
            int[] textureArray = this.canvasTexture.func_110565_c();
            if (pixels.length < this.height * this.width) {
                XercaPaint.LOGGER.warn("Pixels array length (" + pixels.length + ") is smaller than canvas area (" + this.height * this.width + ")");
                return;
            }
            if (textureArray.length < this.height * this.width) {
                XercaPaint.LOGGER.warn("Texture array length (" + textureArray.length + ") is smaller than canvas area (" + this.height * this.width + ")");
                return;
            }
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int k = j + i * this.width;
                    textureArray[k] = pixels[k];
                }
            }
            this.canvasTexture.func_110564_a();
        }

        public void render(double x, double y, double z, float yaw, float partialTick, EnumFacing facing) {
            float wScale = (float)this.width / 16.0f;
            float hScale = (float)this.height / 16.0f;
            GlStateManager.func_179094_E();
            float xOffset = facing.func_82601_c();
            float zOffset = facing.func_82599_e();
            float yOffset = -1.0f;
            GlStateManager.func_179137_b((double)(x + (double)zOffset * 0.5 * (double)wScale), (double)(y + -0.5 * (double)hScale), (double)(z - (double)xOffset * 0.5 * (double)wScale));
            GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179091_B();
            float f = 0.03125f;
            GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderEntityCanvas.this.textureManager.func_110577_a(this.location);
            GlStateManager.func_179118_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            bufferbuilder.func_181662_b(0.0, 32.0 * (double)hScale, -1.0).func_187315_a(1.0, 0.0).func_181663_c(xOffset, 0.0f, zOffset).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 32.0 * (double)hScale, -1.0).func_187315_a(0.0, 0.0).func_181663_c(xOffset, 0.0f, zOffset).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 0.0, -1.0).func_187315_a(0.0, 1.0).func_181663_c(xOffset, 0.0f, zOffset).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, -1.0).func_187315_a(1.0, 1.0).func_181663_c(xOffset, 0.0f, zOffset).func_181675_d();
            tessellator.func_78381_a();
            double sideWidth = 0.0625;
            bufferbuilder = tessellator.func_178180_c();
            RenderEntityCanvas.this.textureManager.func_110577_a(backLocation);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 32.0 * (double)hScale, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 32.0 * (double)hScale, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0625, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 32.0 * (double)hScale, 1.0).func_187315_a(0.0625, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 32.0 * (double)hScale, -1.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, -1.0).func_187315_a(0.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 32.0 * (double)hScale, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 32.0 * (double)hScale, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 32.0 * (double)hScale, -1.0).func_187315_a(1.0, 0.0625).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 32.0 * (double)hScale, -1.0).func_187315_a(0.0, 0.0625).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 0.0, -1.0).func_187315_a(0.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 32.0 * (double)hScale, -1.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 32.0 * (double)hScale, 1.0).func_187315_a(0.0625, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 0.0, 1.0).func_187315_a(0.0625, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, -1.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 0.0, -1.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(32.0 * (double)wScale, 0.0, 1.0).func_187315_a(1.0, 0.9375).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0, 0.9375).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179141_d();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }

        @Override
        public void close() {
        }
    }

    public static class RenderEntityCanvasFactory
    implements IRenderFactory<EntityCanvas> {
        public Render<? super EntityCanvas> createRenderFor(RenderManager manager) {
            return new RenderEntityCanvas(manager);
        }
    }
}

