/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.Items;

public class EntityCanvas
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private NBTTagCompound canvasNBT;
    private int tickCounter1 = 0;
    private CanvasType canvasType;

    public EntityCanvas(World world, NBTTagCompound canvasNBT, BlockPos pos, EnumFacing facing, CanvasType canvasType) {
        super(world, pos);
        this.canvasNBT = canvasNBT;
        this.canvasType = canvasType;
        this.func_174859_a(facing);
    }

    public EntityCanvas(World world) {
        super(world);
    }

    public NBTTagCompound getCanvasNBT() {
        return this.canvasNBT;
    }

    public int func_82329_d() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int func_82330_g() {
        return CanvasType.getHeight(this.canvasType);
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        ItemStack canvasItem;
        this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
        if (brokenEntity instanceof EntityPlayer) {
            EntityPlayer EntityPlayer2 = (EntityPlayer)brokenEntity;
            if (EntityPlayer2.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        if (this.canvasType == CanvasType.SMALL) {
            canvasItem = new ItemStack((Item)Items.ITEM_CANVAS);
        } else if (this.canvasType == CanvasType.LONG) {
            canvasItem = new ItemStack((Item)Items.ITEM_CANVAS_LONG);
        } else if (this.canvasType == CanvasType.TALL) {
            canvasItem = new ItemStack((Item)Items.ITEM_CANVAS_TALL);
        } else if (this.canvasType == CanvasType.LARGE) {
            canvasItem = new ItemStack((Item)Items.ITEM_CANVAS_LARGE);
        } else {
            XercaPaint.LOGGER.error("Invalid canvas type");
            return;
        }
        canvasItem.func_77982_d(this.canvasNBT.func_74737_b());
        this.func_70099_a(canvasItem, 0.5f);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.tickCounter1++ == 50 && !this.field_70170_p.field_72995_K) {
            this.tickCounter1 = 0;
            if (!this.field_70128_L && !this.func_70518_d()) {
                this.func_70106_y();
                this.func_110128_b(null);
            }
        }
    }

    public void func_184523_o() {
    }

    protected void func_174856_o() {
        if (this.canvasType != null) {
            super.func_174856_o();
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.canvasNBT = tagCompound.func_74775_l("canvas");
        this.canvasType = CanvasType.fromByte(tagCompound.func_74771_c("ctype"));
        super.func_70037_a(tagCompound);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74782_a("canvas", (NBTBase)this.canvasNBT);
        tagCompound.func_74774_a("ctype", (byte)this.canvasType.ordinal());
        super.func_70014_b(tagCompound);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.canvasNBT);
        buffer.writeInt(this.field_174860_b.func_176745_a());
        buffer.writeByte(this.canvasType.ordinal());
        buffer.writeInt(this.field_174861_a.func_177958_n());
        buffer.writeInt(this.field_174861_a.func_177956_o());
        buffer.writeInt(this.field_174861_a.func_177952_p());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.canvasNBT = ByteBufUtils.readTag((ByteBuf)buffer);
        this.field_174860_b = EnumFacing.field_82609_l[buffer.readInt()];
        this.canvasType = CanvasType.fromByte(buffer.readByte());
        this.field_174861_a = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        this.func_174859_a(this.field_174860_b);
    }
}

