/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.utils;

import com.mrcrayfish.device.util.StreamUtils;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class OnlineRequest {
    private static OnlineRequest instance = null;
    private final Queue<RequestWrapper> requests = new ConcurrentLinkedQueue<RequestWrapper>();
    private Thread thread;
    private boolean running = true;

    private OnlineRequest() {
        this.start();
    }

    public static OnlineRequest getInstance() {
        if (instance == null) {
            instance = new OnlineRequest();
        }
        return instance;
    }

    private void start() {
        this.thread = new Thread((Runnable)new RequestRunnable(), "Online Request Thread");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void make(String url, ResponseHandler handler) {
        Queue<RequestWrapper> queue = this.requests;
        synchronized (queue) {
            this.requests.offer(new RequestWrapper(url, handler));
            this.requests.notify();
        }
    }

    public static interface ResponseHandler {
        public void handle(boolean var1, String var2);
    }

    private static class RequestWrapper {
        public final String url;
        public final ResponseHandler handler;

        public RequestWrapper(String url, ResponseHandler handler) {
            this.url = url;
            this.handler = handler;
        }
    }

    private class RequestRunnable
    implements Runnable {
        private RequestRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (OnlineRequest.this.running) {
                try {
                    Queue queue = OnlineRequest.this.requests;
                    synchronized (queue) {
                        OnlineRequest.this.requests.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while (!OnlineRequest.this.requests.isEmpty()) {
                    RequestWrapper wrapper = (RequestWrapper)OnlineRequest.this.requests.poll();
                    try {
                        CloseableHttpClient client = HttpClients.createDefault();
                        Throwable throwable = null;
                        try {
                            HttpGet get = new HttpGet(wrapper.url);
                            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
                            Throwable throwable2 = null;
                            try {
                                String raw = StreamUtils.convertToString(response.getEntity().getContent());
                                wrapper.handler.handle(true, raw);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (response == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                response.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (client == null) continue;
                            if (throwable != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            client.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        wrapper.handler.handle(false, "");
                    }
                }
            }
        }
    }
}

