/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.System;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.io.Drive;
import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.api.task.Callback;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Settings;
import com.mrcrayfish.device.core.TaskBar;
import com.mrcrayfish.device.core.Window;
import com.mrcrayfish.device.core.Wrappable;
import com.mrcrayfish.device.core.client.LaptopFontRenderer;
import com.mrcrayfish.device.core.task.TaskInstallApp;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.programs.system.component.FileBrowser;
import com.mrcrayfish.device.programs.system.task.TaskUpdateApplicationData;
import com.mrcrayfish.device.programs.system.task.TaskUpdateSystemData;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class Laptop
extends GuiScreen
implements System {
    public static final int ID = 1;
    private static final ResourceLocation LAPTOP_GUI = new ResourceLocation("cdm", "textures/gui/laptop.png");
    public static final ResourceLocation ICON_TEXTURES = new ResourceLocation("cdm", "textures/atlas/app_icons.png");
    public static final int ICON_SIZE = 14;
    public static final FontRenderer fontRenderer = new LaptopFontRenderer(Minecraft.func_71410_x());
    private static final List<Application> APPLICATIONS = new ArrayList<Application>();
    private static final List<ResourceLocation> WALLPAPERS = new ArrayList<ResourceLocation>();
    private static final int BORDER = 10;
    private static final int DEVICE_WIDTH = 384;
    private static final int DEVICE_HEIGHT = 216;
    static final int SCREEN_WIDTH = 364;
    static final int SCREEN_HEIGHT = 196;
    private static System system;
    private static BlockPos pos;
    private static Drive mainDrive;
    private Settings settings;
    private TaskBar bar;
    private Window[] windows;
    private Layout context = null;
    private NBTTagCompound appData;
    private NBTTagCompound systemData;
    private int currentWallpaper;
    private int lastMouseX;
    private int lastMouseY;
    private boolean dragging = false;
    protected List<AppInfo> installedApps = new ArrayList<AppInfo>();

    public Laptop(TileEntityLaptop laptop) {
        this.appData = laptop.getApplicationData();
        this.systemData = laptop.getSystemData();
        this.windows = new Window[5];
        this.settings = Settings.fromTag(this.systemData.func_74775_l("Settings"));
        this.bar = new TaskBar(this);
        this.currentWallpaper = this.systemData.func_74762_e("CurrentWallpaper");
        if (this.currentWallpaper < 0 || this.currentWallpaper >= WALLPAPERS.size()) {
            this.currentWallpaper = 0;
        }
        system = this;
        pos = laptop.func_174877_v();
    }

    @Nullable
    public static BlockPos getPos() {
        return pos;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int posX = (this.field_146294_l - 384) / 2;
        int posY = (this.field_146295_m - 216) / 2;
        this.bar.init(posX + 10, posY + 216 - 28);
        this.installedApps.clear();
        NBTTagList tagList = this.systemData.func_150295_c("InstalledApps", 8);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            AppInfo info = ApplicationManager.getApplication(tagList.func_150307_f(i));
            if (info == null) continue;
            this.installedApps.add(info);
        }
        this.installedApps.sort(AppInfo.SORT_NAME);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        for (Window window : this.windows) {
            if (window == null) continue;
            window.close();
        }
        this.updateSystemData();
        pos = null;
        system = null;
        mainDrive = null;
    }

    private void updateSystemData() {
        this.systemData.func_74768_a("CurrentWallpaper", this.currentWallpaper);
        this.systemData.func_74782_a("Settings", (NBTBase)this.settings.toTag());
        NBTTagList tagListApps = new NBTTagList();
        this.installedApps.forEach(info -> tagListApps.func_74742_a((NBTBase)new NBTTagString(info.getFormattedId())));
        this.systemData.func_74782_a("InstalledApps", (NBTBase)tagListApps);
        TaskManager.sendTask(new TaskUpdateSystemData(pos, this.systemData));
    }

    public void func_175273_b(Minecraft mcIn, int width, int height) {
        super.func_175273_b(mcIn, width, height);
        for (Window window : this.windows) {
            if (window == null) continue;
            ((Wrappable)window.content).markForLayoutUpdate();
        }
    }

    public void func_73876_c() {
        this.bar.onTick();
        for (Window window : this.windows) {
            if (window == null) continue;
            window.onTick();
        }
        FileBrowser.refreshList = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        partialTicks = Minecraft.func_71410_x().func_184121_ak();
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(LAPTOP_GUI);
        int posX = (this.field_146294_l - 384) / 2;
        int posY = (this.field_146295_m - 216) / 2;
        this.func_73729_b(posX, posY, 0, 0, 10, 10);
        this.func_73729_b(posX + 384 - 10, posY, 11, 0, 10, 10);
        this.func_73729_b(posX + 384 - 10, posY + 216 - 10, 11, 11, 10, 10);
        this.func_73729_b(posX, posY + 216 - 10, 0, 11, 10, 10);
        RenderUtil.drawRectWithTexture(posX + 10, posY, 10.0f, 0.0f, 364, 10, 1.0f, 10.0f);
        RenderUtil.drawRectWithTexture(posX + 384 - 10, posY + 10, 11.0f, 10.0f, 10, 196, 10.0f, 1.0f);
        RenderUtil.drawRectWithTexture(posX + 10, posY + 216 - 10, 10.0f, 11.0f, 364, 10, 1.0f, 10.0f);
        RenderUtil.drawRectWithTexture(posX, posY + 10, 0.0f, 11.0f, 10, 196, 10.0f, 1.0f);
        RenderUtil.drawRectWithTexture(posX + 10, posY + 10, 10.0f, 10.0f, 364, 196, 1.0f, 1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(WALLPAPERS.get(this.currentWallpaper));
        RenderUtil.drawRectWithFullTexture(posX + 10, posY + 10, 0.0f, 0.0f, 364, 196);
        this.func_73731_b(fontRenderer, "Alpha v0.4.1", posX + 10 + 5, posY + 10 + 5, Color.WHITE.getRGB());
        boolean insideContext = false;
        if (this.context != null) {
            insideContext = GuiHelper.isMouseInside(mouseX, mouseY, this.context.xPosition, this.context.yPosition, this.context.xPosition + this.context.width, this.context.yPosition + this.context.height);
        }
        Image.CACHE.forEach((s, cachedImage) -> cachedImage.delete());
        for (int i = this.windows.length - 1; i >= 0; --i) {
            Window window = this.windows[i];
            if (window == null) continue;
            window.render(this, this.field_146297_k, posX + 10, posY + 10, mouseX, mouseY, i == 0 && !insideContext, partialTicks);
        }
        this.bar.render(this, this.field_146297_k, posX + 10, posY + 216 - 28, mouseX, mouseY, partialTicks);
        if (this.context != null) {
            this.context.render(this, this.field_146297_k, this.context.xPosition, this.context.yPosition, mouseX, mouseY, true, partialTicks);
        }
        Image.CACHE.entrySet().removeIf(entry -> {
            Image.CachedImage cachedImage = (Image.CachedImage)entry.getValue();
            if (cachedImage.isDynamic() && cachedImage.isPendingDeletion()) {
                int texture = cachedImage.getTextureId();
                if (texture != -1) {
                    GL11.glDeleteTextures((int)texture);
                }
                return true;
            }
            return false;
        });
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        int posX = (this.field_146294_l - 364) / 2;
        int posY = (this.field_146295_m - 196) / 2;
        if (this.context != null) {
            int dropdownX = this.context.xPosition;
            int dropdownY = this.context.yPosition;
            if (GuiHelper.isMouseInside(mouseX, mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                this.context.handleMouseClick(mouseX, mouseY, mouseButton);
                return;
            }
            this.context = null;
        }
        this.bar.handleClick(this, posX, posY + 196 - 18, mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.windows.length; ++i) {
            Window window = this.windows[i];
            if (window == null) continue;
            Window<Dialog> dialogWindow = ((Application)window.getContent()).getActiveDialog();
            if (!this.isMouseWithinWindow(mouseX, mouseY, window) && !this.isMouseWithinWindow(mouseX, mouseY, dialogWindow)) continue;
            this.windows[i] = null;
            this.updateWindowStack();
            this.windows[0] = window;
            this.windows[0].handleMouseClick(this, posX, posY, mouseX, mouseY, mouseButton);
            if (this.isMouseWithinWindowBar(mouseX, mouseY, dialogWindow)) {
                this.dragging = true;
                return;
            }
            if (!this.isMouseWithinWindowBar(mouseX, mouseY, window) || dialogWindow != null) break;
            this.dragging = true;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.dragging = false;
        if (this.context != null) {
            int dropdownX = this.context.xPosition;
            int dropdownY = this.context.yPosition;
            if (GuiHelper.isMouseInside(mouseX, mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                this.context.handleMouseRelease(mouseX, mouseY, state);
            }
        } else if (this.windows[0] != null) {
            this.windows[0].handleMouseRelease(mouseX, mouseY, state);
        }
    }

    public void func_146282_l() throws IOException {
        if (Keyboard.getEventKeyState()) {
            char pressed = Keyboard.getEventCharacter();
            int code = Keyboard.getEventKey();
            if (this.windows[0] != null) {
                this.windows[0].handleKeyTyped(pressed, code);
            }
            super.func_73869_a(pressed, code);
        } else if (this.windows[0] != null) {
            this.windows[0].handleKeyReleased(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
        this.field_146297_k.func_152348_aa();
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        int posX = (this.field_146294_l - 364) / 2;
        int posY = (this.field_146295_m - 196) / 2;
        if (this.context != null) {
            int dropdownX = this.context.xPosition;
            int dropdownY = this.context.yPosition;
            if (GuiHelper.isMouseInside(mouseX, mouseY, dropdownX, dropdownY, dropdownX + this.context.width, dropdownY + this.context.height)) {
                this.context.handleMouseDrag(mouseX, mouseY, clickedMouseButton);
            }
            return;
        }
        if (this.windows[0] != null) {
            Window window = this.windows[0];
            Window<Dialog> dialogWindow = ((Application)window.getContent()).getActiveDialog();
            if (this.dragging) {
                if (this.isMouseOnScreen(mouseX, mouseY)) {
                    if (dialogWindow == null) {
                        window.handleWindowMove(posX, posY, -(this.lastMouseX - mouseX), -(this.lastMouseY - mouseY));
                    } else {
                        dialogWindow.handleWindowMove(posX, posY, -(this.lastMouseX - mouseX), -(this.lastMouseY - mouseY));
                    }
                } else {
                    this.dragging = false;
                }
            } else if (this.isMouseWithinWindow(mouseX, mouseY, window) || this.isMouseWithinWindow(mouseX, mouseY, dialogWindow)) {
                window.handleMouseDrag(mouseX, mouseY, clickedMouseButton);
            }
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0 && this.windows[0] != null) {
            this.windows[0].handleMouseScroll(mouseX, mouseY, scroll >= 0);
        }
    }

    public void func_146283_a(List<String> textLines, int x, int y) {
        super.func_146283_a(textLines, x, y);
    }

    public boolean sendApplicationToFront(AppInfo info) {
        for (int i = 0; i < this.windows.length; ++i) {
            Window window = this.windows[i];
            if (window == null || !(window.content instanceof Application) || ((Application)window.content).getInfo() != info) continue;
            this.windows[i] = null;
            this.updateWindowStack();
            this.windows[0] = window;
            return true;
        }
        return false;
    }

    @Override
    public void openApplication(AppInfo info) {
        this.openApplication(info, (NBTTagCompound)null);
    }

    @Override
    public void openApplication(AppInfo info, NBTTagCompound intentTag) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        optional.ifPresent(application -> this.openApplication((Application)application, intentTag));
    }

    private void openApplication(Application app, NBTTagCompound intent) {
        if (!this.isApplicationInstalled(app.getInfo())) {
            return;
        }
        if (!this.isValidApplication(app.getInfo())) {
            return;
        }
        if (this.sendApplicationToFront(app.getInfo())) {
            return;
        }
        Window<Application> window = new Window<Application>(app, this);
        window.init((this.field_146294_l - 364) / 2, (this.field_146295_m - 196) / 2, intent);
        if (this.appData.func_74764_b(app.getInfo().getFormattedId())) {
            app.load(this.appData.func_74775_l(app.getInfo().getFormattedId()));
        }
        if (app instanceof SystemApplication) {
            ((SystemApplication)app).setLaptop(this);
        }
        if (app.getCurrentLayout() == null) {
            app.restoreDefaultLayout();
        }
        this.addWindow(window);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    public boolean openApplication(AppInfo info, File file) {
        if (!this.isApplicationInstalled(info)) {
            return false;
        }
        if (!this.isValidApplication(info)) {
            return false;
        }
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        if (optional.isPresent()) {
            Application application = optional.get();
            boolean alreadyRunning = this.isApplicationRunning(info);
            this.openApplication(application, null);
            if (this.isApplicationRunning(info)) {
                if (!application.handleFile(file)) {
                    if (!alreadyRunning) {
                        this.closeApplication(application);
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void closeApplication(AppInfo info) {
        Optional<Application> optional = APPLICATIONS.stream().filter(app -> app.getInfo() == info).findFirst();
        optional.ifPresent(this::closeApplication);
    }

    private void closeApplication(Application app) {
        for (int i = 0; i < this.windows.length; ++i) {
            Window window = this.windows[i];
            if (window == null || !((Application)window.content).getInfo().equals(app.getInfo())) continue;
            if (app.isDirty()) {
                NBTTagCompound container = new NBTTagCompound();
                app.save(container);
                app.clean();
                this.appData.func_74782_a(app.getInfo().getFormattedId(), (NBTBase)container);
                TaskManager.sendTask(new TaskUpdateApplicationData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), app.getInfo().getFormattedId(), container));
            }
            if (app instanceof SystemApplication) {
                ((SystemApplication)app).setLaptop(null);
            }
            window.handleClose();
            this.windows[i] = null;
            return;
        }
    }

    private void addWindow(Window<Application> window) {
        if (this.hasReachedWindowLimit()) {
            return;
        }
        this.updateWindowStack();
        this.windows[0] = window;
    }

    private void updateWindowStack() {
        for (int i = this.windows.length - 1; i >= 0; --i) {
            if (this.windows[i] == null || i + 1 >= this.windows.length || i != 0 && this.windows[i - 1] == null || this.windows[i + 1] != null) continue;
            this.windows[i + 1] = this.windows[i];
            this.windows[i] = null;
        }
    }

    private boolean hasReachedWindowLimit() {
        for (Window window : this.windows) {
            if (window != null) continue;
            return false;
        }
        return true;
    }

    private boolean isMouseOnScreen(int mouseX, int mouseY) {
        int posX = (this.field_146294_l - 364) / 2;
        int posY = (this.field_146295_m - 196) / 2;
        return GuiHelper.isMouseInside(mouseX, mouseY, posX, posY, posX + 364, posY + 196);
    }

    private boolean isMouseWithinWindowBar(int mouseX, int mouseY, Window window) {
        if (window == null) {
            return false;
        }
        int posX = (this.field_146294_l - 364) / 2;
        int posY = (this.field_146295_m - 196) / 2;
        return GuiHelper.isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 1, posX + window.offsetX + window.width - 13, posY + window.offsetY + 11);
    }

    private boolean isMouseWithinWindow(int mouseX, int mouseY, Window window) {
        if (window == null) {
            return false;
        }
        int posX = (this.field_146294_l - 364) / 2;
        int posY = (this.field_146295_m - 196) / 2;
        return GuiHelper.isMouseInside(mouseX, mouseY, posX + window.offsetX, posY + window.offsetY, posX + window.offsetX + window.width, posY + window.offsetY + window.height);
    }

    public boolean isMouseWithinApp(int mouseX, int mouseY, Window window) {
        int posX = (this.field_146294_l - 364) / 2;
        int posY = (this.field_146295_m - 196) / 2;
        return GuiHelper.isMouseInside(mouseX, mouseY, posX + window.offsetX + 1, posY + window.offsetY + 13, posX + window.offsetX + window.width - 1, posY + window.offsetY + window.height - 1);
    }

    public boolean isApplicationRunning(AppInfo info) {
        for (Window window : this.windows) {
            if (window == null || ((Application)window.content).getInfo() != info) continue;
            return true;
        }
        return false;
    }

    public void nextWallpaper() {
        if (this.currentWallpaper + 1 < WALLPAPERS.size()) {
            ++this.currentWallpaper;
        }
    }

    public void prevWallpaper() {
        if (this.currentWallpaper - 1 >= 0) {
            --this.currentWallpaper;
        }
    }

    public int getCurrentWallpaper() {
        return this.currentWallpaper;
    }

    public static void addWallpaper(ResourceLocation wallpaper) {
        if (wallpaper != null) {
            WALLPAPERS.add(wallpaper);
        }
    }

    public List<ResourceLocation> getWallapapers() {
        return ImmutableList.copyOf(WALLPAPERS);
    }

    @Nullable
    public Application getApplication(String appId) {
        return APPLICATIONS.stream().filter(app -> app.getInfo().getFormattedId().equals(appId)).findFirst().orElse(null);
    }

    public List<AppInfo> getInstalledApplications() {
        return ImmutableList.copyOf(this.installedApps);
    }

    public boolean isApplicationInstalled(AppInfo info) {
        return info.isSystemApp() || this.installedApps.contains(info);
    }

    private boolean isValidApplication(AppInfo info) {
        if (MrCrayfishDeviceMod.proxy.hasAllowedApplications()) {
            return MrCrayfishDeviceMod.proxy.getAllowedApplications().contains(info);
        }
        return true;
    }

    public void installApplication(AppInfo info, @Nullable Callback<Object> callback) {
        if (!this.isValidApplication(info)) {
            return;
        }
        TaskInstallApp task = new TaskInstallApp(info, pos, true);
        task.setCallback((tagCompound, success) -> {
            if (success) {
                this.installedApps.add(info);
                this.installedApps.sort(AppInfo.SORT_NAME);
            }
            if (callback != null) {
                callback.execute(null, success);
            }
        });
        TaskManager.sendTask(task);
    }

    public void removeApplication(AppInfo info, @Nullable Callback<Object> callback) {
        if (!this.isValidApplication(info)) {
            return;
        }
        TaskInstallApp task = new TaskInstallApp(info, pos, false);
        task.setCallback((tagCompound, success) -> {
            if (success) {
                this.installedApps.remove(info);
            }
            if (callback != null) {
                callback.execute(null, success);
            }
        });
        TaskManager.sendTask(task);
    }

    public static System getSystem() {
        return system;
    }

    public static void setMainDrive(Drive mainDrive) {
        if (Laptop.mainDrive == null) {
            Laptop.mainDrive = mainDrive;
        }
    }

    @Nullable
    public static Drive getMainDrive() {
        return mainDrive;
    }

    public List<Application> getApplications() {
        return APPLICATIONS;
    }

    public TaskBar getTaskBar() {
        return this.bar;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void openContext(Layout layout, int x, int y) {
        layout.updateComponents(x, y);
        this.context = layout;
        layout.init();
    }

    @Override
    public boolean hasContext() {
        return this.context != null;
    }

    @Override
    public void closeContext() {
        this.context = null;
        this.dragging = false;
    }
}

