/*
 * Decompiled with CFR 0.152.
 */
package fr.fifou.economy;

import fr.fifou.economy.ConfigFile;
import fr.fifou.economy.EconomyCommon;
import fr.fifou.economy.TabEconomy;
import fr.fifou.economy.blocks.tileentity.TileEntityRegistery;
import fr.fifou.economy.capability.DefaultMoneyHandler;
import fr.fifou.economy.capability.IMoney;
import fr.fifou.economy.capability.StorageMoney;
import fr.fifou.economy.commands.CommandBalance;
import fr.fifou.economy.commands.CommandPlots;
import fr.fifou.economy.commands.CommandPlotsBuy;
import fr.fifou.economy.entity.EntityInformater;
import fr.fifou.economy.events.EventRegistery;
import fr.fifou.economy.gui.GuiHandler;
import fr.fifou.economy.items.ItemsRegistery;
import fr.fifou.economy.packets.PacketsRegistery;
import fr.fifou.economy.world.gen.structure.VillageComponentShop;
import fr.fifou.economy.world.gen.structure.VillageHandlerShop;
import fr.fifou.economy.world.storage.loot.CustomLootTableList;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="economy", name="Mod Economy", version="1.5", acceptedMinecraftVersions="[1.12.2]")
public class ModEconomy {
    public static final String MODID = "economy";
    @Mod.Instance(value="economy")
    public static ModEconomy instance;
    @SidedProxy(clientSide="fr.fifou.economy.EconomyClient", serverSide="fr.fifou.economy.EconomyServer")
    public static EconomyCommon proxy;
    public static Logger logger;
    public static CreativeTabs tabEconomy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.preInit(event.getSuggestedConfigurationFile());
        ConfigFile.init(event);
        if (ConfigFile.goldNuggetRecipe) {
            ItemStack result = new ItemStack(ItemsRegistery.ITEM_GOLDNUGGET);
            GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151043_k), (ItemStack)result, (float)1.0f);
        }
        EventRegistery.register(event);
        TileEntityRegistery.register();
        PacketsRegistery.registerPackets(event);
        CustomLootTableList.registerLootTables();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        PermissionAPI.registerNode((String)"economy.command.balance", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows players to use the balance command");
        PermissionAPI.registerNode((String)"economy.command.plot", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows OP players to create plot");
        PermissionAPI.registerNode((String)"economy.command.plotbuy", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allows players to buy plots");
        PermissionAPI.registerNode((String)"unlimited_stack", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allows OP players to use the unlimited stack");
        CapabilityManager.INSTANCE.register(IMoney.class, (Capability.IStorage)new StorageMoney(), DefaultMoneyHandler.class);
        if (ConfigFile.doesBankGenerateInVillages) {
            MapGenStructureIO.func_143031_a(VillageComponentShop.class, (String)"economyVillageShopComponent");
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandlerShop());
        }
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "entityInformater"), EntityInformater.class, (String)"entityInformater", (int)1, (Object)instance, (int)64, (int)1, (boolean)true, (int)2566965, (int)6515058);
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBalance());
        event.registerServerCommand((ICommand)new CommandPlots());
        event.registerServerCommand((ICommand)new CommandPlotsBuy());
    }

    static {
        tabEconomy = new TabEconomy(CreativeTabs.getNextID(), "Economy Inc.");
    }
}

