/*
 * Decompiled with CFR 0.152.
 */
package fr.fifou.economy.commands;

import com.google.common.collect.Lists;
import fr.fifou.economy.world.saveddata.ChunksWorldSavedData;
import fr.fifou.economy.world.saveddata.PlotsChunkData;
import fr.fifou.economy.world.saveddata.PlotsData;
import fr.fifou.economy.world.saveddata.PlotsWorldSavedData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.server.permission.PermissionAPI;

public class CommandPlots
extends CommandBase {
    public static ITextComponent[] signText;

    public String func_71517_b() {
        return "plot";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)sender), (String)"economy.command.plot");
        }
        return true;
    }

    public String func_71518_a(ICommandSender arg0) {
        return "commands.plot.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        this.createCommand(server, sender, args);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return Lists.newArrayList((Object[])new String[]{"create", "remove"});
            }
            case 2: {
                return Lists.newArrayList((Object[])new String[]{String.valueOf(sender.func_180425_c().func_177958_n())});
            }
            case 3: {
                return Lists.newArrayList((Object[])new String[]{String.valueOf(sender.func_180425_c().func_177952_p())});
            }
            case 4: {
                return Lists.newArrayList((Object[])new String[]{String.valueOf(sender.func_180425_c().func_177958_n())});
            }
            case 5: {
                return Lists.newArrayList((Object[])new String[]{String.valueOf(sender.func_180425_c().func_177952_p())});
            }
            case 6: {
                return Lists.newArrayList((Object[])new String[]{String.valueOf(sender.func_180425_c().func_177956_o())});
            }
        }
        return Lists.newArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean canProceed = true;
        boolean canProceedRemove = false;
        int indexToProceed = -1;
        if (args.length == 8) {
            if (!args[0].matches("create")) throw new WrongUsageException("commands.plot.usage", new Object[0]);
            int xPosFirst = Integer.valueOf(args[1]);
            int zPosFirst = Integer.valueOf(args[2]);
            int xPosSecond = Integer.valueOf(args[3]);
            int zPosSecond = Integer.valueOf(args[4]);
            int yPos = Integer.valueOf(args[5]);
            String name = args[6];
            double price = Double.valueOf(args[7]);
            if (Math.abs(xPosSecond - xPosFirst) >= 26 || Math.abs(zPosSecond - zPosFirst) >= 26) throw new CommandException("commands.plot.tooManyBlocks", new Object[]{25});
            MapStorage storage = sender.func_130014_f_().getPerWorldStorage();
            World worldIn = server.func_130014_f_();
            PlotsWorldSavedData data = (PlotsWorldSavedData)storage.func_75742_a(PlotsWorldSavedData.class, "economy_PlotsData");
            if (data != null) {
                int i = 0;
                while (true) {
                    if (i >= PlotsWorldSavedData.get(worldIn).getListContainer().size()) break;
                    PlotsData plotsData = PlotsWorldSavedData.get(worldIn).getListContainer().get(i);
                    if (plotsData != null && plotsData.getList().get(0).equals(args[6])) {
                        canProceed = false;
                    }
                    ++i;
                }
            }
            if (!canProceed) throw new CommandException("commands.plot.nameAlreadyExist", new Object[]{25});
            String senderName = sender.func_70005_c_();
            CommandPlots.createData(worldIn, name, sender, xPosFirst, zPosFirst, xPosSecond, zPosSecond, yPos, price);
            CommandPlots.saveAll(server, sender, false);
            return;
        } else {
            if (args.length != 2 || !args[0].matches("remove")) return;
            String namePlot = args[1];
            MapStorage storage = sender.func_130014_f_().getPerWorldStorage();
            World worldIn = server.func_130014_f_();
            PlotsWorldSavedData data = (PlotsWorldSavedData)storage.func_75742_a(PlotsWorldSavedData.class, "economy_PlotsData");
            if (data != null) {
                int i = 0;
                while (true) {
                    if (i >= PlotsWorldSavedData.get(worldIn).getListContainer().size()) break;
                    PlotsData plotsData = PlotsWorldSavedData.get(worldIn).getListContainer().get(i);
                    if (plotsData != null && plotsData.getList().get(0).equals(namePlot)) {
                        indexToProceed = i;
                        canProceedRemove = true;
                    }
                    ++i;
                }
            }
            if (!canProceedRemove || indexToProceed == -1) return;
            PlotsWorldSavedData.get(worldIn).getListContainer().remove(indexToProceed);
            PlotsWorldSavedData.get(worldIn).func_76185_a();
            CommandPlots.saveAll(server, sender, false);
        }
    }

    public static void createData(World worldIn, String name, ICommandSender sender, int xPosFirst, int zPosFirst, int xPosSecond, int zPosSecond, int yPos, double priceIn) throws CommandException {
        EntityPlayer playerIn = worldIn.func_72924_a(sender.func_70005_c_());
        List<ChunkPos> listChunk = CommandPlots.calculatingChunks(worldIn, xPosFirst, zPosFirst, xPosSecond, zPosSecond, yPos);
        PlotsData plotsData = new PlotsData(name, playerIn.func_110124_au().toString(), xPosFirst, zPosFirst, xPosSecond, zPosSecond, yPos, priceIn, false);
        PlotsChunkData chunkData = new PlotsChunkData(listChunk);
        PlotsWorldSavedData.get(worldIn).getListContainer().add(plotsData);
        PlotsWorldSavedData.get(worldIn).func_76185_a();
        ChunksWorldSavedData.get(worldIn).getListContainer().add(chunkData);
        ChunksWorldSavedData.get(worldIn).func_76185_a();
        CommandPlots.createBorders(worldIn, name, playerIn.func_70005_c_(), xPosFirst, zPosFirst, xPosSecond, zPosSecond, yPos, priceIn);
        System.out.println(playerIn);
    }

    public static List<ChunkPos> calculatingChunks(World worldIn, int xPosFirst, int zPosFirst, int xPosSecond, int zPosSecond, int yPos) {
        int maxZToTake;
        int minusZToTake;
        int maxXToTake;
        int minusXToTake;
        Iterable itPos = BlockPos.func_177980_a((BlockPos)new BlockPos(xPosFirst, yPos, zPosFirst), (BlockPos)new BlockPos(xPosSecond, yPos, zPosSecond));
        ArrayList<ChunkPos> listChunk = new ArrayList<ChunkPos>();
        if (xPosFirst < xPosSecond) {
            minusXToTake = Math.floorDiv(xPosFirst, 16);
            maxXToTake = Math.floorDiv(xPosSecond, 16);
        } else {
            minusXToTake = Math.floorDiv(xPosSecond, 16);
            maxXToTake = Math.floorDiv(xPosFirst, 16);
        }
        if (zPosFirst < zPosSecond) {
            minusZToTake = Math.floorDiv(zPosFirst, 16);
            maxZToTake = Math.floorDiv(zPosSecond, 16);
        } else {
            minusZToTake = Math.floorDiv(zPosSecond, 16);
            maxZToTake = Math.floorDiv(zPosFirst, 16);
        }
        for (int x = minusXToTake; x <= maxXToTake; ++x) {
            for (int z = minusZToTake; z <= maxZToTake; ++z) {
                Chunk chunkIn = worldIn.func_72964_e(x, z);
                listChunk.add(chunkIn.func_76632_l());
            }
        }
        return listChunk;
    }

    public static void createBorders(World worldIn, String name, String senderName, int xPosFirst, int zPosFirst, int xPosSecond, int zPosSecond, int yPos, double priceIn) {
        AxisAlignedBB area = new AxisAlignedBB(new BlockPos(xPosFirst, yPos, zPosFirst), new BlockPos(xPosSecond, yPos, zPosSecond));
        AxisAlignedBB areaGrown = area.func_72314_b(1.0, 0.0, 1.0);
        Vec3d vec = CommandPlots.getCenter(xPosFirst, yPos, zPosFirst, xPosSecond, yPos, zPosSecond);
        BlockPos posSign = new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        worldIn.func_175698_g(posSign);
        Iterable posToPlace = BlockPos.func_177980_a((BlockPos)new BlockPos(areaGrown.field_72340_a, (double)yPos, areaGrown.field_72339_c), (BlockPos)new BlockPos(areaGrown.field_72336_d, (double)yPos, areaGrown.field_72334_f));
        Iterable posToRemove = BlockPos.func_177980_a((BlockPos)new BlockPos(area.field_72340_a, (double)yPos, area.field_72339_c), (BlockPos)new BlockPos(area.field_72336_d, (double)yPos, area.field_72334_f));
        for (BlockPos posNew : posToPlace) {
            worldIn.func_175656_a(posNew, Blocks.field_150333_U.func_176223_P());
        }
        for (BlockPos posNew : posToRemove) {
            worldIn.func_175656_a(posNew, Blocks.field_150350_a.func_176223_P());
        }
        worldIn.func_180501_a(posSign, Blocks.field_150472_an.func_176223_P(), 2);
        TileEntitySign tileEntityIn = new TileEntitySign();
        tileEntityIn.func_145829_t();
        worldIn.func_175690_a(posSign, (TileEntity)tileEntityIn);
        TileEntitySign signTe = (TileEntitySign)worldIn.func_175625_s(posSign);
        if (signTe != null) {
            signTe.field_145915_a[0] = new TextComponentString("[" + name + "]").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE));
            signTe.field_145915_a[1] = new TextComponentString(senderName).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLACK));
            signTe.field_145915_a[2] = new TextComponentString(String.valueOf(priceIn)).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLACK));
            signTe.field_145915_a[3] = new TextComponentString("[BUY]").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GREEN));
            signTe.func_70296_d();
        }
    }

    public static Vec3d getCenter(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new Vec3d(minX + (maxX - minX) * 0.5, minY + (maxY - minY) * 0.5, minZ + (maxZ - minZ) * 0.5);
    }

    private static void saveAll(MinecraftServer server, ICommandSender sender, boolean flush) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.save.start", new Object[0]));
        if (server.func_184103_al() != null) {
            server.func_184103_al().func_72389_g();
        }
        try {
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                boolean flag = worldserver.field_73058_d;
                worldserver.field_73058_d = false;
                worldserver.func_73044_a(true, (IProgressUpdate)null);
                worldserver.field_73058_d = flag;
            }
            if (flush) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.save.flushStart", new Object[0]));
                for (int j = 0; j < server.field_71305_c.length; ++j) {
                    if (server.field_71305_c[j] == null) continue;
                    WorldServer worldserver1 = server.field_71305_c[j];
                    boolean flag1 = worldserver1.field_73058_d;
                    worldserver1.field_73058_d = false;
                    worldserver1.func_104140_m();
                    worldserver1.field_73058_d = flag1;
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.save.flushEnd", new Object[0]));
            }
        }
        catch (MinecraftException minecraftexception) {
            System.out.println("Exception while loading file datas.");
        }
    }
}

