/*
 * Decompiled with CFR 0.152.
 */
package fr.fifou.economy.commands;

import com.google.common.collect.Lists;
import fr.fifou.economy.capability.CapabilityLoading;
import fr.fifou.economy.capability.IMoney;
import fr.fifou.economy.world.saveddata.PlotsData;
import fr.fifou.economy.world.saveddata.PlotsWorldSavedData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.server.permission.PermissionAPI;

public class CommandPlotsBuy
extends CommandBase {
    public String func_71517_b() {
        return "plotbuy";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)sender), (String)"economy.command.plotbuy");
        }
        return true;
    }

    public String func_71518_a(ICommandSender arg0) {
        return "commands.plotbuy.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean canProceedBuy = false;
        int indexToProceedBuy = -1;
        if (!args[0].matches("buy")) throw new WrongUsageException("commands.plot.usage", new Object[0]);
        String namePlot = args[1];
        MapStorage storage = sender.func_130014_f_().getPerWorldStorage();
        World worldIn = sender.func_130014_f_();
        PlotsWorldSavedData data = (PlotsWorldSavedData)storage.func_75742_a(PlotsWorldSavedData.class, "economy_PlotsData");
        if (data != null) {
            int i = 0;
            while (true) {
                boolean bought;
                if (i >= PlotsWorldSavedData.get(worldIn).getListContainer().size()) break;
                PlotsData plotsData = PlotsWorldSavedData.get(worldIn).getListContainer().get(i);
                if (plotsData != null && plotsData.getList().get(0).equals(namePlot) && !(bought = plotsData.getBought())) {
                    indexToProceedBuy = i;
                    canProceedBuy = true;
                }
                ++i;
            }
        }
        if (!canProceedBuy || indexToProceedBuy == -1) throw new WrongUsageException("commands.plot.notExistOrBought", new Object[0]);
        PlotsData plotsData = PlotsWorldSavedData.get(worldIn).getListContainer().get(indexToProceedBuy);
        EntityPlayer player = worldIn.func_72924_a(sender.func_70005_c_());
        double playerMoney = ((IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).getMoney();
        if (!(playerMoney >= plotsData.price)) {
            throw new WrongUsageException("commands.plot.notEnough", new Object[0]);
        }
        plotsData.bought = true;
        plotsData.owner = player.func_110124_au().toString();
        PlotsWorldSavedData.get(worldIn).func_76185_a();
        double newMoney = playerMoney - plotsData.price;
        ((IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).setMoney(newMoney);
        ((IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).sync(player);
        player.func_145747_a((ITextComponent)new TextComponentString("Success."));
        this.replaceSign(worldIn, plotsData.xPosFirst, plotsData.yPos, plotsData.zPosFirst, plotsData.xPosSecond, plotsData.zPosSecond, plotsData.name, plotsData.owner);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return Lists.newArrayList((Object[])new String[]{"buy"});
            }
        }
        return Lists.newArrayList();
    }

    public static Vec3d getCenter(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new Vec3d(minX + (maxX - minX) * 0.5, minY + (maxY - minY) * 0.5, minZ + (maxZ - minZ) * 0.5);
    }

    public void replaceSign(World worldIn, int xPosFirst, int yPos, int zPosFirst, int xPosSecond, int zPosSecond, String name, String owner) {
        EntityPlayer playerIn = worldIn.func_152378_a(UUID.fromString(owner));
        if (playerIn != null) {
            Vec3d vec = CommandPlotsBuy.getCenter(xPosFirst, yPos, zPosFirst, xPosSecond, yPos, zPosSecond);
            BlockPos posSign = new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            worldIn.func_175698_g(posSign);
            worldIn.func_180501_a(posSign, Blocks.field_150472_an.func_176223_P(), 2);
            TileEntitySign tileEntityIn = new TileEntitySign();
            tileEntityIn.func_145829_t();
            worldIn.func_175690_a(posSign, (TileEntity)tileEntityIn);
            TileEntitySign signTe = (TileEntitySign)worldIn.func_175625_s(posSign);
            if (signTe != null) {
                signTe.field_145915_a[0] = new TextComponentString("[" + name + "]").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE));
                signTe.field_145915_a[1] = new TextComponentString("Owned by").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLACK));
                signTe.field_145915_a[2] = new TextComponentString(playerIn.func_70005_c_()).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLACK));
                signTe.field_145915_a[3] = new TextComponentString("[SOLD]").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.RED));
                signTe.func_70296_d();
            }
        }
    }
}

