/*
 * Decompiled with CFR 0.152.
 */
package fr.fifou.economy.events;

import fr.fifou.economy.ConfigFile;
import fr.fifou.economy.capability.CapabilityLoading;
import fr.fifou.economy.capability.IMoney;
import fr.fifou.economy.capability.ProviderMoney;
import fr.fifou.economy.items.ItemsRegistery;
import fr.fifou.economy.mysql.MySQL;
import fr.fifou.economy.world.saveddata.ChunksWorldSavedData;
import fr.fifou.economy.world.saveddata.PlotsChunkData;
import fr.fifou.economy.world.saveddata.PlotsData;
import fr.fifou.economy.world.saveddata.PlotsWorldSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventClassCommon {
    private static final Random rand = new Random();

    @SubscribeEvent
    public void onSmeltingEvent(PlayerEvent.ItemSmeltedEvent event) {
        if (ConfigFile.goldNuggetRecipe && event.smelting.func_77973_b().equals(ItemsRegistery.ITEM_GOLDNUGGET)) {
            double valeur = rand.nextDouble();
            String valeur2 = Double.toString(valeur);
            String valeur3 = valeur2.substring(0, 4);
            event.smelting.func_77983_a("weight", (NBTBase)new NBTTagString(valeur3));
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("economy", ":MONEY"), (ICapabilityProvider)new ProviderMoney());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        IMoney original = CapabilityLoading.getMoneyHandler((Entity)event.getOriginal());
        IMoney clone = CapabilityLoading.getMoneyHandler(event.getEntity());
        clone.setMoney(original.getMoney());
        clone.setName(original.getName());
        clone.setOnlineUUID(original.getOnlineUUID());
        clone.sync(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onplayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ((IMoney)event.player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).sync((EntityPlayer)((EntityPlayerMP)event.player));
        ((IMoney)event.player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).setName(event.player.func_70005_c_());
        ((IMoney)event.player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).setOnlineUUID(event.player.func_110124_au().toString());
        if (ConfigFile.connectDB) {
            MySQL.check(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (ConfigFile.connectDB) {
            MySQL.update(event.player);
        }
    }

    @SubscribeEvent
    public void onPlacedBlock(BlockEvent.PlaceEvent event) {
        World worldIn = event.getWorld();
        ArrayList<ChunkPos> listPos = new ArrayList<ChunkPos>();
        MapStorage storage = worldIn.getPerWorldStorage();
        ChunksWorldSavedData data = (ChunksWorldSavedData)storage.func_75742_a(ChunksWorldSavedData.class, "economy_PlotsChunkData");
        if (data != null) {
            List<PlotsChunkData> listC = ChunksWorldSavedData.get(worldIn).getListContainer();
            for (int i = 0; i < listC.size(); ++i) {
                PlotsChunkData plotsChunkData = listC.get(i);
                for (int j = 0; j < plotsChunkData.getList().size(); ++j) {
                    String s = plotsChunkData.getList().get(j);
                    int xPos = Integer.valueOf(s.substring(s.indexOf("[") + 1, s.indexOf(",")));
                    int zPos = Integer.valueOf(s.substring(s.indexOf(",") + 2, s.indexOf("]")));
                    listPos.add(new ChunkPos(xPos, zPos));
                }
            }
        }
        for (ChunkPos pos : listPos) {
            if (!new ChunkPos(event.getPos()).equals((Object)pos)) continue;
            Vec3d vec = new Vec3d((double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p());
            ArrayList<AxisAlignedBB> listAABB = new ArrayList<AxisAlignedBB>();
            PlotsWorldSavedData plotsDataWSD = (PlotsWorldSavedData)storage.func_75742_a(PlotsWorldSavedData.class, "economy_PlotsData");
            UUID uuidOwner = null;
            if (plotsDataWSD != null) {
                List<PlotsData> listC = PlotsWorldSavedData.get(worldIn).getListContainer();
                for (int i = 0; i < listC.size(); ++i) {
                    PlotsData plotsData = PlotsWorldSavedData.get(worldIn).getListContainer().get(i);
                    for (int j = 0; j < plotsData.getList().size(); ++j) {
                        uuidOwner = UUID.fromString(plotsData.getList().get(1));
                        int xPosFirst = Integer.valueOf(plotsData.getList().get(2));
                        int zPosFirst = Integer.valueOf(plotsData.getList().get(3));
                        int xPosSecond = Integer.valueOf(plotsData.getList().get(4));
                        int zPosSecond = Integer.valueOf(plotsData.getList().get(5));
                        listAABB.add(new AxisAlignedBB((double)xPosFirst, 0.0, (double)zPosFirst, (double)xPosSecond, 255.0, (double)zPosSecond).func_72314_b(2.0, 1.0, 2.0));
                    }
                }
            }
            for (AxisAlignedBB checker : listAABB) {
                if (!checker.func_72318_a(vec) || uuidOwner == null) continue;
                if (!event.getPlayer().func_110124_au().equals(uuidOwner)) {
                    event.setCanceled(true);
                    continue;
                }
                if (!event.getPlayer().func_184812_l_()) continue;
                event.setCanceled(false);
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        World worldIn = event.getWorld();
        ArrayList<ChunkPos> listPos = new ArrayList<ChunkPos>();
        MapStorage storage = worldIn.getPerWorldStorage();
        ChunksWorldSavedData data = (ChunksWorldSavedData)storage.func_75742_a(ChunksWorldSavedData.class, "economy_PlotsChunkData");
        if (data != null) {
            List<PlotsChunkData> listC = ChunksWorldSavedData.get(worldIn).getListContainer();
            for (int i = 0; i < listC.size(); ++i) {
                PlotsChunkData plotsChunkData = listC.get(i);
                for (int j = 0; j < plotsChunkData.getList().size(); ++j) {
                    String s = plotsChunkData.getList().get(j);
                    int xPos = Integer.valueOf(s.substring(s.indexOf("[") + 1, s.indexOf(",")));
                    int zPos = Integer.valueOf(s.substring(s.indexOf(",") + 2, s.indexOf("]")));
                    listPos.add(new ChunkPos(xPos, zPos));
                }
            }
        }
        for (ChunkPos pos : listPos) {
            if (!new ChunkPos(event.getPos()).equals((Object)pos)) continue;
            Vec3d vec = new Vec3d((double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p());
            ArrayList<AxisAlignedBB> listAABB = new ArrayList<AxisAlignedBB>();
            PlotsWorldSavedData plotsDataWSD = (PlotsWorldSavedData)storage.func_75742_a(PlotsWorldSavedData.class, "economy_PlotsData");
            UUID uuidOwner = null;
            if (plotsDataWSD != null) {
                List<PlotsData> listC = PlotsWorldSavedData.get(worldIn).getListContainer();
                for (int i = 0; i < listC.size(); ++i) {
                    PlotsData plotsData = PlotsWorldSavedData.get(worldIn).getListContainer().get(i);
                    for (int j = 0; j < plotsData.getList().size(); ++j) {
                        uuidOwner = UUID.fromString(plotsData.getList().get(1));
                        int xPosFirst = Integer.valueOf(plotsData.getList().get(2));
                        int zPosFirst = Integer.valueOf(plotsData.getList().get(3));
                        int xPosSecond = Integer.valueOf(plotsData.getList().get(4));
                        int zPosSecond = Integer.valueOf(plotsData.getList().get(5));
                        listAABB.add(new AxisAlignedBB((double)xPosFirst, 0.0, (double)zPosFirst, (double)xPosSecond, 255.0, (double)zPosSecond).func_72314_b(2.0, 1.0, 2.0));
                    }
                }
            }
            for (AxisAlignedBB checker : listAABB) {
                if (!checker.func_72318_a(vec) || uuidOwner == null) continue;
                if (!event.getPlayer().func_110124_au().equals(uuidOwner)) {
                    event.setCanceled(true);
                    continue;
                }
                if (!event.getPlayer().func_184812_l_()) continue;
                event.setCanceled(false);
            }
        }
    }
}

