/*
 * Decompiled with CFR 0.152.
 */
package fr.fifou.economy.packets;

import fr.fifou.economy.capability.CapabilityLoading;
import fr.fifou.economy.capability.IMoney;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketMoneyData
implements IMessage {
    private double money;
    private boolean linked;
    private String name;
    private String onlineUUID;

    public PacketMoneyData() {
    }

    public PacketMoneyData(double money, boolean linked, String name, String OnUUID) {
        this.money = money;
        this.linked = linked;
        this.name = name;
        this.onlineUUID = OnUUID;
    }

    public void fromBytes(ByteBuf buf) {
        this.money = buf.readDouble();
        this.linked = buf.readBoolean();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.onlineUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.money);
        buf.writeBoolean(this.linked);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.onlineUUID);
    }

    public static class PacketMoneyHandlerServer
    implements IMessageHandler<PacketMoneyData, IMessage> {
        public IMessage onMessage(PacketMoneyData message, MessageContext ctx) {
            WorldServer thread = ctx.getServerHandler().field_147369_b.func_71121_q();
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            thread.func_152344_a(() -> PacketMoneyHandlerServer.lambda$onMessage$0((EntityPlayer)player, message));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(EntityPlayer player, PacketMoneyData message) {
            IMoney capabilities;
            if (player != null && (capabilities = (IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)) != null) {
                capabilities.setMoney(message.money);
                capabilities.setLinked(message.linked);
                capabilities.setName(message.name);
                capabilities.setOnlineUUID(message.onlineUUID);
            }
        }
    }

    public static class PacketMoneyHandlerClient
    implements IMessageHandler<PacketMoneyData, IMessage> {
        public IMessage onMessage(PacketMoneyData message, MessageContext ctx) {
            Minecraft thread = Minecraft.func_71410_x();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            thread.func_152344_a(() -> PacketMoneyHandlerClient.lambda$onMessage$0((EntityPlayer)player, message));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(EntityPlayer player, PacketMoneyData message) {
            IMoney capabilities;
            if (player != null && (capabilities = (IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)) != null) {
                capabilities.setMoney(message.money);
                capabilities.setLinked(message.linked);
                capabilities.setName(message.name);
                capabilities.setOnlineUUID(message.onlineUUID);
            }
        }
    }
}

