/*
 * Decompiled with CFR 0.152.
 */
package fr.fifou.economy.packets;

import fr.fifou.economy.blocks.tileentity.TileEntityBlockSeller;
import fr.fifou.economy.capability.CapabilityLoading;
import fr.fifou.economy.capability.IMoney;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSellerFundsTotal
implements IMessage {
    private double fundstotal;
    private int x;
    private int y;
    private int z;
    private int amount;
    private boolean recovery;

    public PacketSellerFundsTotal() {
    }

    public PacketSellerFundsTotal(double fundstotalS, int xS, int yS, int zS, int amountS, boolean recoveryS) {
        this.fundstotal = fundstotalS;
        this.x = xS;
        this.y = yS;
        this.z = zS;
        this.amount = amountS;
        this.recovery = recoveryS;
    }

    public void fromBytes(ByteBuf buf) {
        this.fundstotal = buf.readDouble();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.amount = buf.readInt();
        this.recovery = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.fundstotal);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.amount);
        buf.writeBoolean(this.recovery);
    }

    public static class Handler
    implements IMessageHandler<PacketSellerFundsTotal, IMessage> {
        public IMessage onMessage(PacketSellerFundsTotal message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            TileEntityBlockSeller te = (TileEntityBlockSeller)world.func_175625_s(pos);
            if (te != null) {
                if (!message.recovery) {
                    if (!te.getStackInSlot(0).func_190926_b()) {
                        boolean admin = te.getAdmin();
                        if (!admin) {
                            te.setFundsTotal(message.fundstotal);
                            te.getStackInSlot(0);
                            player.func_191521_c(te.getStackInSlot(0).func_77979_a(1));
                            int newAmount = message.amount - 1;
                            te.setAmount(newAmount);
                            te.func_70296_d();
                        } else if (admin) {
                            te.setFundsTotal(message.fundstotal);
                            te.setAmount(message.amount);
                            ItemStack stackToGive = te.getStackInSlot(0).func_77946_l().func_77979_a(1);
                            player.func_191521_c(stackToGive);
                            te.func_70296_d();
                        }
                    }
                } else if (message.recovery) {
                    ((IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).setMoney(((IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).getMoney() + message.fundstotal);
                    ((IMoney)player.getCapability(CapabilityLoading.CAPABILITY_MONEY, null)).sync((EntityPlayer)player);
                    te.setFundsTotal(0.0);
                    te.func_70296_d();
                }
            }
            return null;
        }
    }
}

