/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget;

import com.google.common.collect.Sets;
import com.kamesuta.mc.bnnwidget.WCommon;
import com.kamesuta.mc.bnnwidget.WContainer;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;

public class WFrame
extends GuiScreen
implements WCommon,
WContainer<WCommon> {
    @Nullable
    protected GuiScreen parent;
    @Nonnull
    private WPanel contentPane = new WPanel(new R(new Coord[0]));
    @Nonnull
    protected final WEvent event = new WEvent(this);
    protected boolean initialized;
    protected boolean fixGuiScale;
    protected boolean doesPauseGui = true;
    protected boolean closed = false;
    private float width;
    private float height;
    protected boolean closeRequest;
    @Nullable
    protected Point mouselast;
    @Nonnull
    protected final MouseButton mousebutton = new MouseButton();
    private boolean isDispatchClosable = true;

    @Nonnull
    public WFrame setWidth(float width) {
        this.width = width;
        this.field_146294_l = (int)width;
        return this;
    }

    @Nonnull
    public WFrame setHeight(float height) {
        this.height = height;
        this.field_146295_m = (int)height;
        return this;
    }

    public float guiWidth() {
        if (this.field_146294_l != (int)this.width) {
            this.width = this.field_146294_l;
        }
        return this.width;
    }

    public float guiHeight() {
        if (this.field_146295_m != (int)this.height) {
            this.height = this.field_146295_m;
        }
        return this.height;
    }

    public float width() {
        if (this.fixGuiScale) {
            return WFrame.getDisplayWidth();
        }
        return this.guiWidth();
    }

    public float height() {
        if (this.fixGuiScale) {
            return WFrame.getDisplayHeight();
        }
        return this.guiHeight();
    }

    protected static float getDisplayWidth() {
        return WRenderer.mc.field_71443_c;
    }

    protected static float getDisplayHeight() {
        return WRenderer.mc.field_71440_d;
    }

    public float guiScaleX() {
        return this.guiWidth() / WFrame.getDisplayWidth();
    }

    public float guiScaleY() {
        return this.guiHeight() / WFrame.getDisplayHeight();
    }

    public float guiScale() {
        return Math.min(this.guiScaleX(), this.guiScaleY());
    }

    public float scaleX() {
        return 1.0f / this.guiScaleX();
    }

    public float scaleY() {
        return 1.0f / this.guiScaleY();
    }

    public float scale() {
        return 1.0f / this.guiScale();
    }

    public WFrame(@Nullable GuiScreen parent) {
        this.parent = parent;
        this.field_146297_k = WRenderer.mc;
    }

    public WFrame() {
    }

    @Nonnull
    public Area getAbsolute() {
        return Area.size(0.0f, 0.0f, this.width(), this.height());
    }

    @Nonnull
    public Point getMouseAbsolute() {
        return new Point((float)Mouse.getX() * this.width() / (float)FMLClientHandler.instance().getClient().field_71443_c, this.height() - (float)Mouse.getY() * this.height() / (float)FMLClientHandler.instance().getClient().field_71440_d - 1.0f);
    }

    @Override
    @Nonnull
    public List<WCommon> getContainer() {
        return this.getContentPane().getContainer();
    }

    @Override
    public boolean add(@Nonnull WCommon widget) {
        return this.getContentPane().add(widget);
    }

    @Override
    public boolean remove(@Nonnull WCommon widget) {
        return this.getContentPane().remove(widget);
    }

    @Nonnull
    public WPanel getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(@Nonnull WPanel panel) {
        this.contentPane = panel;
    }

    public void func_73866_w_() {
        this.sInitGui();
        if (!this.initialized) {
            this.initPane();
            this.initWidget();
            this.initialized = true;
        }
    }

    protected void sInitGui() {
        this.checkParentAndClose();
        if (this.parent != null) {
            this.parent.func_73866_w_();
        }
        super.func_73866_w_();
    }

    protected void initPane() {
        Area gp = this.getAbsolute();
        Point p = this.getMouseAbsolute();
        this.dispatchOnInit(gp, p);
    }

    protected void initWidget() {
    }

    public void func_146280_a(@Nullable Minecraft mc, int i, int j) {
        this.sSetWorldAndResolution(WRenderer.mc, i, j);
    }

    protected void sSetWorldAndResolution(@Nonnull Minecraft mc, int i, int j) {
        this.checkParentAndClose();
        if (this.parent != null) {
            this.parent.func_146280_a(mc, i, j);
        }
        super.func_146280_a(mc, i, j);
    }

    public void drawScreen(int mousex, int mousey, float f, float opacity, @Nullable RenderOption opt) {
        this.sDrawScreen(mousex, mousey, f);
        OpenGL.glPushMatrix();
        if (this.fixGuiScale) {
            OpenGL.glScalef(this.guiScaleX(), this.guiScaleY(), 1.0f);
        }
        Area gp = this.getAbsolute();
        Point p = this.getMouseAbsolute();
        this.dispatchDraw(gp, p, f, opacity, opt != null ? opt : new RenderOption());
        OpenGL.glPopMatrix();
    }

    public void func_73863_a(int mousex, int mousey, float f) {
        this.drawScreen(mousex, mousey, f, this.getOpacity(), null);
    }

    protected float getOpacity() {
        return 1.0f;
    }

    protected void sDrawScreen(int mousex, int mousey, float f) {
        this.checkParentAndClose();
        GuiScreen parent = this.parent;
        if (parent != null) {
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(0.0f, 0.0f, -200.0f);
            parent.func_73863_a(mousex, mousey, f);
            OpenGL.glPopMatrix();
        }
        super.func_73863_a(mousex, mousey, f);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        this.mousebutton.addButton(button);
        this.event.updateDoubleClick();
        Area gp = this.getAbsolute();
        Point p = this.getMouseAbsolute();
        this.dispatchMouseClicked(gp, p, button);
        this.sMouseClicked(x, y, button);
    }

    protected void sMouseClicked(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
    }

    protected void func_146286_b(int x, int y, int button) {
        this.sMouseReleased(x, y, button);
    }

    protected void sMouseReleased(int x, int y, int button) {
        super.func_146286_b(x, y, button);
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        Area gp = this.getAbsolute();
        Point p = this.getMouseAbsolute();
        this.dispatchMouseDragged(gp, p, button, time);
        this.event.updateDoubleClick();
        this.sMouseClickMove(x, y, button, time);
    }

    protected void sMouseClickMove(int x, int y, int button, long time) {
        super.func_146273_a(x, y, button, time);
    }

    public void func_73876_c() {
        this.sUpdateScreen();
        Point p = this.getMouseAbsolute();
        Area gp = this.getAbsolute();
        this.dispatchUpdate(gp, p);
        MouseButton.MouseState button = this.mousebutton.checkButton();
        Integer lastRemoved = button.lastRemoved;
        if (lastRemoved != null) {
            this.dispatchMouseReleased(gp, p, lastRemoved);
        }
        if (!p.equals(this.mouselast)) {
            this.mouselast = p;
            this.dispatchMouseMoved(gp, p, button.lastPressed != null ? button.lastPressed : -1);
        }
        if (this.closeRequest && this.dispatchOnClosing(gp, p)) {
            this.close();
        }
    }

    protected void sUpdateScreen() {
        this.checkParentAndClose();
        if (this.parent != null) {
            this.parent.func_73876_c();
        }
        super.func_73876_c();
    }

    protected void func_73869_a(char c, int keycode) {
        Area gp = this.getAbsolute();
        Point p = this.getMouseAbsolute();
        this.dispatchKeyTyped(gp, p, c, keycode);
        this.sKeyTyped(c, keycode);
    }

    protected void sKeyTyped(char c, int keycode) {
        if (keycode == 1) {
            this.requestClose();
        }
    }

    protected void close() {
        if (WRenderer.mc.field_71462_r == this) {
            WRenderer.mc.func_147108_a(this.parent);
        } else {
            this.closed = true;
        }
    }

    public void requestClose() {
        this.dispatchOnCloseRequest();
        this.closeRequest = true;
    }

    @Deprecated
    protected void cancelCloseRequest() {
        this.closeRequest = false;
    }

    public void func_146281_b() {
        this.onClosed();
        this.sOnGuiClosed();
    }

    public void sOnGuiClosed() {
        super.func_146281_b();
    }

    protected void onClosed() {
    }

    public void func_146274_d() throws IOException {
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            Area gp = this.getAbsolute();
            Point p = this.getMouseAbsolute();
            this.dispatchMouseScrolled(gp, p, i);
        }
        this.sHandleMouseInput();
    }

    protected void sHandleMouseInput() throws IOException {
        super.func_146274_d();
    }

    public void func_146282_l() throws IOException {
        this.sHandleKeyboardInput();
    }

    protected void sHandleKeyboardInput() throws IOException {
        super.func_146282_l();
    }

    public boolean func_73868_f() {
        return this.sDoesGuiPauseGame();
    }

    protected boolean sDoesGuiPauseGame() {
        return this.doesPauseGui || this.parentDoesGuiPauseGame();
    }

    protected boolean parentDoesGuiPauseGame() {
        this.checkParentAndClose();
        return this.parent != null && this.parent.func_73868_f();
    }

    @Nonnull
    public WFrame setFixGuiScale(boolean doesFixScale) {
        this.fixGuiScale = doesFixScale;
        return this;
    }

    @Nonnull
    public WFrame setGuiPauseGame(boolean doesPause) {
        this.doesPauseGui = doesPause;
        return this;
    }

    public boolean isParentClosed() {
        if (this.parent instanceof WFrame) {
            return ((WFrame)this.parent).closed;
        }
        return false;
    }

    public void closeParent() {
        this.parent = WFrame.getParentOrNull(this.parent);
    }

    public void checkParentAndClose() {
        if (this.isParentClosed()) {
            this.closeParent();
        }
    }

    public void setParent(@Nullable GuiScreen parent) {
        this.parent = parent;
    }

    @Nullable
    public GuiScreen getParent() {
        return this.parent;
    }

    @Nullable
    public static GuiScreen getCurrent() {
        return WRenderer.mc.field_71462_r;
    }

    @Nullable
    public static GuiScreen getParentOrNull(@Nullable GuiScreen screen) {
        if (screen instanceof WFrame) {
            return ((WFrame)screen).parent;
        }
        return null;
    }

    @Nullable
    public static GuiScreen getParentOrThis(@Nullable GuiScreen screen) {
        if (screen instanceof WFrame) {
            return ((WFrame)screen).parent;
        }
        return screen;
    }

    @Nullable
    public static GuiScreen getParentOrNull() {
        return WFrame.getParentOrNull(WFrame.getCurrent());
    }

    @Nullable
    public static GuiScreen getParentOrThis() {
        return WFrame.getParentOrThis(WFrame.getCurrent());
    }

    @Override
    public void onAdded() {
    }

    protected void dispatchOnAdded() {
        this.onAdded();
        this.getContentPane().onAdded();
    }

    @Override
    public void onInit(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
    }

    protected void dispatchOnInit(@Nonnull Area pgp, @Nonnull Point p) {
        this.onInit(this.event, pgp, p);
        this.getContentPane().onInit(this.event, pgp, p);
    }

    @Deprecated
    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity) {
    }

    @Override
    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
        this.draw(ev, pgp, p, frame, popacity);
    }

    protected void dispatchDraw(@Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
        this.draw(this.event, pgp, p, frame, popacity, opt);
        this.getContentPane().draw(this.event, pgp, p, frame, popacity, opt);
    }

    @Override
    public void update(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
    }

    protected void dispatchUpdate(@Nonnull Area pgp, @Nonnull Point p) {
        this.update(this.event, pgp, p);
        this.getContentPane().update(this.event, pgp, p);
    }

    @Override
    public boolean keyTyped(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, char c, int keycode) {
        return false;
    }

    protected boolean dispatchKeyTyped(@Nonnull Area pgp, @Nonnull Point p, char c, int keycode) {
        return this.getContentPane().keyTyped(this.event, pgp, p, c, keycode) || this.keyTyped(this.event, pgp, p, c, keycode);
    }

    @Override
    public boolean mouseScrolled(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int scroll) {
        return false;
    }

    protected boolean dispatchMouseScrolled(@Nonnull Area pgp, @Nonnull Point p, int scroll) {
        return this.getContentPane().mouseScrolled(this.event, pgp, p, scroll) || this.mouseScrolled(this.event, pgp, p, scroll);
    }

    @Override
    public boolean mouseMoved(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        return false;
    }

    protected boolean dispatchMouseMoved(@Nonnull Area pgp, @Nonnull Point p, int button) {
        return this.getContentPane().mouseMoved(this.event, pgp, p, button) || this.mouseMoved(this.event, pgp, p, button);
    }

    @Override
    public boolean mouseClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        return false;
    }

    protected boolean dispatchMouseClicked(@Nonnull Area pgp, @Nonnull Point p, int button) {
        return this.getContentPane().mouseClicked(this.event, pgp, p, button) || this.mouseClicked(this.event, pgp, p, button);
    }

    @Override
    public boolean mouseDragged(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button, long time) {
        return false;
    }

    protected boolean dispatchMouseDragged(@Nonnull Area pgp, @Nonnull Point p, int button, long time) {
        return this.getContentPane().mouseDragged(this.event, pgp, p, button, time) || this.mouseDragged(this.event, pgp, p, button, time);
    }

    @Override
    public boolean mouseReleased(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        return false;
    }

    protected boolean dispatchMouseReleased(@Nonnull Area pgp, @Nonnull Point p, int button) {
        return this.getContentPane().mouseReleased(this.event, pgp, p, button) || this.mouseReleased(this.event, pgp, p, button);
    }

    @Override
    public boolean onCloseRequest() {
        return true;
    }

    protected boolean dispatchOnCloseRequest() {
        boolean a = this.getContentPane().onCloseRequest();
        boolean b = this.isDispatchClosable = this.onCloseRequest();
        return a && b;
    }

    @Override
    public boolean onClosing(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
        return true;
    }

    protected boolean dispatchOnClosing(@Nonnull Area pgp, @Nonnull Point p) {
        boolean a = this.getContentPane().onClosing(this.event, pgp, p);
        this.isDispatchClosable = this.isDispatchClosable || this.onClosing(this.event, pgp, p);
        boolean b = this.isDispatchClosable;
        return a && b;
    }

    @Override
    @Nullable
    public WCommon top(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
        return null;
    }

    @Nullable
    protected WCommon dispatchTop(@Nonnull Area pgp, @Nonnull Point p) {
        if (pgp.pointInside(p)) {
            WCommon a = this.top(this.event, pgp, p);
            WCommon b = this.getContentPane().top(this.event, pgp, p);
            if (b != null) {
                return b;
            }
            return a;
        }
        return null;
    }

    public static class MouseButton {
        @Nonnull
        private final Set<Integer> pressed = Sets.newHashSet();
        @Nonnull
        private final MouseState state = new MouseState();

        @Nonnull
        public MouseState checkButton() {
            this.state.reset();
            Iterator<Integer> itr = this.pressed.iterator();
            while (itr.hasNext()) {
                Integer button = itr.next();
                if (!Mouse.isButtonDown((int)button)) {
                    this.state.removed.add(button);
                    this.state.lastRemoved = button;
                    itr.remove();
                    continue;
                }
                this.state.pressed.add(button);
                this.state.lastPressed = button;
            }
            return this.state;
        }

        public void addButton(int button) {
            this.pressed.add(button);
        }

        public static class MouseState {
            @Nonnull
            public final Set<Integer> removed = Sets.newHashSet();
            @Nullable
            public Integer lastRemoved;
            @Nonnull
            public final Set<Integer> pressed = Sets.newHashSet();
            @Nullable
            public Integer lastPressed;

            public void reset() {
                this.removed.clear();
                this.lastRemoved = null;
                this.pressed.clear();
                this.lastPressed = null;
            }
        }
    }
}

