/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kamesuta.mc.bnnwidget.WCommon;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WTypedPanel;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.util.NotifyCollections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class WList<T, W extends WCommon>
extends WTypedPanel<W> {
    @Nonnull
    protected NotifyCollections.IModCount<T> check;
    int cachedModCount = -1;
    @Nonnull
    private final Map<W, T> toT = Maps.newHashMap();
    @Nonnull
    private final Map<T, W> toW = Maps.newHashMap();
    @Nonnull
    private final Map<T, Integer> Tindex = Maps.newHashMap();
    @Nonnull
    private final Set<W> cws = Sets.newHashSet();

    public WList(@Nonnull R position, @Nonnull NotifyCollections.IModCount<T> check) {
        super(position);
        this.check = check;
    }

    public void setList(@Nonnull NotifyCollections.IModCount<T> check) {
        this.check = check;
        this.cachedModCount = -1;
        this.toT.clear();
        this.toW.clear();
        this.Tindex.clear();
        this.cws.clear();
        this.removelist.addAll(this.getContainer());
    }

    @Override
    public boolean add(@Nonnull W widget) {
        return false;
    }

    @Override
    public boolean remove(@Nonnull W widget) {
        return false;
    }

    @Override
    public void update(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
        int mod = this.check.getModCount();
        if (mod != this.cachedModCount) {
            this.cachedModCount = mod;
            this.update();
        }
        super.update(ev, pgp, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        List ws = this.getContainer();
        this.cws.clear();
        this.cws.addAll(ws);
        int it = -1;
        NotifyCollections.IModCount<T> iModCount = this.check;
        synchronized (iModCount) {
            for (Object t : this.check) {
                int it0;
                ++it;
                WCommon w = (WCommon)this.toW.get(t);
                if (w == null) {
                    w = this.createWidget(t, it);
                    this.toT.put(w, t);
                    this.toW.put(t, w);
                }
                this.cws.remove(w);
                if (!ws.contains(w)) {
                    this.Tindex.put(t, it);
                    super.add(w);
                    this.onAdded(t, w);
                }
                if (it == (it0 = this.Tindex.get(t).intValue())) continue;
                this.onMoved(t, w, it0, it);
            }
        }
        for (WCommon w : this.cws) {
            Object t;
            t = this.toT.get(w);
            if (t == null) continue;
            super.remove(w);
            this.onRemove(t, w);
            this.toT.remove(t);
            this.toW.remove(w);
            this.Tindex.remove(t);
        }
    }

    @Nonnull
    protected abstract W createWidget(@Nonnull T var1, int var2);

    protected void onAdded(@Nonnull T t, @Nonnull W w) {
    }

    protected void onRemove(@Nonnull T t, @Nonnull W w) {
    }

    protected void onMoved(@Nonnull T t, @Nonnull W w, int from, int to) {
    }
}

