/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.kamesuta.mc.bnnwidget.WBase;
import com.kamesuta.mc.bnnwidget.WCommon;
import com.kamesuta.mc.bnnwidget.WContainer;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class WTypedPanel<W extends WCommon>
extends WBase
implements WContainer<W> {
    @Nonnull
    private final List<W> widgets = Lists.newArrayList();
    @Nonnull
    protected final Deque<W> removelist = Queues.newArrayDeque();
    protected boolean initialized;
    @Nonnull
    protected Deque<Runnable> eventQueue = Queues.newArrayDeque();

    public WTypedPanel(@Nonnull R position) {
        super(position);
    }

    public void invokeLater(@Nullable Runnable doRun) {
        if (doRun != null) {
            this.eventQueue.push(doRun);
        }
    }

    @Override
    @Nonnull
    public List<W> getContainer() {
        return this.widgets;
    }

    @Override
    public boolean add(@Nonnull W widget) {
        boolean b = this.getContainer().add(widget);
        widget.onAdded();
        return b;
    }

    @Override
    public boolean remove(@Nonnull W widget) {
        if (widget.onCloseRequest()) {
            this.getContainer().remove(widget);
            return true;
        }
        this.removelist.offer(widget);
        return false;
    }

    @Override
    public void onAdded() {
        if (this.initialized) {
            for (WCommon widget : this.getContainer()) {
                widget.onAdded();
            }
        } else {
            this.initWidget();
            this.initialized = true;
        }
    }

    protected void initWidget() {
    }

    @Override
    public void onInit(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
        Area gp = this.getGuiPosition(pgp);
        for (WCommon widget : this.getContainer()) {
            widget.onInit(ev, gp, p);
        }
    }

    @Override
    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
        Area gp = this.getGuiPosition(pgp);
        float opacity = this.getGuiOpacity(popacity);
        for (WCommon widget : this.getContainer()) {
            widget.draw(ev, gp, p, frame, opacity, opt);
        }
        super.draw(ev, pgp, p, frame, popacity, opt);
    }

    @Override
    public void update(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
        Runnable doRun;
        while ((doRun = this.eventQueue.poll()) != null) {
            doRun.run();
        }
        Area gp = this.getGuiPosition(pgp);
        for (WCommon widget : this.getContainer()) {
            widget.update(ev, gp, p);
        }
        Iterator<W> itr = this.removelist.iterator();
        while (itr.hasNext()) {
            WCommon widget;
            widget = (WCommon)itr.next();
            if (!widget.onClosing(ev, gp, p)) continue;
            this.getContainer().remove(widget);
            itr.remove();
        }
    }

    @Override
    public boolean keyTyped(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, char c, int keycode) {
        Area gp = this.getGuiPosition(pgp);
        ListIterator<W> itr = this.getContainer().listIterator(this.getContainer().size());
        while (itr.hasPrevious()) {
            WCommon widget = (WCommon)itr.previous();
            if (!widget.keyTyped(ev, gp, p, c, keycode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int scroll) {
        Area gp = this.getGuiPosition(pgp);
        ListIterator<W> itr = this.getContainer().listIterator(this.getContainer().size());
        while (itr.hasPrevious()) {
            WCommon widget = (WCommon)itr.previous();
            if (!widget.mouseScrolled(ev, gp, p, scroll)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseMoved(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        Area gp = this.getGuiPosition(pgp);
        ListIterator<W> itr = this.getContainer().listIterator(this.getContainer().size());
        while (itr.hasPrevious()) {
            WCommon widget = (WCommon)itr.previous();
            if (!widget.mouseMoved(ev, gp, p, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        Area gp = this.getGuiPosition(pgp);
        ListIterator<W> itr = this.getContainer().listIterator(this.getContainer().size());
        while (itr.hasPrevious()) {
            WCommon widget = (WCommon)itr.previous();
            if (!widget.mouseClicked(ev, gp, p, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button, long time) {
        Area gp = this.getGuiPosition(pgp);
        ListIterator<W> itr = this.getContainer().listIterator(this.getContainer().size());
        while (itr.hasPrevious()) {
            WCommon widget = (WCommon)itr.previous();
            if (!widget.mouseDragged(ev, gp, p, button, time)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        Area gp = this.getGuiPosition(pgp);
        ListIterator<W> itr = this.getContainer().listIterator(this.getContainer().size());
        while (itr.hasPrevious()) {
            WCommon widget = (WCommon)itr.previous();
            if (!widget.mouseReleased(ev, gp, p, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onCloseRequest() {
        boolean closable = true;
        for (WCommon widget : this.getContainer()) {
            if (widget.onCloseRequest()) continue;
            this.removelist.offer(widget);
            closable = false;
        }
        return closable;
    }

    @Override
    public boolean onClosing(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
        Area gp = this.getGuiPosition(pgp);
        boolean closable = true;
        Iterator<W> itr = this.removelist.iterator();
        while (itr.hasNext()) {
            WCommon widget = (WCommon)itr.next();
            if (widget.onClosing(ev, gp, p)) {
                this.getContainer().remove(widget);
                itr.remove();
                continue;
            }
            closable = false;
        }
        return closable;
    }

    @Override
    @Nullable
    public WCommon top(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point point) {
        Area gp = this.getGuiPosition(pgp);
        if (gp.pointInside(point)) {
            WCommon topwidget = null;
            for (WCommon widget : this.getContainer()) {
                WCommon top = widget.top(ev, gp, point);
                if (top == null) continue;
                topwidget = top;
            }
            return topwidget;
        }
        return null;
    }
}

