/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.component;

import com.google.common.collect.Sets;
import com.kamesuta.mc.bnnwidget.WBase;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiTextField;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MChatTextField
extends WBase {
    @Nonnull
    protected final MGuiTextField t;
    @Nullable
    protected String watermark;
    protected int watermarkcolor = 0x777777;
    @Nonnull
    protected CharacterFilter filter = CharacterFilter.VanillaChatFilter.create();
    private boolean drag;
    private int drag_x = -1;

    public MChatTextField(@Nonnull R position) {
        super(position);
        this.t = new MGuiTextField();
    }

    public boolean canAddChar(char c) {
        return this.getFilter().checkCharacter(c);
    }

    @Nonnull
    public MChatTextField setWatermark(@Nullable String watermark) {
        this.watermark = watermark;
        return this;
    }

    @Nullable
    public String getWatermark() {
        return this.watermark;
    }

    @Nonnull
    public MChatTextField setWatermarkColor(int watermark) {
        this.watermarkcolor = watermark;
        return this;
    }

    public int getWatermarkColor() {
        return this.watermarkcolor;
    }

    @Nonnull
    public MChatTextField setFilter(@Nonnull CharacterFilter filter) {
        this.filter = filter;
        return this;
    }

    @Nonnull
    public CharacterFilter getFilter() {
        return this.filter;
    }

    @Override
    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float opacity, @Nonnull RenderOption opt) {
        Area a = this.getGuiPosition(pgp);
        this.updateArea(a);
        int x = this.t.field_146209_f;
        int y = this.t.field_146210_g;
        int w = this.t.field_146218_h;
        int h = this.t.field_146219_i;
        this.t.field_146209_f = 1;
        this.t.field_146210_g = 1;
        this.t.field_146218_h = (int)a.w() - 2;
        this.t.field_146219_i = (int)a.h() - 2;
        OpenGL.glPushMatrix();
        OpenGL.glTranslatef(a.x1(), a.y1(), 0.0f);
        this.t.func_146194_f();
        OpenGL.glPopMatrix();
        this.t.field_146209_f = x;
        this.t.field_146210_g = y;
        this.t.field_146218_h = w;
        this.t.field_146219_i = h;
    }

    @Override
    public void onAdded() {
        this.updateArea(Area.size(0.0f, 0.0f, 2.1474836E9f, 2.1474836E9f));
    }

    @Override
    public boolean mouseClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        Area a = this.getGuiPosition(pgp);
        this.updateArea(a);
        if (button == 1 && a.pointInside(p)) {
            this.setText("");
        }
        this.drag = true;
        this.drag_x = (int)p.x();
        this.t.func_146192_a(this.drag_x, (int)p.y(), button);
        return a.pointInside(p);
    }

    @Override
    public boolean mouseReleased(WEvent ev, Area pgp, Point p, int button) {
        this.drag = false;
        return false;
    }

    @Override
    public boolean mouseMoved(WEvent ev, Area pgp, Point p, int button) {
        Area a = this.getGuiPosition(pgp);
        if (this.drag) {
            this.updateArea(a);
            this.t.func_146192_a(this.drag_x, (int)p.y(), button);
            int start = this.t.func_146198_h();
            this.t.func_146192_a((int)p.x(), (int)p.y(), button);
            int end = this.t.func_146198_h();
            this.t.func_146190_e(end);
            this.t.func_146199_i(start);
        }
        return a.pointInside(p);
    }

    @Override
    public void update(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p) {
        this.t.func_146178_a();
    }

    @Override
    public boolean keyTyped(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, char c, int keycode) {
        this.t.func_146201_a(c, keycode);
        return this.isFocused();
    }

    @Override
    public boolean onCloseRequest() {
        this.setFocused(false);
        return true;
    }

    protected void updateArea(@Nonnull Area a) {
        Area b = a.child(1.0f, 1.0f, -1.0f, -1.0f);
        this.t.field_146209_f = (int)b.x1();
        this.t.field_146210_g = (int)b.y1();
        this.t.field_146218_h = (int)b.w();
        this.t.field_146219_i = (int)b.h();
    }

    public void setText(@Nonnull String p_146180_1_) {
        this.t.func_146180_a(p_146180_1_);
    }

    public void setTextByPassFilter(@Nonnull String p_146180_1_) {
        this.t.setTextByPassFilter(p_146180_1_);
    }

    protected void onTextChanged(@Nonnull String oldText) {
    }

    @Nonnull
    public String getText() {
        return this.t.func_146179_b();
    }

    @Nonnull
    public String getSelectedText() {
        return this.t.func_146207_c();
    }

    public void writeText(@Nonnull String p_146191_1_) {
        this.t.func_146191_b(p_146191_1_);
    }

    public void writeTextByPassFilter(@Nonnull String p_146191_1_) {
        this.t.writeTextByPassFilter(p_146191_1_);
    }

    public boolean equals(@Nullable Object obj) {
        return ((Object)((Object)this.t)).equals(obj);
    }

    public int hashCode() {
        return ((Object)((Object)this.t)).hashCode();
    }

    public void deleteWords(int p_146177_1_) {
        this.t.func_146177_a(p_146177_1_);
    }

    public void deleteFromCursor(int p_146175_1_) {
        this.t.func_146175_b(p_146175_1_);
    }

    public int getNthWordFromCursor(int p_146187_1_) {
        return this.t.func_146187_c(p_146187_1_);
    }

    public int getNthWordFromPos(int p_146183_1_, int p_146183_2_) {
        return this.t.func_146183_a(p_146183_1_, p_146183_2_);
    }

    public int func_146197_a(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        return this.t.func_146197_a(p_146197_1_, p_146197_2_, p_146197_3_);
    }

    public void moveCursorBy(int p_146182_1_) {
        this.t.func_146182_d(p_146182_1_);
    }

    public void setCursorPosition(int p_146190_1_) {
        this.t.func_146190_e(p_146190_1_);
    }

    public void setCursorPositionZero() {
        this.t.func_146196_d();
    }

    public void setCursorPositionEnd() {
        this.t.func_146202_e();
    }

    @Nullable
    public String toString() {
        return this.t.toString();
    }

    public void setMaxStringLength(int p_146203_1_) {
        this.t.func_146203_f(p_146203_1_);
    }

    public int getMaxStringLength() {
        return this.t.func_146208_g();
    }

    public int getCursorPosition() {
        return this.t.func_146198_h();
    }

    public boolean getEnableBackgroundDrawing() {
        return this.t.func_146181_i();
    }

    public void setEnableBackgroundDrawing(boolean b) {
        this.t.func_146185_a(b);
    }

    public void setTextColor(int color) {
        this.t.func_146193_g(color);
    }

    public void setDisabledTextColour(int color) {
        this.t.func_146204_h(color);
    }

    public void setFocused(boolean b) {
        this.t.func_146195_b(b);
    }

    protected void onFocusChanged() {
    }

    public boolean isFocused() {
        return this.t.func_146206_l();
    }

    public void setEnabled(boolean b) {
        this.t.func_146184_c(b);
    }

    public int getSelectionEnd() {
        return this.t.func_146186_n();
    }

    public int getWidth() {
        return this.t.func_146200_o();
    }

    public void setSelectionPos(int p_146199_1_) {
        this.t.func_146199_i(p_146199_1_);
    }

    public void setCanLoseFocus(boolean p_146205_1_) {
        this.t.func_146205_d(p_146205_1_);
    }

    public boolean getVisible() {
        return this.t.func_146176_q();
    }

    public void setVisible(boolean b) {
        this.t.func_146189_e(b);
    }

    public static abstract class CharacterFilter {
        public static final char[] allowedCharacters = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

        public String filerAllowedCharacters(String str) {
            StringBuilder stringbuilder = new StringBuilder();
            for (char c0 : str.toCharArray()) {
                if (!this.checkCharacter(c0)) continue;
                stringbuilder.append(c0);
            }
            return stringbuilder.toString();
        }

        public abstract boolean checkCharacter(char var1);

        public static class VanillaChatFilter
        extends BlackListFilter {
            public VanillaChatFilter(@Nonnull Set<Character> blacklist) {
                super(blacklist);
                for (char i = '\u0000'; i < ' '; i = (char)(i + '\u0001')) {
                    blacklist.add(Character.valueOf(i));
                }
                blacklist.add(Character.valueOf('\u007f'));
                blacklist.add(Character.valueOf('\u00a7'));
            }

            @Nonnull
            public static VanillaChatFilter create() {
                return new VanillaChatFilter(Sets.newHashSet());
            }
        }

        public static class BlackListFilter
        extends AbstractBlackListFilter {
            @Nonnull
            private final Set<Character> blacklist;

            public BlackListFilter(@Nonnull Set<Character> blacklist) {
                this.blacklist = blacklist;
            }

            @Nonnull
            public static BlackListFilter create() {
                return new BlackListFilter(Sets.newHashSet());
            }

            @Nonnull
            public static BlackListFilter createFromString(String filter) {
                return new BlackListFilter(Sets.newHashSet((Object[])ArrayUtils.toObject((char[])filter.toCharArray())));
            }

            @Nonnull
            public Set<Character> getBlacklist() {
                return this.blacklist;
            }

            @Override
            public boolean isDeniedCharacter(char ch) {
                for (char c : this.blacklist) {
                    if (c != ch) continue;
                    return true;
                }
                return false;
            }
        }

        public static abstract class AbstractBlackListFilter
        extends CharacterFilter {
            @Override
            public final boolean checkCharacter(char ch) {
                return !this.isDeniedCharacter(ch);
            }

            public abstract boolean isDeniedCharacter(char var1);
        }

        public static class WhiteListFilter
        extends AbstractWhiteListFilter {
            @Nonnull
            private final Set<Character> whitelist;

            public WhiteListFilter(@Nonnull Set<Character> whitelist) {
                this.whitelist = whitelist;
            }

            @Nonnull
            public static WhiteListFilter create() {
                return new WhiteListFilter(Sets.newHashSet());
            }

            @Nonnull
            public static WhiteListFilter createFromString(String filter) {
                return new WhiteListFilter(Sets.newHashSet((Object[])ArrayUtils.toObject((char[])filter.toCharArray())));
            }

            @Nonnull
            public Set<Character> getWhitelist() {
                return this.whitelist;
            }

            @Override
            public boolean isAllowedCharacter(char ch) {
                for (char c : this.whitelist) {
                    if (c != ch) continue;
                    return true;
                }
                return false;
            }
        }

        public static abstract class AbstractWhiteListFilter
        extends CharacterFilter {
            @Override
            public final boolean checkCharacter(char ch) {
                return this.isAllowedCharacter(ch);
            }

            public abstract boolean isAllowedCharacter(char var1);
        }
    }

    protected class MGuiTextField
    extends GuiTextField {
        public MGuiTextField() {
            super(1, WRenderer.font(), 0, 0, 0, 0);
        }

        public void func_146180_a(@Nullable String text) {
            if (text != null) {
                this.setTextByPassFilter(this.filerAllowedCharacters(text));
            }
        }

        public void setTextByPassFilter(@Nonnull String text) {
            String s = this.func_146179_b();
            super.func_146180_a(text);
            this.onTextChanged(s, this.func_146179_b());
        }

        public void func_146175_b(int p_146175_1_) {
            String s = this.func_146179_b();
            super.func_146175_b(p_146175_1_);
            this.onTextChanged(s, this.func_146179_b());
        }

        public void func_146191_b(@Nullable String text) {
            if (text != null) {
                this.writeTextByPassFilter(this.filerAllowedCharacters(text));
            }
        }

        public void writeTextByPassFilter(@Nonnull String text) {
            String s = this.func_146179_b();
            this.writeText0(text);
            this.onTextChanged(s, this.func_146179_b());
        }

        private void writeText0(@Nonnull String newtext) {
            int l;
            String s1 = "";
            int cpos = this.func_146198_h();
            int send = this.func_146186_n();
            String text = this.func_146179_b();
            int textlen = text.length();
            int i = cpos < send ? cpos : send;
            int j = cpos < send ? send : cpos;
            int k = this.func_146208_g() - textlen - (i - send);
            if (textlen > 0) {
                s1 = s1 + text.substring(0, i);
            }
            if (k < newtext.length()) {
                s1 = s1 + newtext.substring(0, k);
                l = k;
            } else {
                s1 = s1 + newtext;
                l = newtext.length();
            }
            if (textlen > 0 && j < textlen) {
                s1 = s1 + text.substring(j);
            }
            super.func_146180_a(s1);
            this.func_146182_d(i - this.func_146186_n() + l);
        }

        public void func_146203_f(int p_146203_1_) {
            String s = this.func_146179_b();
            super.func_146203_f(p_146203_1_);
            this.onTextChanged(s, this.func_146179_b());
        }

        @Nonnull
        protected String filerAllowedCharacters(@Nonnull String text) {
            StringBuilder stringbuilder = new StringBuilder();
            int i = text.length();
            for (int j = 0; j < i; ++j) {
                char c0 = text.charAt(j);
                if (!MChatTextField.this.canAddChar(c0)) continue;
                stringbuilder.append(c0);
            }
            return stringbuilder.toString();
        }

        protected void onTextChanged(@Nonnull String oldText, @Nonnull String newText) {
            if (!StringUtils.equals((CharSequence)oldText, (CharSequence)newText)) {
                MChatTextField.this.onTextChanged(oldText);
            }
        }

        public void func_146195_b(boolean p_146195_1_) {
            boolean b = this.func_146206_l();
            super.func_146195_b(p_146195_1_);
            this.onFocusChanged(b, this.func_146206_l());
        }

        protected void onFocusChanged(boolean oldFocus, boolean newFocus) {
            if (oldFocus != newFocus) {
                MChatTextField.this.onFocusChanged();
            }
        }

        public void func_146194_f() {
            super.func_146194_f();
            if (!StringUtils.isEmpty((CharSequence)MChatTextField.this.getWatermark()) && StringUtils.isEmpty((CharSequence)this.func_146179_b()) && !this.func_146206_l()) {
                int l = this.func_146181_i() ? this.field_146209_f + 4 : this.field_146209_f;
                int i1 = this.func_146181_i() ? this.field_146210_g + (this.field_146219_i - 8) / 2 : this.field_146210_g;
                WRenderer.font().func_175063_a(MChatTextField.this.getWatermark(), (float)l, (float)i1, MChatTextField.this.watermarkcolor);
            }
        }

        @Nonnull
        public String toString() {
            return "TextField [text=" + this.func_146179_b() + "]";
        }
    }
}

