/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.component;

import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.component.MButton;
import com.kamesuta.mc.bnnwidget.component.MLabel;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import javax.annotation.Nonnull;

public class MCheckBox
extends MLabel {
    protected boolean checked = true;

    public MCheckBox(@Nonnull R position) {
        super(position);
    }

    public void check(boolean check) {
        this.checked = check;
        this.onCheckChanged(!check);
    }

    public final boolean isCheck() {
        return this.checked;
    }

    protected void onCheckChanged(boolean oldCheck) {
    }

    @Override
    public boolean mouseClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
        Area a = this.getGuiPosition(pgp);
        if (a.pointInside(p)) {
            this.check(!this.checked);
            MButton.playPressButtonSound();
            return true;
        }
        return false;
    }

    @Override
    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
        Area o = this.getGuiPosition(pgp);
        Area a = Area.abs(o.x1(), o.y1(), o.x1() + o.h(), o.y2());
        this.drawCheckBox(a);
        Area b = o.child(o.x1() + o.h(), 0.0f, o.x1() + o.h(), 0.0f);
        this.drawText(ev, b, p, frame, this.getGuiOpacity(popacity));
    }

    protected void drawCheckBox(@Nonnull Area out) {
        Area in = out.child(1.0f, 1.0f, -1.0f, -1.0f);
        WRenderer.startShape();
        OpenGL.glColor4f(0.627451f, 0.627451f, 0.627451f, 1.0f);
        MCheckBox.draw(out);
        OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        MCheckBox.draw(in);
        WRenderer.startTexture();
        if (this.checked) {
            String strcheck = "\u2713";
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(in.x1() + (in.w() - (float)MCheckBox.font().func_78256_a("\u2713")) / 2.0f, in.y1() + (in.h() - (float)MCheckBox.font().field_78288_b) / 2.0f, 0.0f);
            MCheckBox.font().func_175063_a("\u2713", 0.0f, 0.0f, 0xFFFFFF);
            OpenGL.glPopMatrix();
        }
    }
}

