/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.component;

import com.kamesuta.mc.bnnwidget.WBase;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.RenderOption;
import com.kamesuta.mc.bnnwidget.render.WGui;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class MLabel
extends WBase {
    protected int textcolor = 0xE0E0E0;
    @Nonnull
    protected String text = "";
    protected boolean shadow;
    @Nullable
    protected String watermark;
    protected int watermarkcolor = 0x777777;
    @Nonnull
    protected WGui.Align align = WGui.Align.CENTER;
    @Nonnull
    protected WGui.VerticalAlign valign = WGui.VerticalAlign.MIDDLE;
    protected float wscale = 1.0f;
    protected float hscale = 1.0f;

    public MLabel(@Nonnull R position) {
        super(position);
    }

    @Nonnull
    public MLabel setAlign(@Nonnull WGui.Align align) {
        this.align = align;
        return this;
    }

    @Nonnull
    public WGui.Align getAlign() {
        return this.align;
    }

    @Nonnull
    public MLabel setVerticalAlign(@Nonnull WGui.VerticalAlign valign) {
        this.valign = valign;
        return this;
    }

    @Nonnull
    public WGui.VerticalAlign getVerticalAlign() {
        return this.valign;
    }

    @Nonnull
    public MLabel setWatermark(@Nullable String watermark) {
        this.watermark = watermark;
        return this;
    }

    @Nullable
    public String getWatermark() {
        return this.watermark;
    }

    @Nonnull
    public MLabel setWatermarkColor(int watermark) {
        this.watermarkcolor = watermark;
        return this;
    }

    public int getWatermarkColor() {
        return this.watermarkcolor;
    }

    @Nonnull
    public MLabel setShadow(boolean b) {
        this.shadow = b;
        return this;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    @Nonnull
    public MLabel setColor(int color) {
        this.textcolor = color;
        return this;
    }

    public int getColor() {
        return this.textcolor;
    }

    @Nonnull
    public MLabel setText(@Nonnull String s) {
        if (StringUtils.equals((CharSequence)s, (CharSequence)this.getText())) {
            return this;
        }
        String oldText = this.getText();
        this.text = s;
        this.onTextChanged(oldText);
        return this;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    protected void onTextChanged(@Nonnull String oldText) {
    }

    @Override
    public void draw(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, float frame, float popacity, @Nonnull RenderOption opt) {
        this.drawText(ev, this.getGuiPosition(pgp), p, frame, this.getGuiOpacity(popacity));
    }

    @Nonnull
    public MLabel setScaleWidth(float f) {
        this.wscale = f;
        return this;
    }

    public float getScaleWidth(@Nonnull Area a) {
        return this.wscale;
    }

    @Nonnull
    public MLabel setScaleHeight(float f) {
        this.hscale = f;
        return this;
    }

    public float getScaleHeight(@Nonnull Area a) {
        return this.hscale;
    }

    protected void drawText(@Nonnull WEvent ev, @Nonnull Area a, @Nonnull Point p, float frame, float opacity) {
        OpenGL.glPushMatrix();
        OpenGL.glTranslated(a.x1() + a.w() / 2.0f, a.y1() + a.h() / 2.0f, 0.0);
        OpenGL.glScaled(this.getScaleWidth(a), this.getScaleHeight(a), 1.0);
        OpenGL.glTranslated(-(a.x1() + a.w() / 2.0f), -(a.y1() + a.h() / 2.0f), 0.0);
        WRenderer.startTexture();
        Color c = new Color(this.getColor());
        OpenGL.glColor4i(c.getRed(), c.getGreen(), c.getBlue(), (int)Math.max(4.0f, opacity * (float)c.getAlpha()));
        MLabel.drawString(this.getText(), a, this.getAlign(), this.getVerticalAlign(), this.isShadow());
        String watermark = this.getWatermark();
        if (watermark != null && !StringUtils.isEmpty((CharSequence)watermark) && StringUtils.isEmpty((CharSequence)this.getText())) {
            Color w = new Color(this.getWatermarkColor());
            OpenGL.glColor4i(w.getRed(), w.getGreen(), w.getBlue(), (int)Math.max(4.0f, opacity * (float)c.getAlpha()));
            MLabel.drawString(watermark, a, this.getAlign(), this.getVerticalAlign(), this.isShadow());
        }
        OpenGL.glPopMatrix();
    }
}

