/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.component;

import com.kamesuta.mc.bnnwidget.ShortestFloatFormatter;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.component.MButton;
import com.kamesuta.mc.bnnwidget.component.MChatTextField;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MNumber
extends WPanel {
    @Nonnull
    public MButton neg;
    @Nonnull
    public MChatTextField field;
    @Nonnull
    public MButton pos;

    public MNumber(@Nonnull R position, float buttonwidth) {
        super(position);
        this.neg = new MButton(new R(Coord.left(0.0f), Coord.width(buttonwidth), Coord.top(0.0f), Coord.bottom(0.0f))){

            @Override
            protected boolean onClicked(WEvent ev, Area pgp, Point p, int button) {
                return MNumber.this.negClicked();
            }
        }.setText("-");
        this.add(this.neg);
        this.field = new MChatTextField(new R(Coord.left(buttonwidth), Coord.right(buttonwidth), Coord.top(0.0f), Coord.bottom(0.0f))){

            @Override
            protected void onTextChanged(String oldText) {
                MNumber.this.onNumberChanged(oldText, this.getText());
            }
        }.setFilter(MChatTextField.CharacterFilter.WhiteListFilter.createFromString("+-.eE0123456789")).setWatermark(I18n.func_135052_a((String)"signpic.gui.editor.number.unknown", (Object[])new Object[0]));
        this.add(this.field);
        this.pos = new MButton(new R(Coord.right(0.0f), Coord.width(buttonwidth), Coord.top(0.0f), Coord.bottom(0.0f))){

            @Override
            protected boolean onClicked(WEvent ev, Area pgp, Point p, int button) {
                return MNumber.this.posClicked();
            }
        }.setText("+");
        this.add(this.pos);
    }

    protected boolean negClicked() {
        float f = GuiScreen.func_146272_n() ? 0.1f : (GuiScreen.func_146271_m() ? 0.01f : 1.0f);
        this.field.setText(ShortestFloatFormatter.format(NumberUtils.toFloat((String)this.field.getText()) - f));
        return true;
    }

    protected boolean posClicked() {
        float f = GuiScreen.func_146272_n() ? 0.1f : (GuiScreen.func_146271_m() ? 0.01f : 1.0f);
        this.field.setText(ShortestFloatFormatter.format(NumberUtils.toFloat((String)this.field.getText()) + f));
        return true;
    }

    @Nonnull
    public MNumber setNumber(float f) {
        this.field.setText(Float.isNaN(f) ? "" : ShortestFloatFormatter.format(f));
        return this;
    }

    @Nonnull
    public MNumber setPosLabel(@Nonnull String s) {
        if (!StringUtils.isEmpty((CharSequence)s) && !StringUtils.contains((CharSequence)s, (CharSequence)"signpic.")) {
            this.pos.setText(s);
        }
        return this;
    }

    @Nonnull
    public MNumber setNegLabel(@Nonnull String s) {
        if (!StringUtils.isEmpty((CharSequence)s) && !StringUtils.contains((CharSequence)s, (CharSequence)"signpic.")) {
            this.neg.setText(s);
        }
        return this;
    }

    @Nonnull
    public MNumber setUnknownLabel(@Nonnull String s) {
        if (!StringUtils.isEmpty((CharSequence)s) && !StringUtils.contains((CharSequence)s, (CharSequence)"signpic.")) {
            this.field.setWatermark(s);
        }
        return this;
    }

    protected void onNumberChanged(@Nonnull String oldText, @Nonnull String newText) {
    }
}

