/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.component;

import com.google.common.collect.Lists;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.component.MButton;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MSelect<E>
extends WPanel {
    protected final float buttonwidth;
    @Nonnull
    public MButton neg;
    @Nonnull
    public MButton pos;

    public MSelect(@Nonnull R position, float buttonwidth) {
        super(position);
        this.buttonwidth = buttonwidth;
        this.neg = new MButton(new R(Coord.left(0.0f), Coord.width(buttonwidth), Coord.top(0.0f), Coord.bottom(0.0f))){

            @Override
            protected boolean onClicked(WEvent ev, Area pgp, Point p, int button) {
                MSelect.this.getSelector().prev();
                MSelect.this.setText(MSelect.this.getSelector().get());
                return true;
            }
        }.setText("<");
        this.add(this.neg);
        this.pos = new MButton(new R(Coord.right(0.0f), Coord.width(buttonwidth), Coord.top(0.0f), Coord.bottom(0.0f))){

            @Override
            protected boolean onClicked(WEvent ev, Area pgp, Point p, int button) {
                MSelect.this.getSelector().next();
                MSelect.this.setText(MSelect.this.getSelector().get());
                return true;
            }
        }.setText(">");
        this.add(this.pos);
    }

    @Nonnull
    public abstract MSelect<E> setText(@Nonnull E var1);

    @Nonnull
    protected abstract Selector<E> getSelector();

    @Nonnull
    public MSelect<E> setPosLabel(@Nullable String s) {
        this.pos.setText(s);
        return this;
    }

    @Nonnull
    public MSelect<E> setNegLabel(@Nullable String s) {
        this.neg.setText(s);
        return this;
    }

    public static class StringSelector
    extends PosSelector<String> {
        @Nonnull
        protected List<?> list = Lists.newArrayList();

        public void setList(@Nonnull List<?> list) {
            this.list = list;
        }

        @Nonnull
        protected List<?> getList() {
            return this.list;
        }

        @Override
        public int length() {
            return this.getList().size();
        }

        @Override
        protected int indexOf(@Nullable String o) {
            return this.list.indexOf(o);
        }

        @Override
        @Nonnull
        public String get() {
            int length = this.length();
            int current = this.getCurrentPos();
            if (current < 0 || current >= length) {
                return "";
            }
            return this.getList().get(current).toString();
        }
    }

    public static abstract class PosSelector<E>
    implements Selector<E> {
        protected int current;

        @Override
        public void next() {
            ++this.current;
        }

        @Override
        public void prev() {
            --this.current;
        }

        public void setCurrentPos(int current) {
            this.current = current;
        }

        public void setCurrentPos(@Nullable E o) {
            int i = this.indexOf(o);
            if (i >= 0) {
                this.setCurrentPos(i);
            }
        }

        protected abstract int indexOf(@Nullable E var1);

        protected abstract int length();

        public int getCurrentPos() {
            int length = this.length();
            if (length <= 0) {
                return 0;
            }
            this.current = (this.current % length + length) % length;
            return this.current;
        }
    }

    public static interface Selector<E> {
        @Nonnull
        public E get();

        public void next();

        public void prev();
    }
}

