/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.component;

import com.google.common.collect.Lists;
import com.kamesuta.mc.bnnwidget.WBox;
import com.kamesuta.mc.bnnwidget.WCommon;
import com.kamesuta.mc.bnnwidget.component.MButton;
import com.kamesuta.mc.bnnwidget.component.MSelect;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.R;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MSelectButton
extends MSelect<MButton> {
    @Nonnull
    public final WBox field;
    @Nonnull
    public ButtonSelector selector = new ButtonSelector();

    public void setSelector(@Nonnull ButtonSelector selector) {
        this.selector = selector;
    }

    @Nonnull
    protected ButtonSelector getSelector() {
        return this.selector;
    }

    public MSelectButton(@Nonnull R position, float buttonwidth) {
        super(position, buttonwidth);
        this.field = new WBox(new R(Coord.left(this.buttonwidth), Coord.right(this.buttonwidth), Coord.top(0.0f), Coord.bottom(0.0f))){

            @Override
            public void set(@Nullable WCommon widget) {
                MSelectButton.this.onChanged(widget);
                super.set(widget);
            }
        };
        this.add(this.field);
    }

    protected void onChanged(@Nullable WCommon widget) {
    }

    @Override
    protected void initWidget() {
        this.selectButton(this.getSelector().get());
    }

    @Nonnull
    public MSelectButton setText(@Nonnull MButton text) {
        this.field.set(text);
        return this;
    }

    @Nonnull
    public MSelectButton selectButton(@Nullable MButton button) {
        this.field.set(button);
        return this;
    }

    @Nonnull
    public MSelectButton setPosLabel(@Nullable String s) {
        this.pos.setText(s);
        return this;
    }

    @Nonnull
    public MSelectButton setNegLabel(@Nullable String s) {
        this.neg.setText(s);
        return this;
    }

    public static class ButtonSelector
    extends MSelect.PosSelector<MButton> {
        @Nonnull
        protected List<MButton> list = Lists.newArrayList();

        public void setList(@Nonnull List<MButton> list) {
            this.list = list;
        }

        @Nonnull
        protected List<MButton> getList() {
            return this.list;
        }

        @Override
        public int length() {
            return this.getList().size();
        }

        @Override
        protected int indexOf(@Nullable MButton o) {
            return this.list.indexOf(o);
        }

        @Override
        @Nonnull
        public MButton get() {
            int length = this.length();
            int current = this.getCurrentPos();
            MButton m = null;
            if (current >= 0 && current < length && (m = this.getList().get(current)) != null) {
                return m;
            }
            return new MButton(new R(new Coord[0]));
        }
    }
}

