/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.component;

import com.kamesuta.mc.bnnwidget.WBox;
import com.kamesuta.mc.bnnwidget.WCommon;
import com.kamesuta.mc.bnnwidget.WEvent;
import com.kamesuta.mc.bnnwidget.WPanel;
import com.kamesuta.mc.bnnwidget.WidgetBuilder;
import com.kamesuta.mc.bnnwidget.component.MButton;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import com.kamesuta.mc.bnnwidget.var.VCommon;
import javax.annotation.Nonnull;

public class MTab
extends WPanel {
    @Nonnull
    protected final Coord.CoordSide side;
    protected final float widthadd;
    protected final float height;
    @Nonnull
    protected final R tabarea;
    @Nonnull
    protected final R boxarea;
    @Nonnull
    protected Tab tab;
    @Nonnull
    protected WBox box;
    protected float verticalWidth = 0.0f;

    public MTab(@Nonnull R position, @Nonnull Coord.CoordSide side, float widthadd, float height) {
        super(position);
        this.side = side;
        this.height = height;
        this.widthadd = widthadd;
        VCommon width = new VCommon(){

            @Override
            public float getAbsCoord(float a, float b) {
                return this.get();
            }

            @Override
            public float get() {
                return MTab.this.verticalWidth;
            }
        };
        switch (side) {
            case Left: {
                this.tabarea = new R(Coord.left(0.0f), Coord.width(width));
                this.boxarea = new R(Coord.left(width), Coord.right(0.0f));
                break;
            }
            default: {
                this.tabarea = new R(Coord.top(0.0f), Coord.height(height));
                this.boxarea = new R(Coord.top(height), Coord.bottom(0.0f));
                break;
            }
            case Right: {
                this.tabarea = new R(Coord.right(0.0f), Coord.width(width));
                this.boxarea = new R(Coord.right(width), Coord.left(0.0f));
                break;
            }
            case Bottom: {
                this.tabarea = new R(Coord.bottom(0.0f), Coord.height(height));
                this.boxarea = new R(Coord.bottom(height), Coord.top(0.0f));
            }
        }
        this.tab = new Tab(this.tabarea);
        this.box = new WBox(this.boxarea);
    }

    @Override
    protected void initWidget() {
        this.add(this.tab);
        this.add(this.box);
    }

    public void addTab(@Nonnull String name, @Nonnull WidgetBuilder<WCommon> widget) {
        if (this.tab.getContainer().isEmpty()) {
            this.box.add(widget.build());
        }
        this.tab.addTab(name, widget);
    }

    public void addTab(@Nonnull String name, final @Nonnull WCommon widget) {
        this.addTab(name, new WidgetBuilder<WCommon>(){

            @Override
            public WCommon build() {
                return widget;
            }
        });
    }

    public class TabButton
    extends MButton {
        @Nonnull
        public final WidgetBuilder<WCommon> widget;

        public TabButton(@Nonnull R position, WidgetBuilder<WCommon> widget) {
            super(position);
            this.widget = widget;
        }

        @Override
        protected boolean onClicked(@Nonnull WEvent ev, @Nonnull Area pgp, @Nonnull Point p, int button) {
            MTab.this.box.add(this.widget.build());
            return true;
        }
    }

    public class Tab
    extends WPanel {
        protected float ileft;

        public Tab(R position) {
            super(position);
        }

        public void addTab(@Nonnull String name, @Nonnull WidgetBuilder<WCommon> widget) {
            Coord ctop;
            Coord cwidth;
            Coord cleft;
            Coord cheight = Coord.height(MTab.this.height);
            float w = (float)Tab.font().func_78256_a(name) + MTab.this.widthadd;
            switch (MTab.this.side) {
                case Left: 
                case Right: {
                    cleft = Coord.left(0.0f);
                    MTab.this.verticalWidth = Math.max(MTab.this.verticalWidth, w);
                    cwidth = Coord.pwidth(1.0f);
                    ctop = Coord.top(MTab.this.height * (float)this.getContainer().size());
                    break;
                }
                default: {
                    cleft = Coord.left(this.ileft);
                    this.ileft += w;
                    cwidth = Coord.width(w);
                    ctop = Coord.top(0.0f);
                }
            }
            this.add(new TabButton(new R(cleft, cwidth, ctop, cheight), widget).setText(name));
        }
    }
}

