/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.kamesuta.mc.bnnwidget.render.WGui;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FontPosition {
    private float x;
    private float y;
    private float scaleX;
    private float scaleY;
    private float sx = 0.5f;
    private float sy = 0.5f;
    private int fontsize = 22;
    @Nullable
    private String text;
    @Nonnull
    private WGui.Align align = WGui.Align.LEFT;
    @Nonnull
    private WGui.VerticalAlign valign = WGui.VerticalAlign.TOP;
    private boolean usecode;
    private boolean shadow;

    public FontPosition() {
        this.reset();
    }

    public FontPosition(@Nonnull FontPosition p) {
        this.set(p);
    }

    @Nonnull
    public FontPosition reset() {
        this.y = 0.0f;
        this.x = 0.0f;
        this.text = null;
        this.scaleY = 0.5f;
        this.scaleX = 0.5f;
        this.fontsize = -1;
        this.align = WGui.Align.LEFT;
        this.usecode = true;
        return this;
    }

    @Nonnull
    public FontPosition set(@Nonnull FontPosition p) {
        this.x = p.getX();
        this.y = p.getY();
        this.text = p.getText();
        this.scaleX = p.getScaleX();
        this.scaleY = p.getScaleY();
        this.fontsize = p.getFontSize();
        this.align = p.getAlign();
        this.usecode = p.isUseCode();
        return this;
    }

    @Nonnull
    public FontPosition setX(float x) {
        this.x = x;
        return this;
    }

    public float getX() {
        return this.x;
    }

    @Nonnull
    public FontPosition setY(float y) {
        this.y = y;
        return this;
    }

    public float getY() {
        return this.y;
    }

    @Nonnull
    public FontPosition setPosition(float x, float y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    @Nonnull
    public FontPosition setText(String str) {
        this.text = str;
        return this;
    }

    @Nonnull
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        this.text = "";
        return "";
    }

    public int getStartIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.getText().length() - 1;
    }

    @Nonnull
    public FontPosition setScaleX(float scaleX) {
        this.scaleX = scaleX;
        return this;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    @Nonnull
    public FontPosition setScaleY(float scaleY) {
        this.scaleY = scaleY;
        return this;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    @Nonnull
    public FontPosition setFontSize(int fontsize) {
        this.fontsize = fontsize;
        return this;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    @Nonnull
    public FontPosition setScale(float scaleX, float scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        return this;
    }

    @Nonnull
    public FontPosition setScale(float scale) {
        this.setScale(scale, scale);
        return this;
    }

    @Nonnull
    public FontPosition setAlign(@Nonnull WGui.Align align) {
        this.align = align;
        return this;
    }

    @Nonnull
    public WGui.Align getAlign() {
        return this.align;
    }

    @Nonnull
    public FontPosition setVAlign(@Nonnull WGui.VerticalAlign valign) {
        this.valign = valign;
        return this;
    }

    @Nonnull
    public WGui.VerticalAlign getVAlign() {
        return this.valign;
    }

    @Nonnull
    public FontPosition setUseCode(boolean usecode) {
        this.usecode = usecode;
        return this;
    }

    public boolean isUseCode() {
        return this.usecode;
    }

    @Nonnull
    public FontPosition setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    @Nonnull
    public FontPosition setShadowX(float x) {
        this.sx = x;
        return this;
    }

    public float getShadowX() {
        return this.sx;
    }

    @Nonnull
    public FontPosition setShadowY(float y) {
        this.sy = y;
        return this;
    }

    public float getShadowY() {
        return this.sy;
    }

    @Nonnull
    public FontPosition setShadowPosition(float x, float y) {
        this.setShadowX(x);
        this.setShadowY(y);
        return this;
    }
}

