/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.kamesuta.mc.bnnwidget.font.FontShape;
import java.awt.Font;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;

public class FontSet {
    @Nonnull
    public final String defaultFontName;
    @Nonnull
    public final ImmutableList<String> fontNames;
    public final int style;

    FontSet(@Nonnull String defaultFontName, @Nonnull ImmutableList<String> fontNames, int style) {
        this.defaultFontName = defaultFontName;
        this.fontNames = fontNames;
        this.style = style;
    }

    @Nonnull
    public FontSet deriveFontStyle(int style) {
        return new FontSet(this.defaultFontName, this.fontNames, style);
    }

    @Nonnull
    public SizedFontSet getSizedFont(int size) {
        Font defaultFont = new Font(this.defaultFontName, this.style, size);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String fontName : this.fontNames) {
            if (!FontShape.isSupported(fontName)) continue;
            builder.add((Object)new Font(fontName, this.style, size));
        }
        return new SizedFontSet(defaultFont, (ImmutableList<Font>)builder.build(), this.style, size);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.defaultFontName.hashCode();
        result = 31 * result + this.fontNames.hashCode();
        result = 31 * result + this.style;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FontSet)) {
            return false;
        }
        FontSet other = (FontSet)obj;
        if (!this.defaultFontName.equals(other.defaultFontName)) {
            return false;
        }
        if (!this.fontNames.equals(other.fontNames)) {
            return false;
        }
        return this.style == other.style;
    }

    public String toString() {
        return String.format("FontSet [defaultFontName=%s, fontNames=%s, style=%s]", this.defaultFontName, this.fontNames, this.style);
    }

    public static class Builder {
        @Nonnull
        public static final String defaultFontName = "YuGothic";
        @Nonnull
        private final List<String> fontnames = Lists.newArrayList((Object[])new String[]{"YuGothic"});
        private int style = 0;

        public Builder() {
        }

        public Builder(@Nonnull FontSet fontSet) {
        }

        @Nonnull
        public Builder addName(@Nonnull String name) {
            this.fontnames.add(name);
            return this;
        }

        @Nonnull
        public Builder setStyle(int style) {
            this.style = style;
            return this;
        }

        @Nonnull
        public FontSet build() {
            ImmutableList.Builder builder = ImmutableList.builder();
            ListIterator<String> itr = this.fontnames.listIterator(this.fontnames.size());
            while (itr.hasPrevious()) {
                String fontname = itr.previous();
                if (!FontShape.isSupported(fontname)) continue;
                builder.add((Object)fontname);
            }
            return new FontSet("Dialog", (ImmutableList<String>)builder.build(), this.style);
        }
    }

    public static class SizedFontSet {
        @Nonnull
        public final Font defaultFont;
        @Nonnull
        public final ImmutableList<Font> fonts;
        public final int style;
        public final int size;

        SizedFontSet(@Nonnull Font defaultFont, @Nonnull ImmutableList<Font> fonts, int style, int size) {
            this.defaultFont = defaultFont;
            this.fonts = fonts;
            this.style = style;
            this.size = size;
        }

        @Nonnull
        public Font getCharFont(char ch) {
            for (Font font : this.fonts) {
                if (!font.canDisplay(ch)) continue;
                return font;
            }
            return this.defaultFont;
        }

        @Nonnull
        public SizedFontSet deriveFontStyle(int style) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Font font : this.fonts) {
                builder.add((Object)font.deriveFont(style));
            }
            return new SizedFontSet(this.defaultFont.deriveFont(style), (ImmutableList<Font>)builder.build(), style, this.size);
        }

        @Nonnull
        public SizedFontSet deriveFontSize(int size) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Font font : this.fonts) {
                builder.add((Object)font.deriveFont((float)size));
            }
            return new SizedFontSet(this.defaultFont.deriveFont((float)size), (ImmutableList<Font>)builder.build(), this.style, size);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.defaultFont.hashCode();
            result = 31 * result + this.fonts.hashCode();
            result = 31 * result + this.size;
            result = 31 * result + this.style;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SizedFontSet)) {
                return false;
            }
            SizedFontSet other = (SizedFontSet)obj;
            if (!this.defaultFont.equals(other.defaultFont)) {
                return false;
            }
            if (!this.fonts.equals(other.fonts)) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            return this.style == other.style;
        }

        public String toString() {
            return String.format("SizedFontSet [defaultFont=%s, fonts=%s, style=%s, size=%s]", this.defaultFont, this.fonts, this.style, this.size);
        }
    }
}

