/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.kamesuta.mc.bnnwidget.font.FontSet;
import com.kamesuta.mc.bnnwidget.font.LoadedFontShape;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FontShape {
    @Nonnull
    public final FontSet font;
    public final boolean antiAlias;
    public final int fontSize;
    public final int textureSize;

    protected FontShape(@Nonnull FontSet font, boolean antiAlias, int fontSize) {
        this.font = font;
        this.antiAlias = antiAlias;
        this.fontSize = FontShape.getFontSize(fontSize);
        this.textureSize = FontShape.getTextureSize(FontShape.getFontSize(this.fontSize) * 4);
    }

    private static int getTextureSize(int fsize) {
        int size;
        for (size = 64; size < fsize; size *= 2) {
        }
        return size;
    }

    public static int getFontSize(int fontsize) {
        return fontsize + 3;
    }

    protected FontShape(@Nonnull FontShape shape) {
        this(shape.font, shape.antiAlias, shape.fontSize);
    }

    @Nonnull
    public LoadedFontShape load() {
        return new LoadedFontShape(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.antiAlias ? 1231 : 1237);
        result = 31 * result + this.font.hashCode();
        result = 31 * result + this.fontSize;
        result = 31 * result + this.textureSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FontShape)) {
            return false;
        }
        FontShape other = (FontShape)obj;
        if (this.antiAlias != other.antiAlias) {
            return false;
        }
        if (!this.font.equals(other.font)) {
            return false;
        }
        if (this.fontSize != other.fontSize) {
            return false;
        }
        return this.textureSize == other.textureSize;
    }

    public String toString() {
        return String.format("FontShape [font=%s, antiAlias=%s, fontSize=%s, textureSize=%s]", this.font, this.antiAlias, this.fontSize, this.textureSize);
    }

    public static boolean isSupported(@Nullable String fontname) {
        Font[] font = FontShape.getFonts();
        for (int i = font.length - 1; i >= 0; --i) {
            if (!font[i].getName().equalsIgnoreCase(fontname)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Font[] getFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }
}

