/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.google.common.collect.Maps;
import com.kamesuta.mc.bnnwidget.font.FontSet;
import com.kamesuta.mc.bnnwidget.font.FontShape;
import com.kamesuta.mc.bnnwidget.font.LoadedFontShape;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FontStyle {
    @Nonnull
    public final FontSet font;
    public final boolean antiAlias;
    @Nonnull
    private final Map<Integer, LoadedFontShape> cache = Maps.newHashMap();

    private FontStyle(@Nonnull FontSet font, boolean antiAlias) {
        this.font = font;
        this.antiAlias = antiAlias;
    }

    @Nonnull
    public LoadedFontShape getFontShape(int size) {
        LoadedFontShape cacheshape = this.cache.get(size);
        if (cacheshape != null) {
            return cacheshape;
        }
        LoadedFontShape shape = new FontShape(this.font, this.antiAlias, size).load();
        this.cache.put(size, shape);
        return shape;
    }

    public static class Builder {
        @Nullable
        private FontSet font;
        private boolean antiAlias = true;

        public Builder() {
        }

        public Builder(@Nonnull FontStyle style) {
            this.font = style.font;
            this.antiAlias = style.antiAlias;
        }

        @Nonnull
        public Builder setFont(@Nonnull FontSet font) {
            this.font = font;
            return this;
        }

        @Nonnull
        public Builder setAntiAlias(boolean antiAlias) {
            this.antiAlias = antiAlias;
            return this;
        }

        @Nonnull
        public FontStyle build() {
            FontSet font = this.font;
            if (font == null) {
                font = new FontSet.Builder().build();
            }
            return new FontStyle(font, this.antiAlias);
        }
    }
}

