/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kamesuta.mc.bnnwidget.font.FontSet;
import com.kamesuta.mc.bnnwidget.font.FontShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.GL11;

public class LoadedFontShape {
    @Nonnull
    private final FontShape shape;

    LoadedFontShape(@Nonnull FontShape shape) {
        this.shape = shape;
    }

    @Nonnull
    private FontContent getContent() {
        return FontManager.getFont(this.shape);
    }

    @Nonnull
    public FontShape getFontShape() {
        return this.shape;
    }

    @Nonnull
    public TextureManager getTexture() {
        return this.getContent().texture;
    }

    @Nonnull
    public CharManager getCharacter() {
        return this.getContent().character;
    }

    @Nonnull
    public FontSet.SizedFontSet getSizedFont() {
        return this.getContent().sizedFont;
    }

    static class TextureManager {
        @Nonnull
        private final FontShape base;
        @Nonnull
        private Set<FontAtlas.TextureSlot.FontImage> images;
        @Nonnull
        private FontAtlas.TextureSlot.FontImage image;
        private int rowHeight = 0;
        private int positionX = 0;
        private int positionY = 0;

        public TextureManager(@Nonnull FontShape base) {
            this.base = base;
            this.images = Sets.newHashSet();
            this.image = this.newPage();
        }

        @Nonnull
        private FontAtlas.TextureSlot.FontImage newPage() {
            FontAtlas.TextureSlot.FontImage img = new FontAtlas.TextureSlot.FontImage(this.base);
            this.images.add(img);
            return img;
        }

        @Nonnull
        private FontAtlas.TextureSlot alloc(@Nonnull TextureSize size) {
            int width = size.width;
            int height = size.height;
            if (this.positionX + width >= this.base.textureSize) {
                this.positionX = 0;
                this.positionY += this.rowHeight;
                this.rowHeight = 0;
            }
            if (height > this.rowHeight) {
                this.rowHeight = height;
            }
            if (this.positionY + this.rowHeight > this.base.textureSize) {
                this.image = this.newPage();
                this.positionX = 0;
                this.positionY = 0;
            }
            FontAtlas.TextureSlot slot = new FontAtlas.TextureSlot(this.image, this.positionX, this.positionY);
            this.positionX += width;
            return slot;
        }

        @Nonnull
        public FontAtlas uploadFont(@Nonnull TextureSize size, @Nonnull BufferedImage fontImage) {
            FontAtlas.TextureSlot loc = this.alloc(size);
            loc.image.write(fontImage, loc.storedX, loc.storedY);
            return new FontAtlas(size, loc);
        }

        public void dispose() {
            for (FontAtlas.TextureSlot.FontImage image : this.images) {
                if (image == null) continue;
                image.dispose();
            }
            this.image.dispose();
        }
    }

    static class TextureSize {
        public final int width;
        public final int height;

        public TextureSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    static class FontAtlas {
        @Nonnull
        public final TextureSize size;
        @Nonnull
        public final TextureSlot location;

        public FontAtlas(@Nonnull TextureSize size, @Nonnull TextureSlot location) {
            this.size = size;
            this.location = location;
        }

        public static class TextureSlot {
            @Nonnull
            public final FontImage image;
            public final int storedX;
            public final int storedY;

            public TextureSlot(@Nonnull FontImage image, int storedX, int storedY) {
                this.image = image;
                this.storedX = storedX;
                this.storedY = storedY;
            }

            public static class FontImage {
                public final int textureID;

                protected FontImage(@Nonnull FontShape base, int textureID) {
                    this.textureID = textureID;
                    TextureUtil.func_110991_a((int)textureID, (int)base.textureSize, (int)base.textureSize);
                }

                public FontImage(@Nonnull FontShape base) {
                    this(base, GL11.glGenTextures());
                }

                public void write(@Nonnull BufferedImage image, int storedX, int storedY) {
                    TextureUtil.func_110995_a((int)this.textureID, (BufferedImage)image, (int)storedX, (int)storedY, (boolean)false, (boolean)false);
                }

                public void dispose() {
                    TextureUtil.func_147942_a((int)this.textureID);
                }
            }
        }
    }

    static class CharManager {
        @Nonnull
        private static final Graphics2D g = new BufferedImage(1, 1, 2).createGraphics();
        @Nonnull
        private final FontShape shape;
        @Nonnull
        private final FontSet.SizedFontSet sizedFont;
        @Nonnull
        private final TextureManager texture;
        @Nonnull
        private Map<Character, FontAtlas> customChars = Maps.newHashMap();

        public CharManager(@Nonnull FontShape shape, @Nonnull FontSet.SizedFontSet sizedFont, @Nonnull TextureManager texture) {
            this.shape = shape;
            this.sizedFont = sizedFont;
            this.texture = texture;
        }

        @Nonnull
        private BufferedImage getFontImage(char ch) {
            int charheight;
            Font font = this.sizedFont.getCharFont(ch);
            g.setFont(font);
            FontMetrics fontMetrics = g.getFontMetrics();
            int charwidth = fontMetrics.charWidth(ch);
            if (charwidth <= 0) {
                charwidth = 7;
            }
            if ((charheight = fontMetrics.getHeight()) <= 0) {
                charheight = this.shape.fontSize;
            }
            BufferedImage fontImage = new BufferedImage(charwidth, charheight, 2);
            Graphics2D gt = (Graphics2D)fontImage.getGraphics();
            if (this.shape.antiAlias) {
                gt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            gt.setFont(font);
            gt.setColor(Color.WHITE);
            gt.drawString(String.valueOf(ch), 0, fontMetrics.getAscent());
            gt.dispose();
            return fontImage;
        }

        @Nonnull
        public FontAtlas getFont(char ch) {
            FontAtlas stored = this.customChars.get(Character.valueOf(ch));
            if (stored != null) {
                return stored;
            }
            BufferedImage fontImage = this.getFontImage(ch);
            FontAtlas storage = this.texture.uploadFont(new TextureSize(fontImage.getWidth(), fontImage.getHeight()), fontImage);
            this.customChars.put(Character.valueOf(ch), storage);
            return storage;
        }
    }

    static class FontManager {
        @Nonnull
        private static Map<FontShape, FontContent> fonts = Maps.newHashMap();
        private static final long collectTime = TimeUnit.SECONDS.toMillis(1L);
        private static long lastaccess = -1L;

        FontManager() {
        }

        @Nonnull
        public static FontContent getFont(@Nonnull FontShape shape) {
            long time = System.currentTimeMillis();
            FontContent font = fonts.get(shape);
            if (font != null) {
                return font;
            }
            font = new FontContent(shape);
            font.lastaccess = time;
            fonts.put(shape, font);
            if (lastaccess >= 0L && time - lastaccess > collectTime) {
                FontManager.gc(time);
            }
            lastaccess = time;
            return font;
        }

        private static void gc(long time) {
            Iterator<Map.Entry<FontShape, FontContent>> itr = fonts.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<FontShape, FontContent> entry = itr.next();
                FontContent content = entry.getValue();
                if (content.lastaccess < 0L || time - content.lastaccess <= collectTime) continue;
                content.dispose();
                itr.remove();
            }
        }
    }

    static class FontContent {
        @Nonnull
        public final TextureManager texture;
        @Nonnull
        public final CharManager character;
        @Nonnull
        public final FontSet.SizedFontSet sizedFont;
        protected long lastaccess = -1L;

        public FontContent(@Nonnull TextureManager texture, @Nonnull CharManager character, @Nonnull FontSet.SizedFontSet sizedFont) {
            this.texture = texture;
            this.character = character;
            this.sizedFont = sizedFont;
        }

        public FontContent(@Nonnull FontShape shape) {
            this.texture = new TextureManager(shape);
            this.sizedFont = shape.font.getSizedFont(shape.fontSize);
            this.character = new CharManager(shape, this.sizedFont, this.texture);
        }

        public void dispose() {
            this.texture.dispose();
        }
    }
}

