/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.kamesuta.mc.bnnwidget.font.FontPosition;
import com.kamesuta.mc.bnnwidget.font.FontShape;
import com.kamesuta.mc.bnnwidget.font.WFont;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.WGui;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MinecraftFontRenderer
extends FontRenderer {
    private static final float scale = 0.5f;
    private final WFont font;
    private final FontPosition pdraw;

    public MinecraftFontRenderer(WFont font, int fontheight) {
        super(WGui.mc.field_71474_y, null, null, true);
        this.pdraw = new FontPosition().setFontSize(FontShape.getFontSize(this.field_78288_b));
        this.font = font;
        this.field_78288_b = fontheight;
    }

    protected void bindTexture(@Nullable ResourceLocation location) {
    }

    public void func_110549_a(@Nullable IResourceManager resourceManager) {
    }

    public int func_175063_a(@Nullable String str, float x, float y, int color) {
        return this.func_175065_a(str, x, y, color, true);
    }

    public int func_78276_b(@Nullable String str, int x, int y, int color) {
        return this.func_175065_a(str, x, y, color, false);
    }

    public int func_175065_a(@Nullable String str, float x, float y, int color, boolean shadow) {
        if (str != null) {
            OpenGL.glColorRGB(color);
            this.font.drawString(this.pdraw.setPosition(x, y).setText(str).setScale(0.5f, 0.5f));
        }
        return this.func_78256_a(str);
    }

    public int func_78256_a(@Nullable String str) {
        if (str == null) {
            return 0;
        }
        return (int)this.font.getWidth(this.pdraw.setText(str).setAlign(WGui.Align.LEFT).setScale(0.5f, 0.5f));
    }

    public int func_78263_a(char c) {
        return (int)this.font.getCharWidth(c, -1, 0.5f);
    }

    public String func_78269_a(String str, int width) {
        return this.func_78262_a(str, width, false);
    }

    public String func_78262_a(String str, int width, boolean trimRight) {
        StringBuilder stringbuilder = new StringBuilder();
        float j = 0.0f;
        int k = trimRight ? str.length() - 1 : 0;
        int l = trimRight ? -1 : 1;
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i1 = k; i1 >= 0 && i1 < str.length() && j < (float)width; i1 += l) {
            char c0 = str.charAt(i1);
            float j1 = this.font.getCharWidth(c0, -1, 0.25f);
            if (flag1) {
                flag1 = false;
                if (c0 != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag2 = false;
                    }
                } else {
                    flag2 = true;
                }
            } else if (j1 < 0.0f) {
                flag1 = true;
            } else {
                j += j1;
                if (flag2) {
                    j += 1.0f;
                }
            }
            if (j > (float)width) break;
            if (trimRight) {
                stringbuilder.insert(0, c0);
                continue;
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    public void func_78279_b(String str, int x, int y, int color, int p_78279_5_) {
        str = this.trimStringNewline(str);
        this.renderSplitString(str, x, y, color, false);
    }

    private String trimStringNewline(String str) {
        while (str != null && str.endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private void renderSplitString(String str, int x, int y, int color, boolean shadow) {
        List<String> list = this.func_78271_c(str, color);
        for (String s1 : list) {
            this.func_175065_a(s1, x, y, color, shadow);
            y += this.field_78288_b;
        }
    }

    public int func_78267_b(String str, int maxLength) {
        return this.field_78288_b * this.func_78271_c(str, maxLength).size();
    }

    private String wrapFormattedStringToWidth0(String p_78280_1_, int p_78280_2_) {
        int j = this.sizeStringToWidth(p_78280_1_, p_78280_2_);
        if (p_78280_1_.length() <= j) {
            return p_78280_1_;
        }
        String s1 = p_78280_1_.substring(0, j);
        char c0 = p_78280_1_.charAt(j);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s2 = MinecraftFontRenderer.getFormatFromString(s1) + p_78280_1_.substring(j + (flag ? 1 : 0));
        return s1 + "\n" + this.wrapFormattedStringToWidth0(s2, p_78280_2_);
    }

    private static boolean isFormatColor(char p_78272_0_) {
        return p_78272_0_ >= '0' && p_78272_0_ <= '9' || p_78272_0_ >= 'a' && p_78272_0_ <= 'f' || p_78272_0_ >= 'A' && p_78272_0_ <= 'F';
    }

    private static boolean isFormatSpecial(char p_78270_0_) {
        return p_78270_0_ >= 'k' && p_78270_0_ <= 'o' || p_78270_0_ >= 'K' && p_78270_0_ <= 'O' || p_78270_0_ == 'r' || p_78270_0_ == 'R';
    }

    private int sizeStringToWidth(String p_78259_1_, int p_78259_2_) {
        int l;
        int j = p_78259_1_.length();
        int k = 0;
        int i1 = -1;
        boolean flag = false;
        for (l = 0; l < j; ++l) {
            char c0 = p_78259_1_.charAt(l);
            switch (c0) {
                case '\n': {
                    --l;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (l >= j - 1) break;
                    if ((c1 = p_78259_1_.charAt(++l)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !MinecraftFontRenderer.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                    break;
                }
                case ' ': {
                    i1 = l;
                }
                default: {
                    k += this.func_78263_a(c0);
                    if (!flag) break;
                    ++k;
                }
            }
            if (c0 == '\n') {
                i1 = ++l;
                break;
            }
            if (k > p_78259_2_) break;
        }
        return l != j && i1 != -1 && i1 < l ? i1 : l;
    }

    public void func_78264_a(boolean isUnicode) {
    }

    public boolean func_82883_a() {
        return true;
    }

    public void func_78275_b(boolean isBidi) {
    }

    public List<String> func_78271_c(String p_78271_1_, int p_78271_2_) {
        return Arrays.asList(this.wrapFormattedStringToWidth0(p_78271_1_, p_78271_2_).split("\n"));
    }

    public static String getFormatFromString(String text) {
        String s1 = "";
        int i = -1;
        int j = text.length();
        while ((i = text.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = text.charAt(i + 1);
            if (MinecraftFontRenderer.isFormatColor(c0)) {
                s1 = "\u00a7" + c0;
                continue;
            }
            if (!MinecraftFontRenderer.isFormatSpecial(c0)) continue;
            s1 = s1 + "\u00a7" + c0;
        }
        return s1;
    }

    public boolean func_78260_a() {
        return false;
    }
}

