/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.kamesuta.mc.bnnwidget.font.FontPosition;
import com.kamesuta.mc.bnnwidget.font.FontSet;
import com.kamesuta.mc.bnnwidget.font.FontStyle;
import com.kamesuta.mc.bnnwidget.font.LoadedFontShape;
import com.kamesuta.mc.bnnwidget.font.WFont;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.WGui;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class TrueTypeFont
implements WFont {
    @Nonnull
    private static Random fontRandom = new Random();
    @Nonnull
    private final FontStyle style;
    @Nonnull
    private final FontStyle styleitalic;
    @Nonnull
    private static final int[] colorCode = new int[32];
    @Nonnull
    private final FontPosition fp = new FontPosition();

    public TrueTypeFont(@Nonnull FontStyle style) {
        this.style = style;
        FontSet src = style.font;
        this.styleitalic = (src.style & 2) != 0 ? style : new FontStyle.Builder(style).setFont(src.deriveFontStyle(src.style | 2)).build();
    }

    @Override
    public float drawString(@Nonnull FontPosition p) {
        if (p.isShadow()) {
            float l = this.drawString0(this.fp.set(p).setPosition(p.getX() + p.getShadowX(), p.getY() + p.getShadowY()), true);
            l = Math.max(l, this.drawString0(p, false));
            return l;
        }
        return this.drawString0(p, false);
    }

    protected float drawString0(FontPosition p, boolean drawingShadow) {
        float startY;
        int color;
        Color pcolor = OpenGL.glGetColor();
        if (drawingShadow) {
            color = WRenderer.toColorCode(pcolor.getRed() / 4, pcolor.getGreen() / 4, pcolor.getBlue() / 4, pcolor.getAlpha());
            OpenGL.glColorRGBA(color);
        } else {
            color = pcolor.getRGB();
        }
        int startIndex = p.getStartIndex();
        int endIndex = p.getEndIndex();
        String whatchars = p.getText();
        boolean colorcode = p.isUseCode();
        float x = p.getX();
        float y = p.getY();
        float scaleX = p.getScaleX();
        float scaleY = p.getScaleY();
        int fontsize = p.getFontSize();
        WGui.Align align = p.getAlign();
        WGui.VerticalAlign valign = p.getVAlign();
        float totalwidth = 0.0f;
        Object[] line = StringUtils.split((String)whatchars, (char)'\n');
        UnmodifiableIterator lineitr = Iterators.forArray((Object[])line);
        float guesswidth = lineitr.hasNext() ? this.getWidth(new FontPosition(p).setText((String)lineitr.next())) : 0.0f;
        int i = startIndex;
        switch (valign) {
            default: {
                startY = 0.0f;
                break;
            }
            case MIDDLE: {
                startY = (float)(-StringUtils.countMatches((CharSequence)whatchars, (CharSequence)"\n") * this.style.getFontShape((int)fontsize).getFontShape().fontSize) / 2.0f - 12.0f;
                break;
            }
            case BOTTOM: {
                startY = (float)(-StringUtils.countMatches((CharSequence)whatchars, (CharSequence)"\n") * this.style.getFontShape((int)fontsize).getFontShape().fontSize) - 4.0f;
            }
        }
        boolean randomStyle = false;
        boolean boldStyle = false;
        boolean strikethroughStyle = false;
        boolean underlineStyle = false;
        boolean italicStyle = false;
        while (i >= startIndex && i <= endIndex) {
            char charCurrent = whatchars.charAt(i);
            if (charCurrent == '\n') {
                startY += (float)this.style.getFontShape((int)fontsize).getFontShape().fontSize;
                totalwidth = 0.0f;
                guesswidth = lineitr.hasNext() ? this.getWidth(new FontPosition(p).setText((String)lineitr.next())) : 0.0f;
            } else {
                boolean draw = true;
                if (colorcode && charCurrent == '\u00a7' && i + 1 < whatchars.length()) {
                    int j = "0123456789abcdefklmnor".indexOf(whatchars.toLowerCase().charAt(i + 1));
                    draw = false;
                    if (0 <= j && j < 16) {
                        randomStyle = false;
                        boldStyle = false;
                        strikethroughStyle = false;
                        underlineStyle = false;
                        italicStyle = false;
                        if (j < 0 || j > 15) {
                            j = 15;
                        }
                        if (drawingShadow) {
                            j += 16;
                        }
                        int k = colorCode[j];
                        OpenGL.glColorRGBA(k | pcolor.getAlpha() << 24);
                    } else if (j == 16) {
                        randomStyle = true;
                    } else if (j == 17) {
                        boldStyle = true;
                    } else if (j == 18) {
                        strikethroughStyle = true;
                    } else if (j == 19) {
                        underlineStyle = true;
                    } else if (j == 20) {
                        italicStyle = true;
                    } else if (j == 21) {
                        randomStyle = false;
                        boldStyle = false;
                        strikethroughStyle = false;
                        underlineStyle = false;
                        italicStyle = false;
                        OpenGL.glColorRGBA(color);
                    } else {
                        draw = true;
                    }
                    if (!draw) {
                        ++i;
                    }
                }
                if (draw) {
                    float correctX;
                    int srcfontwidth = this.getCharWidth(charCurrent, fontsize);
                    String str = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
                    int j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(charCurrent);
                    String random = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
                    if (randomStyle && j != -1) {
                        j = fontRandom.nextInt(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".length());
                        charCurrent = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".charAt(j);
                    }
                    switch (align) {
                        default: {
                            correctX = 0.0f;
                            break;
                        }
                        case CENTER: {
                            correctX = guesswidth / 2.0f;
                            break;
                        }
                        case RIGHT: {
                            correctX = guesswidth;
                        }
                    }
                    this.drawChar(charCurrent, totalwidth, startY, scaleX, scaleY, x - correctX, y, fontsize, italicStyle);
                    if (boldStyle) {
                        this.drawChar(charCurrent, totalwidth, startY, scaleX, scaleY, x - correctX + 1.0f * scaleX, y, fontsize, italicStyle);
                        totalwidth += 1.0f * scaleX;
                    }
                    this.doDraw(charCurrent, totalwidth / 2.0f, startY, scaleX, scaleY, x - correctX, y, (float)srcfontwidth - 1.0f, fontsize, strikethroughStyle, underlineStyle);
                    totalwidth += (float)srcfontwidth;
                }
            }
            ++i;
        }
        OpenGL.glColor(pcolor);
        return totalwidth * scaleX;
    }

    protected void doDraw(char ch, float x, float y, float scaleX, float scaleY, float offsetX, float offsetY, float width, int fontsize, boolean strikethroughStyle, boolean underlineStyle) {
        LoadedFontShape.FontAtlas intObject = this.style.getFontShape(fontsize).getCharacter().getFont(ch);
        int height = intObject.size.height;
        if (strikethroughStyle) {
            OpenGL.glDisable(3553);
            WGui.draw(Area.size(x * scaleX + offsetX, (y + (float)(height / 2)) * scaleY + offsetY, width * scaleX, 1.0f * scaleY));
            OpenGL.glEnable(3553);
        }
        if (underlineStyle) {
            OpenGL.glDisable(3553);
            WGui.draw(Area.size((x - 1.0f) * scaleX + offsetX, (y + (float)height - 3.0f - 1.0f) * scaleY + offsetY, (width + 1.0f) * scaleX, 1.0f * scaleY));
            OpenGL.glEnable(3553);
        }
    }

    public void drawChar(char ch, float x, float y, float scaleX, float scaleY, float offsetX, float offsetY, int fontsize, boolean italicStyle) {
        LoadedFontShape.FontAtlas intObject = (italicStyle ? this.styleitalic : this.style).getFontShape(fontsize).getCharacter().getFont(ch);
        WRenderer.startTexture();
        OpenGL.glBindTexture(3553, intObject.location.image.textureID);
        float size = this.style.getFontShape((int)fontsize).getFontShape().textureSize;
        WGui.drawTexture(Area.size(x * scaleX + offsetX, y * scaleY + offsetY, (float)intObject.size.width * scaleX, (float)intObject.size.height * scaleY), null, Area.size((float)intObject.location.storedX / size, (float)intObject.location.storedY / size, (float)intObject.size.width / size, (float)intObject.size.height / size));
    }

    @Override
    public float getWidth(@Nonnull FontPosition p) {
        int startIndex = p.getStartIndex();
        int endIndex = p.getEndIndex();
        String whatchars = p.getText();
        boolean colorcode = p.isUseCode();
        float scaleX = p.getScaleX();
        int fontsize = p.getFontSize();
        float totalwidth = 0.0f;
        boolean boldStyle = false;
        for (int i = startIndex; i >= startIndex && i <= endIndex; ++i) {
            char j;
            char charCurrent = whatchars.charAt(i);
            if (charCurrent == '\n') {
                totalwidth = 0.0f;
            } else if (colorcode && charCurrent == '\u00a7' && i + 1 < whatchars.length() && "0123456789abcdefklmnor".indexOf(j = whatchars.toLowerCase().charAt(i + 1)) != -1) {
                if ('\u0000' <= j && j < '\u0010') {
                    boldStyle = false;
                } else if (j == '\u0011') {
                    boldStyle = true;
                } else if (j == '\u0015') {
                    boldStyle = false;
                }
                i += 2;
            }
            int srcfontwidth = this.getCharWidth(charCurrent, fontsize);
            if (boldStyle) {
                totalwidth += 1.0f;
            }
            totalwidth += (float)srcfontwidth;
        }
        return totalwidth * scaleX;
    }

    @Override
    public float getCharWidth(char ch, int fontsize, float scaleX) {
        return (float)this.getCharWidth(ch, fontsize) * scaleX;
    }

    public int getCharWidth(char ch, int fontsize) {
        return this.style.getFontShape((int)fontsize).getCharacter().getFont((char)ch).size.width;
    }

    @Override
    @Nonnull
    public FontStyle getStyle() {
        return this.style;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            TrueTypeFont.colorCode[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
    }
}

