/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.font;

import com.kamesuta.mc.bnnwidget.font.FontPosition;
import com.kamesuta.mc.bnnwidget.font.FontSet;
import com.kamesuta.mc.bnnwidget.font.FontStyle;
import com.kamesuta.mc.bnnwidget.font.TrueTypeFont;
import com.kamesuta.mc.bnnwidget.font.WFont;
import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.render.WGui;
import javax.annotation.Nonnull;

public class WFontRenderer
implements WFont {
    @Nonnull
    public static final WFont defaultFont;
    @Nonnull
    private final WFont font;
    @Nonnull
    private FontPosition setting = new FontPosition();
    @Nonnull
    private FontPosition p = new FontPosition();

    public WFontRenderer(@Nonnull WFont font) {
        this.font = font;
    }

    public WFontRenderer() {
        this(defaultFont);
    }

    @Override
    public float drawString(@Nonnull FontPosition p) {
        return this.font.drawString(p);
    }

    @Override
    public float getWidth(@Nonnull FontPosition p) {
        return this.font.getWidth(p);
    }

    @Override
    public float getCharWidth(char ch, int fontsize, float scaleX) {
        return this.font.getCharWidth(ch, fontsize, scaleX);
    }

    @Override
    @Nonnull
    public FontStyle getStyle() {
        return this.font.getStyle();
    }

    @Nonnull
    public WFontRenderer setSetting(@Nonnull FontPosition setting) {
        this.setting = setting;
        return this;
    }

    @Nonnull
    public FontPosition getSetting() {
        return this.setting;
    }

    @Deprecated
    public void drawString(String str, float x, float y, float w, float h, float scale, @Nonnull WGui.Align align, @Nonnull WGui.VerticalAlign valign, boolean shadow) {
        float dx;
        float abswidth = w / scale;
        float absheight = h / scale;
        float correctscale = 1.0f;
        switch (align) {
            default: {
                dx = 0.0f;
                break;
            }
            case CENTER: {
                dx = w / 2.0f;
                break;
            }
            case RIGHT: {
                dx = w;
            }
        }
        this.p.set(this.p).setScale(1.0f).setText(str).setAlign(align).setPosition(x + dx, y).setFontSize(Math.round(absheight)).setShadow(shadow);
        float ratiowh = this.font.getWidth(this.p) / (float)Math.round(absheight);
        if (absheight * ratiowh > abswidth) {
            float newwidth = absheight * ratiowh;
            correctscale *= abswidth / newwidth;
        } else {
            correctscale *= 1.0f;
        }
        float correctheight = absheight * correctscale;
        float correctedscale = correctheight / (float)Math.ceil(correctheight);
        this.font.drawString(this.p.setScale(scale * correctedscale).setFontSize((int)Math.floor(correctheight)));
    }

    public void drawString(String str, Area a, float scale, @Nonnull WGui.Align align, @Nonnull WGui.VerticalAlign valign, boolean shadow) {
        this.drawString(str, a.x1(), a.y1(), a.w(), a.h(), scale, align, valign, shadow);
    }

    public void drawString(String str, Area a, float scale, @Nonnull WGui.Align align, boolean shadow) {
        this.drawString(str, a, scale, align, WGui.VerticalAlign.TOP, shadow);
    }

    static {
        FontSet fontSet = new FontSet.Builder().addName("HGP\u5275\u82f1\u89d2\uff8e\uff9f\uff6f\uff8c\uff9f\u4f53").setStyle(0).build();
        FontStyle style = new FontStyle.Builder().setFont(fontSet).build();
        defaultFont = new TrueTypeFont(style);
    }
}

