/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.motion;

import com.google.common.collect.Lists;
import com.kamesuta.mc.bnnwidget.motion.ICompoundMotion;
import com.kamesuta.mc.bnnwidget.motion.IMotion;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompoundMotion
implements IMotion,
ICompoundMotion {
    protected boolean paused = true;
    @Nonnull
    protected TaskList<IMotion> tasks = new TaskList();
    @Nullable
    protected IMotion current;
    protected float firstcoord;
    protected float coord;
    protected boolean looplast;
    @Nullable
    protected Runnable after;
    protected boolean usecoord;

    public CompoundMotion() {
    }

    public CompoundMotion(float coord) {
        this();
        this.firstcoord = coord;
        this.usecoord = true;
        this.coord = coord;
    }

    @Override
    @Nonnull
    public CompoundMotion add(@Nonnull IMotion animation) {
        this.tasks.add(animation);
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion setLoop(boolean b) {
        this.looplast = b;
        return this;
    }

    protected void setCurrent(@Nullable IMotion current) {
        if (this.current != null) {
            this.current.onFinished();
        }
        this.current = current;
    }

    @Override
    @Nonnull
    public CompoundMotion stopFirst() {
        this.tasks.finish();
        this.setCurrent(null);
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion stop() {
        this.coord = this.get();
        this.stopFirst();
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion stopLast() {
        this.coord = this.getLast();
        this.stopFirst();
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion pause() {
        this.paused = true;
        if (this.current != null) {
            this.current.pause();
        }
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion start() {
        this.paused = false;
        if (this.current != null) {
            this.current.resume();
        }
        return this;
    }

    @Nullable
    protected IMotion nextCurrent() {
        IMotion m = this.tasks.poll();
        this.setCurrent(m);
        return m;
    }

    @Override
    @Nonnull
    public CompoundMotion next() {
        this.nextCurrent();
        this.start();
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion stopNext() {
        boolean notfinish;
        boolean bl = notfinish = this.current != null && !this.current.isFinished();
        if (!notfinish) {
            if (!this.paused) {
                if (this.current != null) {
                    this.coord = this.current.getEnd(this.coord);
                }
                this.next();
            }
            if (this.looplast && this.tasks.isFinished()) {
                this.restart();
            }
        }
        return this;
    }

    @Override
    @Nullable
    public IMotion getAnimation() {
        this.stopNext();
        return this.current;
    }

    @Override
    @Nullable
    public IMotion getAnimationLast() {
        return this.tasks.getLast();
    }

    @Override
    public float get() {
        return this.get(this.coord);
    }

    @Override
    public float get(float start) {
        IMotion a = this.getAnimation();
        if (!this.usecoord) {
            this.usecoord = true;
            this.firstcoord = start;
            this.coord = start;
        }
        if (a != null) {
            return a.get(this.coord);
        }
        return this.coord;
    }

    @Override
    public float getLast() {
        IMotion a = this.tasks.getLast();
        if (a != null) {
            return a.getEnd(this.coord);
        }
        return this.coord;
    }

    @Override
    public boolean isFinished() {
        this.stopNext();
        IMotion last = this.tasks.getLast();
        boolean notfinish = last != null && !last.isFinished();
        return !this.looplast && !notfinish && this.tasks.isLast();
    }

    @Override
    @Nonnull
    public CompoundMotion restart() {
        for (IMotion m : this.tasks) {
            m.pause().restart();
        }
        this.coord = this.firstcoord;
        this.tasks.restart();
        this.next();
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion reset() {
        this.tasks.reset();
        this.coord = this.firstcoord;
        this.setCurrent(null);
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion finish() {
        this.stopLast();
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion resume() {
        this.start();
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion setTime(float time) {
        block2: {
            IMotion m;
            float t = 0.0f;
            while ((m = this.nextCurrent()) != null) {
                float d = m.getDuration();
                float newtime = t + d;
                if (newtime > time) {
                    m.setTime(time - t);
                    break block2;
                }
                t = newtime;
            }
            this.stopLast();
        }
        return this;
    }

    @Override
    @Nonnull
    public CompoundMotion setAfter(@Nullable Runnable r) {
        this.after = r;
        return this;
    }

    @Override
    public float getDuration() {
        float d = 0.0f;
        for (IMotion m : this.tasks) {
            d += m.getDuration();
        }
        return d;
    }

    @Override
    public float getEnd(float start) {
        return this.getLast();
    }

    @Override
    @Nullable
    public Runnable getAfter() {
        return this.after;
    }

    @Override
    public void onFinished() {
        if (this.after != null) {
            this.after.run();
        }
    }

    public String toString() {
        return String.format("CompoundMotion [paused=%s, tasks=%s, looplast=%s]", this.paused, this.tasks, this.looplast);
    }

    @Nonnull
    public static CompoundMotion of(IMotion ... motions) {
        CompoundMotion compound = new CompoundMotion();
        for (IMotion motion : motions) {
            if (motion == null) continue;
            compound.add(motion);
        }
        return compound;
    }

    @Nonnull
    public static CompoundMotion of(float coord, IMotion ... motions) {
        CompoundMotion compound = new CompoundMotion(coord);
        for (IMotion motion : motions) {
            if (motion == null) continue;
            compound.add(motion);
        }
        return compound;
    }

    public static class TaskList<E>
    implements Iterable<E> {
        @Nonnull
        private final List<E> tasks = Lists.newArrayList();
        private int pos;

        public void add(@Nonnull E e) {
            this.tasks.add(e);
        }

        @Nullable
        protected E get(int pos) {
            if (0 <= pos && pos < this.tasks.size()) {
                return this.tasks.get(pos);
            }
            return null;
        }

        @Nullable
        public E get() {
            return this.get(this.pos);
        }

        @Nullable
        public E poll() {
            if (this.isEmpty()) {
                return this.get();
            }
            return this.get(this.pos++);
        }

        public void reset() {
            this.tasks.clear();
            this.restart();
        }

        public void restart() {
            this.pos = 0;
        }

        public void finish() {
            this.pos = this.tasks.size();
        }

        @Nullable
        public E getLast() {
            return this.get(this.tasks.size() - 1);
        }

        public boolean isEmpty() {
            return this.tasks.isEmpty();
        }

        public boolean isFinished() {
            return this.pos > this.tasks.size();
        }

        public boolean isLast() {
            return this.pos >= this.tasks.size();
        }

        @Override
        @Nullable
        public Iterator<E> iterator() {
            return this.tasks.iterator();
        }

        public String toString() {
            return String.format("TaskList [tasks=%s, pos=%s]", this.tasks, this.pos);
        }
    }
}

