/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.motion;

import com.google.common.collect.ImmutableMap;
import com.kamesuta.mc.bnnwidget.motion.Easing;
import com.kamesuta.mc.bnnwidget.motion.IMotion;
import com.kamesuta.mc.bnnwidget.motion.Motion;
import javax.annotation.Nonnull;

public enum Easings implements Easing
{
    easeLinear(0){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * t / d + b;
        }
    }
    ,
    easeInQuad(1){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * (t /= d) * t + b;
        }
    }
    ,
    easeOutQuad(2){

        @Override
        public double easing(double t, double b, double c, double d) {
            return -c * (t /= d) * (t - 2.0) + b;
        }
    }
    ,
    easeInOutQuad(3){

        @Override
        public double easing(double t, double b, double c, double d) {
            if ((t /= d / 2.0) < 1.0) {
                return c / 2.0 * t * t + b;
            }
            return -c / 2.0 * ((t -= 1.0) * (t - 2.0) - 1.0) + b;
        }
    }
    ,
    easeInCubic(4){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * (t /= d) * t * t + b;
        }
    }
    ,
    easeOutCubic(5){

        @Override
        public double easing(double t, double b, double c, double d) {
            t /= d;
            return c * ((t -= 1.0) * t * t + 1.0) + b;
        }
    }
    ,
    easeInOutCubic(6){

        @Override
        public double easing(double t, double b, double c, double d) {
            double d2;
            t /= d / 2.0;
            if (d2 < 1.0) {
                return c / 2.0 * t * t * t + b;
            }
            return c / 2.0 * ((t -= 2.0) * t * t + 2.0) + b;
        }
    }
    ,
    easeInQuart(7){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * (t /= d) * t * t * t + b;
        }
    }
    ,
    easeOutQuart(8){

        @Override
        public double easing(double t, double b, double c, double d) {
            t /= d;
            return -c * ((t -= 1.0) * t * t * t - 1.0) + b;
        }
    }
    ,
    easeInOutQuart(9){

        @Override
        public double easing(double t, double b, double c, double d) {
            if ((t /= d / 2.0) < 1.0) {
                return c / 2.0 * t * t * t * t + b;
            }
            return -c / 2.0 * ((t -= 2.0) * t * t * t - 2.0) + b;
        }
    }
    ,
    easeInQuint(10){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * (t /= d) * t * t * t * t + b;
        }
    }
    ,
    easeOutQuint(11){

        @Override
        public double easing(double t, double b, double c, double d) {
            t /= d;
            return c * ((t -= 1.0) * t * t * t * t + 1.0) + b;
        }
    }
    ,
    easeInOutQuint(12){

        @Override
        public double easing(double t, double b, double c, double d) {
            if ((t /= d / 2.0) < 1.0) {
                return c / 2.0 * t * t * t * t * t + b;
            }
            return c / 2.0 * ((t -= 2.0) * t * t * t * t + 2.0) + b;
        }
    }
    ,
    easeInSine(13){

        @Override
        public double easing(double t, double b, double c, double d) {
            return -c * Math.cos(t / d * 1.5707963267948966) + c + b;
        }
    }
    ,
    easeOutSine(14){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * Math.sin(t / d * 1.5707963267948966) + b;
        }
    }
    ,
    easeInOutSine(15){

        @Override
        public double easing(double t, double b, double c, double d) {
            return -c / 2.0 * (Math.cos(Math.PI * t / d) - 1.0) + b;
        }
    }
    ,
    easeInExpo(16){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * Math.pow(2.0, 10.0 * (t / d - 1.0)) + b;
        }
    }
    ,
    easeOutExpo(17){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c * (-Math.pow(2.0, -10.0 * t / d) + 1.0) + b;
        }
    }
    ,
    easeInOutExpo(18){

        @Override
        public double easing(double t, double b, double c, double d) {
            if ((t /= d / 2.0) < 1.0) {
                return c / 2.0 * Math.pow(2.0, 10.0 * (t - 1.0)) + b;
            }
            return c / 2.0 * (-Math.pow(2.0, -10.0 * (t -= 1.0)) + 2.0) + b;
        }
    }
    ,
    easeInCirc(19){

        @Override
        public double easing(double t, double b, double c, double d) {
            return -c * (Math.sqrt(1.0 - (t /= d) * t) - 1.0) + b;
        }
    }
    ,
    easeOutCirc(20){

        @Override
        public double easing(double t, double b, double c, double d) {
            t /= d;
            return c * Math.sqrt(1.0 - (t -= 1.0) * t) + b;
        }
    }
    ,
    easeInOutCirc(21){

        @Override
        public double easing(double t, double b, double c, double d) {
            if ((t /= d / 2.0) < 1.0) {
                return -c / 2.0 * (Math.sqrt(1.0 - t * t) - 1.0) + b;
            }
            return c / 2.0 * (Math.sqrt(1.0 - (t -= 2.0) * t) + 1.0) + b;
        }
    }
    ,
    easeInElastic(22){

        @Override
        public double easing(double t, double b, double c, double d) {
            double s = 1.70158;
            double p = 0.0;
            double a = c;
            if (t == 0.0) {
                return b;
            }
            if ((t /= d) == 1.0) {
                return b + c;
            }
            p = d * 0.3;
            if (a < Math.abs(c)) {
                a = c;
                s = p / 4.0;
            } else {
                s = p / (Math.PI * 2) * Math.asin(c / a);
            }
            return -(a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
        }
    }
    ,
    easeOutElastic(23){

        @Override
        public double easing(double t, double b, double c, double d) {
            double s = 1.70158;
            double p = 0.0;
            double a = c;
            if (t == 0.0) {
                return b;
            }
            if ((t /= d) == 1.0) {
                return b + c;
            }
            p = d * 0.3;
            if (a < Math.abs(c)) {
                a = c;
                s = p / 4.0;
            } else {
                s = p / (Math.PI * 2) * Math.asin(c / a);
            }
            return a * Math.pow(2.0, -10.0 * t) * Math.sin((t * d - s) * (Math.PI * 2) / p) + c + b;
        }
    }
    ,
    easeInOutElastic(24){

        @Override
        public double easing(double t, double b, double c, double d) {
            double s = 1.70158;
            double p = 0.0;
            double a = c;
            if (t == 0.0) {
                return b;
            }
            if ((t /= d / 2.0) == 2.0) {
                return b + c;
            }
            p = d * 0.44999999999999996;
            if (a < Math.abs(c)) {
                a = c;
                s = p / 4.0;
            } else {
                s = p / (Math.PI * 2) * Math.asin(c / a);
            }
            if (t < 1.0) {
                return -0.5 * (a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
            }
            return a * Math.pow(2.0, -10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p) * 0.5 + c + b;
        }
    }
    ,
    easeInBack(25){

        @Override
        public double easing(double t, double b, double c, double d) {
            double s = 1.70158;
            return c * (t /= d) * t * (2.70158 * t - 1.70158) + b;
        }
    }
    ,
    easeOutBack(26){

        @Override
        public double easing(double t, double b, double c, double d) {
            double s = 1.70158;
            t = t / d - 1.0;
            return c * (t * t * (2.70158 * t + 1.70158) + 1.0) + b;
        }
    }
    ,
    easeInOutBack(27){

        @Override
        public double easing(double t, double b, double c, double d) {
            double d2;
            double s = 1.70158;
            t /= d / 2.0;
            if (d2 < 1.0) {
                return c / 2.0 * (t * t * (((s *= 1.525) + 1.0) * t - s)) + b;
            }
            return c / 2.0 * ((t -= 2.0) * t * (((s *= 1.525) + 1.0) * t + s) + 2.0) + b;
        }
    }
    ,
    easeInBounce(28){

        @Override
        public double easing(double t, double b, double c, double d) {
            return c - easeOutBounce.easing(d - t, 0.0, c, d) + b;
        }
    }
    ,
    easeOutBounce(29){

        @Override
        public double easing(double t, double b, double c, double d) {
            double d2;
            t /= d;
            if (d2 < 0.36363636363636365) {
                return c * (7.5625 * t * t) + b;
            }
            if (t < 0.7272727272727273) {
                return c * (7.5625 * (t -= 0.5454545454545454) * t + 0.75) + b;
            }
            if (t < 0.9090909090909091) {
                return c * (7.5625 * (t -= 0.8181818181818182) * t + 0.9375) + b;
            }
            return c * (7.5625 * (t -= 0.9545454545454546) * t + 0.984375) + b;
        }
    }
    ,
    easeInOutBounce(30){

        @Override
        public double easing(double t, double b, double c, double d) {
            if (t < d / 2.0) {
                return easeInBounce.easing(t * 2.0, 0.0, c, d) * 0.5 + b;
            }
            return easeOutBounce.easing(t * 2.0 - d, 0.0, c, d) * 0.5 + c * 0.5 + b;
        }
    };

    public final int id;
    @Nonnull
    private static final ImmutableMap<Integer, Easings> easingIds;

    private Easings(int id) {
        this.id = id;
    }

    @Nonnull
    public IMotion move(float time, float to) {
        return Motion.easing(time, this, to);
    }

    public String toString() {
        return this.name() + "(" + this.id + ")";
    }

    @Nonnull
    public static Easings fromId(int id) {
        Easings easing = (Easings)easingIds.get((Object)id);
        if (easing == null) {
            easing = easeLinear;
        }
        return easing;
    }

    public static Easings fromString(String easing) {
        for (Easings line : Easings.values()) {
            if (!line.name().equalsIgnoreCase(easing)) continue;
            return line;
        }
        throw new IllegalArgumentException();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Easings easing : Easings.values()) {
            builder.put((Object)easing.id, (Object)easing);
        }
        easingIds = builder.build();
    }
}

