/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.motion;

import com.kamesuta.mc.bnnwidget.motion.CompoundMotion;
import com.kamesuta.mc.bnnwidget.motion.Easing;
import com.kamesuta.mc.bnnwidget.motion.IMotion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.util.Timer;

public abstract class Motion
implements IMotion {
    @Nonnull
    protected final Timer timer = new Timer();
    protected final float duration;
    @Nullable
    protected Runnable after;

    public Motion(float duration) {
        this.timer.pause();
        this.restart();
        this.duration = duration;
    }

    @Override
    @Nonnull
    public IMotion restart() {
        this.setTime(0.0f);
        return this;
    }

    @Override
    @Nonnull
    public IMotion finish() {
        this.setTime(this.duration);
        return this;
    }

    @Override
    @Nonnull
    public IMotion pause() {
        this.timer.pause();
        return this;
    }

    @Override
    @Nonnull
    public IMotion resume() {
        this.timer.resume();
        return this;
    }

    @Override
    @Nonnull
    public IMotion setTime(float time) {
        this.timer.set(time);
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.timer.getTime() >= this.duration;
    }

    @Override
    public IMotion setAfter(@Nullable Runnable r) {
        this.after = r;
        return this;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    @Nullable
    public Runnable getAfter() {
        return this.after;
    }

    @Override
    public void onFinished() {
        Runnable r = this.getAfter();
        if (r != null) {
            r.run();
        }
    }

    public String toString() {
        return String.format("Motion[(%1$ss)]", Float.valueOf(this.duration));
    }

    @Nonnull
    public static IMotion easing(float duration, @Nonnull Easing easing, float end) {
        return new EasingMotion(duration, easing, end);
    }

    @Nonnull
    public static IMotion blank(float duration) {
        return new BlankMotion(duration);
    }

    @Nonnull
    public static IMotion move(float end) {
        return new MoveMotion(end);
    }

    @Nonnull
    public static CompoundMotion of(IMotion ... motions) {
        return CompoundMotion.of(motions);
    }

    @Nonnull
    public static CompoundMotion of(float coord, IMotion ... motions) {
        return CompoundMotion.of(coord, motions);
    }

    static class MoveMotion
    extends Motion {
        protected final float end;

        public MoveMotion(float end) {
            super(0.0f);
            this.end = end;
        }

        @Override
        public float getEnd(float start) {
            return this.end;
        }

        @Override
        public float get(float start) {
            return this.end;
        }

        @Override
        @Nonnull
        public String toString() {
            return String.format("Move[->%2$s(%1$ss)]", Float.valueOf(this.duration), Float.valueOf(this.end));
        }
    }

    static class BlankMotion
    extends Motion {
        public BlankMotion(float duration) {
            super(duration);
        }

        @Override
        public float getEnd(float start) {
            return start;
        }

        @Override
        public float get(float start) {
            return start;
        }

        @Override
        public String toString() {
            return String.format("Blank[(%ss)]", Float.valueOf(this.duration));
        }
    }

    static class EasingMotion
    extends Motion {
        @Nonnull
        protected final Easing easing;
        protected final float end;

        public EasingMotion(float duration, @Nonnull Easing easing, float end) {
            super(duration);
            this.easing = easing;
            this.end = end;
        }

        @Override
        public float getEnd(float start) {
            return this.end;
        }

        @Override
        public float get(float start) {
            return (float)this.easing.easing(this.timer.getTime(), start, this.end - start, this.duration);
        }

        @Override
        public String toString() {
            return String.format("Motion[%2$s->%3$s(%1$ss)]", Float.valueOf(this.duration), this.easing, Float.valueOf(this.end));
        }
    }
}

