/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.position;

import com.kamesuta.mc.bnnwidget.position.Point;
import com.kamesuta.mc.bnnwidget.position.R;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Area {
    protected final float x1;
    protected final float y1;
    protected final float x2;
    protected final float y2;

    protected Area(float ax1, float ay1, float ax2, float ay2) {
        this.x1 = ax1;
        this.y1 = ay1;
        this.x2 = ax2;
        this.y2 = ay2;
    }

    @Nonnull
    public static Area abs(float ax1, float ay1, float ax2, float ay2) {
        return new Area(Math.min(ax1, ax2), Math.min(ay1, ay2), Math.max(ax1, ax2), Math.max(ay1, ay2));
    }

    @Nonnull
    public static Area size(float ax, float ay, float aw, float ah) {
        return Area.abs(ax, ay, ax + aw, ay + ah);
    }

    public float w() {
        return Math.abs(this.x2 - this.x1);
    }

    public float h() {
        return Math.abs(this.y2 - this.y1);
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float x2() {
        return this.x2;
    }

    public float y2() {
        return this.y2;
    }

    @Deprecated
    public float minX() {
        return this.x1();
    }

    @Deprecated
    public float maxX() {
        return this.x2();
    }

    @Deprecated
    public float minY() {
        return this.y1();
    }

    @Deprecated
    public float maxY() {
        return this.y2();
    }

    @Nonnull
    public Area child(R p) {
        return p.getAbsolute(this);
    }

    @Nonnull
    public Area child(float ax1, float ay1, float ax2, float ay2) {
        return new Area(this.x1 + ax1, this.y1 + ay1, this.x2 + ax2, this.y2 + ay2);
    }

    public boolean isVaild() {
        return this.x1 != this.x2 && this.y1 != this.y2;
    }

    public boolean pointInside(@Nonnull Point p) {
        return p.x >= this.x1 && p.x < this.x2 && p.y >= this.y1 && p.y < this.y2;
    }

    public boolean areaOverlap(@Nonnull Area a) {
        return !(a.x2() < this.x1() || a.x1() > this.x2() || a.y1() > this.y2() || a.y2() < this.y1());
    }

    public boolean areaInside(@Nonnull Area a) {
        return a.x1() >= this.x1() && a.y1() >= this.y1() && a.x2() <= this.x2() && a.y2() <= this.y2();
    }

    @Nullable
    public Area trimArea(@Nonnull Area c) {
        if (!this.areaOverlap(c)) {
            return null;
        }
        return new Area(Math.max(this.x1(), c.x1()), Math.max(this.y1(), c.y1()), Math.min(this.x2(), c.x2()), Math.min(this.y2(), c.y2()));
    }

    @Nonnull
    public Area translate(float x, float y) {
        return Area.size(this.x1() + x, this.y1() + y, this.w(), this.h());
    }

    @Nonnull
    public Area scale(float scale) {
        return Area.abs(this.x1() * scale, this.y1() * scale, this.x2() * scale, this.y2() * scale);
    }

    @Nonnull
    public Area scaleSize(float scale) {
        return Area.size(this.x1(), this.y1(), this.w() * scale, this.h() * scale);
    }

    @Nonnull
    public Area scale(float scaleX, float scaleY) {
        return Area.abs(this.x1() * scaleX, this.y1() * scaleY, this.x2() * scaleX, this.y2() * scaleY);
    }

    @Nonnull
    public Area scaleSize(float scaleX, float scaleY) {
        return Area.size(this.x1(), this.y1(), this.w() * scaleX, this.h() * scaleY);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x1);
        result = 31 * result + Float.floatToIntBits(this.x2);
        result = 31 * result + Float.floatToIntBits(this.y1);
        result = 31 * result + Float.floatToIntBits(this.y2);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Area)) {
            return false;
        }
        Area other = (Area)obj;
        if (Float.floatToIntBits(this.x1) != Float.floatToIntBits(other.x1)) {
            return false;
        }
        if (Float.floatToIntBits(this.x2) != Float.floatToIntBits(other.x2)) {
            return false;
        }
        if (Float.floatToIntBits(this.y1) != Float.floatToIntBits(other.y1)) {
            return false;
        }
        return Float.floatToIntBits(this.y2) == Float.floatToIntBits(other.y2);
    }

    @Nonnull
    public String toString() {
        return String.format("Area [x1=%s, y1=%s, x2=%s, y2=%s]", Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2));
    }
}

