/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.position;

import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.var.V;
import com.kamesuta.mc.bnnwidget.var.VCommon;
import javax.annotation.Nonnull;

public class Coord {
    @Nonnull
    private VCommon coord;
    @Nonnull
    private CoordSide side;

    public Coord(@Nonnull VCommon coord, @Nonnull CoordSide side) {
        this.coord = coord;
        this.side = side;
    }

    public float get() {
        return this.coord.get();
    }

    public float getAbsCoord(float abslength) {
        return this.coord.getAbsCoord(0.0f, abslength);
    }

    @Nonnull
    public String toString() {
        return String.format("Coord [coord=%s, side=%s]", new Object[]{Float.valueOf(this.get()), this.getSide()});
    }

    public float base(@Nonnull Area a) {
        return this.getSide().base(a, this);
    }

    public float next(@Nonnull Area a, @Nonnull Coord base) {
        return this.getSide().next(a, base, this);
    }

    @Nonnull
    public CoordSide getSide() {
        return this.side;
    }

    @Nonnull
    public static Coord top(@Nonnull VCommon n) {
        return new Coord(n, CoordSide.Top);
    }

    @Nonnull
    public static Coord top(float n) {
        return Coord.top(V.a(n));
    }

    @Nonnull
    public static Coord ptop(float n) {
        return Coord.top(V.p(n));
    }

    @Nonnull
    public static Coord left(@Nonnull VCommon n) {
        return new Coord(n, CoordSide.Left);
    }

    @Nonnull
    public static Coord left(float n) {
        return Coord.left(V.a(n));
    }

    @Nonnull
    public static Coord pleft(float n) {
        return Coord.left(V.p(n));
    }

    @Nonnull
    public static Coord bottom(@Nonnull VCommon n) {
        return new Coord(n, CoordSide.Bottom);
    }

    @Nonnull
    public static Coord bottom(float n) {
        return Coord.bottom(V.a(n));
    }

    @Nonnull
    public static Coord pbottom(float n) {
        return Coord.bottom(V.p(n));
    }

    @Nonnull
    public static Coord right(@Nonnull VCommon n) {
        return new Coord(n, CoordSide.Right);
    }

    @Nonnull
    public static Coord right(float n) {
        return Coord.right(V.a(n));
    }

    @Nonnull
    public static Coord pright(float n) {
        return Coord.right(V.p(n));
    }

    @Nonnull
    public static Coord width(@Nonnull VCommon n) {
        return new Coord(n, CoordSide.Width);
    }

    @Nonnull
    public static Coord width(float n) {
        return Coord.width(V.a(n));
    }

    @Nonnull
    public static Coord pwidth(float n) {
        return Coord.width(V.p(n));
    }

    @Nonnull
    public static Coord height(@Nonnull VCommon n) {
        return new Coord(n, CoordSide.Height);
    }

    @Nonnull
    public static Coord height(float n) {
        return Coord.height(V.a(n));
    }

    @Nonnull
    public static Coord pheight(float n) {
        return Coord.height(V.p(n));
    }

    public static enum CoordSide {
        Top(true, 1){

            @Override
            public float base(@Nonnull Area a, @Nonnull Coord c) {
                return a.y1() + c.getAbsCoord(a.h());
            }

            @Override
            public float next(@Nonnull Area a, @Nonnull Coord base, @Nonnull Coord c) {
                if (c.getSide().isAbs) {
                    return a.y1() + c.getAbsCoord(a.h());
                }
                return base.base(a) + (float)base.getSide().calc * c.getAbsCoord(a.h());
            }
        }
        ,
        Left(true, 1){

            @Override
            public float base(@Nonnull Area a, @Nonnull Coord c) {
                return a.x1() + c.getAbsCoord(a.w());
            }

            @Override
            public float next(@Nonnull Area a, @Nonnull Coord base, @Nonnull Coord c) {
                if (c.getSide().isAbs) {
                    return a.x1() + c.getAbsCoord(a.w());
                }
                return base.base(a) + (float)base.getSide().calc * c.getAbsCoord(a.w());
            }
        }
        ,
        Bottom(true, -1){

            @Override
            public float base(@Nonnull Area a, @Nonnull Coord c) {
                return a.y2() - c.getAbsCoord(a.h());
            }

            @Override
            public float next(@Nonnull Area a, @Nonnull Coord base, @Nonnull Coord c) {
                if (c.getSide().isAbs) {
                    return a.y2() - c.getAbsCoord(a.h());
                }
                return base.base(a) + (float)base.getSide().calc * c.getAbsCoord(a.h());
            }
        }
        ,
        Right(true, -1){

            @Override
            public float base(@Nonnull Area a, @Nonnull Coord c) {
                return a.x2() - c.getAbsCoord(a.w());
            }

            @Override
            public float next(@Nonnull Area a, @Nonnull Coord base, @Nonnull Coord c) {
                if (c.getSide().isAbs) {
                    return a.x2() - c.getAbsCoord(a.w());
                }
                return base.base(a) + (float)base.getSide().calc * c.getAbsCoord(a.w());
            }
        }
        ,
        Width(false, 1){

            @Override
            public float next(@Nonnull Area a, @Nonnull Coord base, @Nonnull Coord c) {
                return base.getSide().next(a, base, c);
            }
        }
        ,
        Height(false, 1){

            @Override
            public float next(@Nonnull Area a, @Nonnull Coord base, @Nonnull Coord c) {
                return base.getSide().next(a, base, c);
            }
        };

        public final boolean isAbs;
        private final int calc;

        public float base(@Nonnull Area a, @Nonnull Coord c) {
            return 0.0f;
        }

        public float next(@Nonnull Area a, @Nonnull Coord base, @Nonnull Coord c) {
            return 0.0f;
        }

        private CoordSide(boolean isAbs, int calc) {
            this.isAbs = isAbs;
            this.calc = calc;
        }
    }
}

