/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.position;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Point
implements Serializable {
    protected float x;
    protected float y;
    private static final long serialVersionUID = -5276940640259749850L;

    public Point() {
        this(0.0f, 0.0f);
    }

    public Point(@Nonnull Point p) {
        this(p.x, p.y);
    }

    public Point(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float d2(@Nonnull Point p) {
        float dx = this.x() - p.x();
        float dy = this.y() - p.y();
        return dx * dx + dy * dy;
    }

    public float d(@Nonnull Point p) {
        return (float)Math.sqrt(this.d2(p));
    }

    @Nonnull
    public String toString() {
        return String.format("Point[x=%s, y=%s]", Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        Point other = (Point)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }
}

