/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.position;

import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.position.Coord;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class R {
    @Nonnull
    private static final Coord default_x1 = Coord.left(0.0f);
    @Nonnull
    private static final Coord default_y1 = Coord.top(0.0f);
    @Nonnull
    private static final Coord default_x2 = Coord.pwidth(1.0f);
    @Nonnull
    private static final Coord default_y2 = Coord.pheight(1.0f);
    @Nullable
    protected R parent;
    @Nullable
    protected Coord x1 = default_x1;
    @Nullable
    protected Coord y1 = default_y1;
    @Nullable
    protected Coord x2 = default_x2;
    @Nullable
    protected Coord y2 = default_y2;

    public R(Coord ... a) throws IllegalStateException {
        for (Coord c : a) {
            if (c == null) continue;
            this.set(c);
        }
    }

    public R(@Nonnull R parent, Coord ... a) throws IllegalStateException {
        this(a);
        this.setParent(parent);
    }

    public R(@Nonnull R a) {
        this.set(a);
    }

    public R(@Nonnull R parent, @Nonnull R a) {
        this(a);
        this.setParent(parent);
    }

    @Deprecated
    @Nonnull
    public static R diff(float diff_x1, float diff_y1, float diff_x2, float diff_y2) {
        return new R(Coord.left(diff_x1), Coord.top(diff_y1), Coord.right(-diff_x2), Coord.bottom(-diff_y2));
    }

    @Nonnull
    public Area getAbsolute(@Nonnull Area a) {
        Coord x1 = this.x1;
        Coord y1 = this.y1;
        Coord x2 = this.x2;
        Coord y2 = this.y2;
        if (x1 != null && y1 != null && x2 != null && y2 != null) {
            if (this.parent != null) {
                a = this.parent.getAbsolute(a);
            }
            float tx1 = x1.base(a);
            float ty1 = y1.base(a);
            float tx2 = x2.next(a, x1);
            float ty2 = y2.next(a, y1);
            float rx1 = Math.min(tx1, tx2);
            float ry1 = Math.min(ty1, ty2);
            float rx2 = Math.max(tx1, tx2);
            float ry2 = Math.max(ty1, ty2);
            return new Area(rx1, ry1, rx2, ry2);
        }
        throw new IllegalStateException("attempt to get absolute from uncompleted relative");
    }

    protected void setParent(@Nonnull R parent) {
        this.parent = parent;
    }

    protected void set(@Nonnull R a) {
        this.x1 = a.x1;
        this.y1 = a.y1;
        this.x2 = a.x2;
        this.y2 = a.y2;
    }

    protected void set(@Nonnull Coord n) throws IllegalStateException {
        Validate.notNull((Object)n, (String)String.format("null coord [%s]", this), (Object[])new Object[0]);
        Validate.notNull((Object)((Object)n.getSide()), (String)String.format("invaild coord [%s]", this), (Object[])new Object[0]);
        switch (n.getSide()) {
            case Left: 
            case Right: {
                if (this.x1 == default_x1) {
                    this.x1 = n;
                    break;
                }
            }
            case Width: {
                if (this.x2 == default_x2) {
                    this.x2 = n;
                    break;
                }
            }
            case Top: 
            case Bottom: {
                if (this.y1 == default_y1) {
                    this.y1 = n;
                    break;
                }
            }
            case Height: {
                if (this.y2 == default_y2) {
                    this.y2 = n;
                    break;
                }
                throw new IllegalStateException(String.format("conflic coord [%s]", this));
            }
        }
    }

    @Nonnull
    public R child(Coord ... a) {
        return new R(this, a);
    }

    @Nonnull
    public R child(@Nonnull R a) {
        return new R(this, a);
    }

    @Nonnull
    public String toString() {
        return String.format("RArea[parent=%s, x1=%s, y1=%s, x2=%s, y2=%s]", this.parent, this.x1, this.y1, this.x2, this.y2);
    }
}

