/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.render;

import com.kamesuta.mc.bnnwidget.position.Area;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class WGui
extends WRenderer {
    public static final float textureScale = 0.00390625f;
    @Nonnull
    public static final Area defaultTextureArea = Area.abs(0.0f, 0.0f, 1.0f, 1.0f);
    @Nullable
    private static final Cursor cur;

    public static void setCursorVisible(boolean b) {
        if (cur != null) {
            try {
                Mouse.setNativeCursor((Cursor)(b ? null : cur));
            }
            catch (LWJGLException lWJGLException) {
                // empty catch block
            }
        }
    }

    public static void showCursor() {
        WGui.setCursorVisible(true);
    }

    public static void hideCursor() {
        WGui.setCursorVisible(false);
    }

    private static void drawTextureAbs(float vx1, float vy1, float vx2, float vy2, float tx1, float ty1, float tx2, float ty2) {
        WGui.beginTextureQuads().pos(vx1, vy2, 0.0).tex(tx1, ty2).pos(vx2, vy2, 0.0).tex(tx2, ty2).pos(vx2, vy1, 0.0).tex(tx2, ty1).pos(vx1, vy1, 0.0).tex(tx1, ty1).draw();
    }

    private static void drawTextureAbsTrim(float vx1, float vy1, float vx2, float vy2, float rx1, float ry1, float rx2, float ry2, float tx1, float ty1, float tx2, float ty2) {
        float ox1 = tx2 - tx1;
        float oy1 = ty2 - ty1;
        float ox2 = vx2 - vx1;
        float oy2 = vy2 - vy1;
        float ox3 = ox2 / ox1;
        float oy3 = oy2 / oy1;
        float ox4 = (rx1 - vx1) / ox3;
        float oy4 = (ry1 - vy1) / oy3;
        float ox5 = (rx2 - vx1) / ox3;
        float oy5 = (ry2 - vy1) / oy3;
        float ox6 = (rx2 - rx1) / ox3;
        float oy6 = (ry2 - ry1) / oy3;
        float ox7 = ox2 / ox1 * ox6;
        float oy7 = oy2 / oy1 * oy6;
        WGui.beginTextureQuads().pos(rx1, ry1 + oy7, 0.0).tex(ox4 + tx1, oy5 + ty1).pos(rx1 + ox7, ry1 + oy7, 0.0).tex(ox5 + tx1, oy5 + ty1).pos(rx1 + ox7, ry1, 0.0).tex(ox5 + tx1, oy4 + ty1).pos(rx1, ry1, 0.0).tex(ox4 + tx1, oy4 + ty1).draw();
    }

    @Deprecated
    private static void drawTextureAbsTrimOne(float vx1, float vy1, float vx2, float vy2, float rx1, float ry1, float rx2, float ry2, float tx1, float ty1, float tx2, float ty2) {
        WGui.drawTextureAbsTrim(vx1, vy1, vx2, vy2, Math.max(vx1, rx1), Math.max(vy1, ry1), Math.min(vx2, rx2), Math.min(vy2, ry2), tx1, ty1, tx2, ty2);
    }

    public static void drawTexture(@Nullable Area vertex, @Nullable Area trim, @Nullable Area texture) {
        Area t;
        Area v = vertex != null ? vertex : defaultTextureArea;
        Area area = t = texture != null ? texture : defaultTextureArea;
        if (trim != null) {
            if ((trim = v.trimArea(trim)) != null) {
                WGui.drawTextureAbsTrim(v.x1(), v.y1(), v.x2(), v.y2(), trim.x1(), trim.y1(), trim.x2(), trim.y2(), t.x1(), t.y1(), t.x2(), t.y2());
            }
        } else {
            WGui.drawTextureAbs(v.x1(), v.y1(), v.x2(), v.y2(), t.x1(), t.y1(), t.x2(), t.y2());
        }
    }

    public static void drawTextureModal(@Nullable Area vertex, @Nullable Area trim, @Nullable Area texture) {
        WGui.drawTexture(vertex, trim, (texture != null ? texture : defaultTextureArea).scale(0.00390625f));
    }

    private static void drawAbs(float x1, float y1, float x2, float y2, int mode) {
        WGui.begin(mode).pos(x1, y2, 0.0).pos(x2, y2, 0.0).pos(x2, y1, 0.0).pos(x1, y1, 0.0).draw();
    }

    public static void draw(@Nullable Area vertex, int mode) {
        Area v = vertex != null ? vertex : defaultTextureArea;
        WGui.drawAbs(v.x1(), v.y1(), v.x2(), v.y2(), mode);
    }

    public static void draw(@Nullable Area vertex) {
        WGui.draw(vertex, 7);
    }

    public static void drawString(@Nonnull String text, float x, float y, float w, float h, @Nonnull Align align, @Nonnull VerticalAlign valign, boolean shadow) {
        OpenGL.glPushMatrix();
        align.translate(text, x, w);
        valign.translate(text, y, h);
        buf.clear();
        GL11.glGetFloat((int)2816, (FloatBuffer)buf);
        float r = buf.get(0);
        float g = buf.get(1);
        float b = buf.get(2);
        float a = buf.get(3);
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        WGui.font().func_175065_a(text, 0.0f, 0.0f, Math.max((int)((double)(a * 255.0f) + 0.5) & 0xFF, 4) << 24 | ((int)((double)(r * 255.0f) + 0.5) & 0xFF) << 16 | ((int)((double)(g * 255.0f) + 0.5) & 0xFF) << 8 | ((int)((double)(b * 255.0f) + 0.5) & 0xFF) << 0, shadow);
        OpenGL.glColor4f(r, g, b, a);
        OpenGL.glPopMatrix();
    }

    public static void drawString(@Nonnull String text, @Nonnull Area a, @Nonnull Align align, @Nonnull VerticalAlign valign, boolean shadow) {
        WGui.drawString(text, a.x1(), a.y1(), a.w(), a.h(), align, valign, shadow);
    }

    public static int getStringWidth(@Nonnull String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return 0;
        }
        return WGui.font().func_78256_a(TextFormatting.func_110646_a((String)s));
    }

    static {
        Cursor cursor = null;
        try {
            IntBuffer buf = GLAllocation.func_74527_f((int)1);
            buf.put(0);
            buf.flip();
            cursor = new Cursor(1, 1, 0, 0, 1, buf, null);
        }
        catch (LWJGLException lWJGLException) {
            // empty catch block
        }
        cur = cursor;
    }

    public static enum VerticalAlign {
        TOP{

            @Override
            protected void translate(@Nonnull String text, float y, float h) {
                OpenGL.glTranslatef(0.0f, y, 0.0f);
            }
        }
        ,
        MIDDLE{

            @Override
            protected void translate(@Nonnull String text, float y, float h) {
                OpenGL.glTranslatef(0.0f, y + (h - (float)WRenderer.font().field_78288_b) / 2.0f, 0.0f);
            }
        }
        ,
        BOTTOM{

            @Override
            protected void translate(@Nonnull String text, float y, float h) {
                OpenGL.glTranslatef(0.0f, y + h - (float)WRenderer.font().field_78288_b, 0.0f);
            }
        };


        protected abstract void translate(@Nonnull String var1, float var2, float var3);
    }

    public static enum Align {
        LEFT{

            @Override
            protected void translate(@Nonnull String text, float x, float w) {
                OpenGL.glTranslatef(x, 0.0f, 0.0f);
            }
        }
        ,
        CENTER{

            @Override
            protected void translate(@Nonnull String text, float x, float w) {
                OpenGL.glTranslatef(x + (w - (float)WGui.getStringWidth(text)) / 2.0f, 0.0f, 0.0f);
            }
        }
        ,
        RIGHT{

            @Override
            protected void translate(@Nonnull String text, float x, float w) {
                OpenGL.glTranslatef(x - (float)WGui.getStringWidth(text), 0.0f, 0.0f);
            }
        };


        protected abstract void translate(@Nonnull String var1, float var2, float var3);
    }
}

