/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.bnnwidget.render;

import com.google.common.collect.ImmutableMap;
import com.kamesuta.mc.bnnwidget.render.OpenGL;
import java.nio.FloatBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.FMLClientHandler;

public class WRenderer
extends Gui {
    @Nonnull
    public static final Minecraft mc = FMLClientHandler.instance().getClient();
    @Nonnull
    public static final Tessellator t = Tessellator.func_178181_a();
    @Nonnull
    public static final BufferBuilder w = t.func_178180_c();
    @Nonnull
    public static final WVertex vertex = new WVertex();
    public static FloatBuffer buf = GLAllocation.func_74529_h((int)16);

    @Nonnull
    public static TextureManager texture() {
        return WRenderer.mc.field_71446_o;
    }

    @Nonnull
    public static FontRenderer font() {
        return WRenderer.mc.field_71466_p;
    }

    @Nonnull
    public static WVertex begin(int mode) {
        return vertex.begin(mode);
    }

    @Nonnull
    public static WVertex beginQuads() {
        return vertex.begin(7);
    }

    @Nonnull
    public static WVertex beginTexture(int mode) {
        return vertex.beginTexture(mode);
    }

    @Nonnull
    public static WVertex beginTextureQuads() {
        return vertex.beginTexture(7);
    }

    public int toFontColor(int color) {
        int alpha = Math.max(color >> 24 & 0xFF, 4) << 24;
        return color & 0xFFFFFF | alpha;
    }

    public static int toColorCode(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static int toColorCode(float r, float g, float b, float a) {
        return WRenderer.toColorCode((int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f), (int)(a * 255.0f + 0.5f));
    }

    public static void startShape(@Nullable BlendType src, @Nullable BlendType dest) {
        OpenGL.glBlendFunc(src != null ? src.glEnum : 770, dest != null ? dest.glEnum : 771);
        OpenGL.glDisable(2896);
        OpenGL.glEnable(3042);
        OpenGL.glDisable(3553);
    }

    public static void startShape() {
        WRenderer.startShape(null, null);
    }

    public static void startTexture(@Nullable BlendType src, @Nullable BlendType dest) {
        OpenGL.glBlendFunc(src != null ? src.glEnum : 770, dest != null ? dest.glEnum : 771);
        OpenGL.glDisable(2896);
        OpenGL.glEnable(3042);
        OpenGL.glEnable(3553);
    }

    public static void startTexture() {
        WRenderer.startTexture(null, null);
    }

    public static enum BlendType {
        ZERO(0, 0),
        ONE(1, 1),
        SRC_COLOR(2, 768),
        ONE_MINUS_SRC_COLOR(3, 769),
        DST_COLOR(4, 774),
        ONE_MINUS_DST_COLOR(5, 775),
        SRC_ALPHA(6, 770),
        ONE_MINUS_SRC_ALPHA(7, 771),
        DST_ALPHA(8, 772),
        ONE_MINUS_DST_ALPHA(9, 773),
        SRC_ALPHA_SATURATE(10, 776),
        CONSTANT_COLOR(11, 32769),
        ONE_MINUS_CONSTANT_COLOR(12, 32770),
        CONSTANT_ALPHA(13, 32771),
        ONE_MINUS_CONSTANT_ALPHA(14, 32772);

        public final int id;
        public final int glEnum;
        @Nonnull
        private static final ImmutableMap<Integer, BlendType> blendIds;

        private BlendType(int id, int glEnum) {
            this.id = id;
            this.glEnum = glEnum;
        }

        @Nullable
        public static BlendType fromId(int id) {
            return (BlendType)((Object)blendIds.get((Object)id));
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BlendType blend : BlendType.values()) {
                builder.put((Object)blend.id, (Object)blend);
            }
            blendIds = builder.build();
        }
    }

    public static class WVertex {
        private boolean stack;

        private WVertex() {
        }

        public void draw() {
            this.endVertex();
            t.func_78381_a();
        }

        @Nonnull
        public WVertex begin(int mode) {
            w.func_181668_a(mode, DefaultVertexFormats.field_181705_e);
            this.init();
            return this;
        }

        @Nonnull
        public WVertex beginTexture(int mode) {
            w.func_181668_a(mode, DefaultVertexFormats.field_181707_g);
            this.init();
            return this;
        }

        private void init() {
            this.stack = false;
        }

        @Nonnull
        public WVertex pos(double x, double y, double z) {
            this.endVertex();
            w.func_181662_b(x, y, z);
            this.stack = true;
            return this;
        }

        @Nonnull
        public WVertex tex(double u, double v) {
            w.func_187315_a(u, v);
            return this;
        }

        @Nonnull
        public WVertex color(float red, float green, float blue, float alpha) {
            return this.color((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
        }

        @Nonnull
        public WVertex color(int red, int green, int blue, int alpha) {
            w.putColorRGBA(0, red, green, blue, alpha);
            return this;
        }

        @Nonnull
        public WVertex normal(float nx, float ny, float nz) {
            w.func_181663_c(nx, ny, nz);
            return this;
        }

        public void setTranslation(double x, double y, double z) {
            w.func_178969_c(x, y, z);
        }

        private void endVertex() {
            if (this.stack) {
                this.stack = false;
                w.func_181675_d();
            }
        }
    }
}

