/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.http.shortening.BitlyShortener;
import com.kamesuta.mc.signpic.http.shortening.GooglShortener;
import com.kamesuta.mc.signpic.http.shortening.IShortener;
import com.kamesuta.mc.signpic.http.shortening.ShorteningRequest;
import com.kamesuta.mc.signpic.http.upload.GyazoUpload;
import com.kamesuta.mc.signpic.http.upload.IUploader;
import com.kamesuta.mc.signpic.http.upload.ImgurUpload;
import com.kamesuta.mc.signpic.http.upload.UploadRequest;
import com.kamesuta.mc.signpic.information.Info;
import com.kamesuta.mc.signpic.information.Informations;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class Apis {
    @Nonnull
    public static final Apis instance = new Apis();
    @Nonnull
    public final Set<URLReplacer> urlReplacers = Sets.newHashSet();
    @Nonnull
    private static final Random rnd = new Random();
    @Nonnull
    public final MapSetting<ImageUploaderFactory> imageUploaders = new MapSetting<ImageUploaderFactory>(){

        @Override
        @Nonnull
        public String getConfig() {
            return Config.getConfig().apiUploaderType.get();
        }

        @Override
        public void setConfig(String setting) {
            Config.getConfig().apiUploaderType.set(setting);
            Config.getConfig().apiUploaderKey.set("");
        }
    };
    @Nonnull
    public final MapSetting<URLShortenerFactory> urlShorteners = new MapSetting<URLShortenerFactory>(){

        @Override
        @Nonnull
        public String getConfig() {
            return Config.getConfig().apiShortenerType.get();
        }

        @Override
        public void setConfig(@Nonnull String setting) {
            Config.getConfig().apiShortenerType.set(setting);
            Config.getConfig().apiShortenerKey.set("");
        }
    };

    private Apis() {
    }

    public void registerURLReplacer(@Nonnull URLReplacer replacer) {
        this.urlReplacers.add(replacer);
    }

    @Nonnull
    public String replaceURL(@Nonnull String src) {
        String url = src;
        for (URLReplacer replacer : this.urlReplacers) {
            url = replacer.replace(url);
        }
        return url;
    }

    public void registerImageUploader(@Nonnull String name, @Nonnull ImageUploaderFactory uploader) {
        this.imageUploaders.registerSetting(name, uploader);
    }

    public void registerURLShortener(@Nonnull String name, @Nonnull URLShortenerFactory shortener) {
        this.urlShorteners.registerSetting(name, shortener);
    }

    public void init() {
        this.registerImageUploader("Gyazo", new ImageUploaderFactory(){

            @Override
            @Nonnull
            public Set<String> keys() {
                List<Info.Api.Image.Gyazo.Config> configs;
                Info.Api.Image.Gyazo gyazo;
                Info.Api.Image image;
                Info.Api api;
                HashSet keys = Sets.newHashSet();
                Informations.InfoSource source = Informations.instance.getSource();
                if (source != null && (api = source.info.apis) != null && (image = api.image) != null && (gyazo = image.gyazo) != null && (configs = gyazo.config) != null) {
                    for (Info.Api.Image.Gyazo.Config config : configs) {
                        if (config == null) continue;
                        keys.add(config.key);
                    }
                }
                return keys;
            }

            @Override
            @Nonnull
            public IUploader create(UploadRequest upload, String key) throws IOException {
                return new GyazoUpload(upload, key);
            }

            @Override
            @Nonnull
            public KeySetting keySettings() {
                return new UploaderKeySetting(this.keys());
            }
        });
        this.registerImageUploader("Imgur", new ImageUploaderFactory(){

            @Override
            @Nonnull
            public Set<String> keys() {
                List<Info.Api.Image.Imgur.Config> configs;
                Info.Api.Image.Imgur imgur;
                Info.Api.Image image;
                Info.Api api;
                HashSet keys = Sets.newHashSet();
                Informations.InfoSource source = Informations.instance.getSource();
                if (source != null && (api = source.info.apis) != null && (image = api.image) != null && (imgur = image.imgur) != null && (configs = imgur.config) != null) {
                    for (Info.Api.Image.Imgur.Config config : configs) {
                        if (config == null) continue;
                        keys.add(config.clientid);
                    }
                }
                return keys;
            }

            @Override
            @Nonnull
            public IUploader create(@Nonnull UploadRequest upload, @Nonnull String key) throws IOException {
                return new ImgurUpload(upload, key);
            }

            @Override
            @Nonnull
            public KeySetting keySettings() {
                return new UploaderKeySetting(this.keys());
            }
        });
        this.registerURLShortener("Bitly", new URLShortenerFactory(){

            @Override
            @Nonnull
            public Set<String> keys() {
                List<Info.Api.Shortener.Bitly.Config> configs;
                Info.Api.Shortener.Bitly bitly;
                Info.Api.Shortener shortener;
                Info.Api api;
                HashSet keys = Sets.newHashSet();
                Informations.InfoSource source = Informations.instance.getSource();
                if (source != null && (api = source.info.apis) != null && (shortener = api.shortener) != null && (bitly = shortener.bitly) != null && (configs = bitly.config) != null) {
                    for (Info.Api.Shortener.Bitly.Config config : configs) {
                        if (config == null) continue;
                        keys.add(config.key);
                    }
                }
                return keys;
            }

            @Override
            @Nonnull
            public IShortener create(@Nonnull ShorteningRequest upload, @Nonnull String key) throws IOException {
                return new BitlyShortener(upload, key);
            }

            @Override
            @Nonnull
            public KeySetting keySettings() {
                return new ShorteningKeySetting(this.keys());
            }
        });
        this.registerURLShortener("Googl", new URLShortenerFactory(){

            @Override
            @Nonnull
            public Set<String> keys() {
                List<Info.Api.Shortener.Googl.Config> configs;
                Info.Api.Shortener.Googl googl;
                Info.Api.Shortener shortener;
                Info.Api api;
                HashSet keys = Sets.newHashSet();
                Informations.InfoSource source = Informations.instance.getSource();
                if (source != null && (api = source.info.apis) != null && (shortener = api.shortener) != null && (googl = shortener.googl) != null && (configs = googl.config) != null) {
                    for (Info.Api.Shortener.Googl.Config config : configs) {
                        if (config == null) continue;
                        keys.add(config.key);
                    }
                }
                return keys;
            }

            @Override
            @Nonnull
            public IShortener create(@Nonnull ShorteningRequest upload, @Nonnull String key) throws IOException {
                return new GooglShortener(upload, key);
            }

            @Override
            @Nonnull
            public KeySetting keySettings() {
                return new ShorteningKeySetting(this.keys());
            }
        });
        final Pattern p = Pattern.compile("[^\\w]");
        this.registerURLReplacer(new URLReplacer(){

            @Override
            @Nonnull
            public String replace(@Nonnull String src) {
                if (StringUtils.containsIgnoreCase((CharSequence)src, (CharSequence)"gyazo.com")) {
                    String path;
                    Matcher m;
                    if (!StringUtils.containsIgnoreCase((CharSequence)src, (CharSequence)"i.gyazo.com")) {
                        src = StringUtils.replace((String)src, (String)"gyazo.com", (String)"i.gyazo.com");
                    }
                    if ((m = p.matcher(path = StringUtils.substringAfter((String)src, (String)"gyazo.com/"))).find()) {
                        String querystring = StringUtils.substring((String)path, (int)0, (int)m.start());
                        int i = StringUtils.indexOf((CharSequence)path, (CharSequence)".");
                        if (i < 0 || i > StringUtils.length((CharSequence)querystring)) {
                            String pre = StringUtils.substringBefore((String)src, (String)"gyazo.com/");
                            src = pre + "gyazo.com/" + querystring + ".png";
                        }
                    } else {
                        src = src + ".png";
                    }
                }
                return src;
            }
        });
        this.registerURLReplacer(new URLReplacer(){

            @Override
            @Nonnull
            public String replace(@Nonnull String src) {
                if (StringUtils.containsIgnoreCase((CharSequence)src, (CharSequence)"imgur.com")) {
                    String path;
                    Matcher m;
                    if (!StringUtils.containsIgnoreCase((CharSequence)src, (CharSequence)"i.imgur.com")) {
                        src = StringUtils.replace((String)src, (String)"imgur.com", (String)"i.imgur.com");
                    }
                    if ((m = p.matcher(path = StringUtils.substringAfter((String)src, (String)"imgur.com/"))).find()) {
                        String querystring = StringUtils.substring((String)path, (int)0, (int)m.start());
                        int i = StringUtils.indexOf((CharSequence)path, (CharSequence)".");
                        if (i < 0 || i > StringUtils.length((CharSequence)querystring)) {
                            String pre = StringUtils.substringBefore((String)src, (String)"imgur.com/");
                            src = pre + "imgur.com/" + querystring + ".png";
                        }
                    } else {
                        src = src + ".png";
                    }
                }
                return src;
            }
        });
    }

    public static interface URLShortenerFactory
    extends ApiFactory {
        public IShortener create(@Nonnull ShorteningRequest var1, @Nonnull String var2) throws IOException;
    }

    public static interface ImageUploaderFactory
    extends ApiFactory {
        public IUploader create(@Nonnull UploadRequest var1, @Nonnull String var2) throws IOException;
    }

    public static interface ApiFactory {
        @Nonnull
        public Set<String> keys();

        @Nonnull
        public KeySetting keySettings();
    }

    public static abstract class MapSetting<E>
    extends Setting {
        @Nonnull
        private final Map<String, E> settingmap = Maps.newHashMap();

        public void registerSetting(@Nonnull String name, @Nonnull E uploader) {
            this.registerSetting(name);
            this.getSettingMap().put(name, uploader);
        }

        @Nonnull
        public Map<String, E> getSettingMap() {
            return this.settingmap;
        }

        @Nullable
        public E solve(@Nullable String name) {
            return this.getSettingMap().get(name);
        }
    }

    public static abstract class Setting {
        @Nonnull
        private final Set<String> settings = Sets.newHashSet();

        public void registerSetting(@Nonnull String name) {
            this.getSettings().add(name);
        }

        @Nonnull
        public Set<String> getSettings() {
            return this.settings;
        }

        @Nullable
        public String getRandom() {
            int size = this.getSettings().size();
            if (size > 0) {
                int item = rnd.nextInt(size);
                int i = 0;
                for (String k : this.getSettings()) {
                    if (i == item) {
                        return k;
                    }
                    ++i;
                }
            }
            return null;
        }

        @Nullable
        public String getConfigOrRandom() {
            String cfg = this.getConfig();
            if (StringUtils.isEmpty((CharSequence)cfg)) {
                cfg = this.getRandom();
            }
            return cfg;
        }

        @Nonnull
        public abstract String getConfig();

        public abstract void setConfig(@Nonnull String var1);
    }

    public static class ShorteningKeySetting
    extends KeySetting {
        public ShorteningKeySetting(@Nonnull Set<String> keys) {
            super(keys);
        }

        @Override
        @Nonnull
        public String getConfig() {
            return Config.getConfig().apiShortenerKey.get();
        }

        @Override
        public void setConfig(@Nonnull String setting) {
            Config.getConfig().apiShortenerKey.set(setting);
        }
    }

    public static class UploaderKeySetting
    extends KeySetting {
        public UploaderKeySetting(@Nonnull Set<String> keys) {
            super(keys);
        }

        @Override
        @Nonnull
        public String getConfig() {
            return Config.getConfig().apiUploaderKey.get();
        }

        @Override
        public void setConfig(@Nonnull String setting) {
            Config.getConfig().apiUploaderKey.set(setting);
        }
    }

    public static abstract class KeySetting
    extends Setting {
        public KeySetting(@Nonnull Set<String> keys) {
            for (String key : keys) {
                if (key == null) continue;
                this.registerSetting(key);
            }
        }
    }

    public static interface URLReplacer {
        @Nonnull
        public String replace(@Nonnull String var1);
    }
}

