/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.kamesuta.mc.signpic.CoreHandler;
import com.kamesuta.mc.signpic.Locations;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.command.CommandImage;
import com.kamesuta.mc.signpic.command.CommandVersion;
import com.kamesuta.mc.signpic.command.RootCommand;
import com.kamesuta.mc.signpic.gui.GuiMain;
import com.kamesuta.mc.signpic.render.CustomTileEntitySignRenderer;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JOptionPane;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Client {
    @Nonnull
    public static final Minecraft mc = FMLClientHandler.instance().getClient();
    @Nonnull
    public static final Gson gson = new Gson();
    @Nonnull
    public static CustomTileEntitySignRenderer renderer = new CustomTileEntitySignRenderer();
    @Nonnull
    public static CoreHandler handler = new CoreHandler();
    @Nullable
    private static Locations location;
    @Nonnull
    public static String mcversion;
    @Nonnull
    public static String forgeversion;
    @Nullable
    public static String id;
    @Nullable
    public static String name;
    @Nullable
    public static String token;
    @Nullable
    public static RootCommand rootCommand;
    public static final Set<String> schemes;

    @Nonnull
    public static Locations getLocation() {
        if (location != null) {
            return location;
        }
        throw new IllegalStateException("signpic location not initialized");
    }

    public static void initLocation(@Nonnull Locations locations) {
        location = locations;
    }

    public static void openEditor() {
        mc.func_147108_a((GuiScreen)new GuiMain(Client.mc.field_71462_r));
    }

    public static void startSection(@Nonnull String sec) {
        Client.mc.field_71424_I.func_76320_a(sec);
    }

    public static void endSection() {
        Client.mc.field_71424_I.func_76319_b();
    }

    @Nullable
    public static TileEntitySign getTileSignLooking() {
        TileEntity tile;
        if (MovePos.getBlock() instanceof BlockSign && (tile = MovePos.getTile()) instanceof TileEntitySign) {
            return (TileEntitySign)tile;
        }
        return null;
    }

    public static void playSound(@Nonnull ResourceLocation location, float volume) {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)new SoundEvent(location), (float)volume));
    }

    public static boolean openURL(@Nonnull String uri) {
        try {
            return Client.openURL(new URI(uri));
        }
        catch (Throwable e) {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.openurlfailed", (Object[])new Object[]{e}));
            Log.log.warn("Failed to open URL", e);
            return false;
        }
    }

    public static boolean openURL(@Nonnull URI uri) {
        try {
            String scheme = StringUtils.lowerCase((String)uri.getScheme());
            if (!schemes.contains(scheme)) {
                throw new URISyntaxException(uri.toString(), "Unsupported protocol: " + scheme);
            }
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(uri);
        }
        catch (URISyntaxException e) {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.openurlfailed.invalid", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.openurlfailed", (Object[])new Object[]{e}));
            Log.log.warn("Failed to open URL", e);
        }
        return false;
    }

    public static void deleteMod(@Nonnull File mod) {
        if (mod.delete()) {
            return;
        }
        try {
            LaunchClassLoader lloader = (LaunchClassLoader)Client.class.getClassLoader();
            URL url = mod.toURI().toURL();
            Field f_ucp = URLClassLoader.class.getDeclaredField("ucp");
            Class<?> sunURLClassPath = Class.forName("sun.misc.URLClassPath");
            Field f_loaders = sunURLClassPath.getDeclaredField("loaders");
            Field f_lmap = sunURLClassPath.getDeclaredField("lmap");
            f_ucp.setAccessible(true);
            f_loaders.setAccessible(true);
            f_lmap.setAccessible(true);
            Object ucp = f_ucp.get(lloader);
            Closeable loader = (Closeable)((Map)f_lmap.get(ucp)).remove(Client.urlNoFragString(url));
            if (loader != null) {
                loader.close();
                ((List)f_loaders.get(ucp)).remove(loader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!mod.delete()) {
            mod.deleteOnExit();
            String msg = "SignPicture was unable to delete file " + mod.getPath() + " the game will now try to delete it on exit. If this dialog appears again, delete it manually.";
            Log.log.error(msg);
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, msg, "An update error has occurred", 0);
            }
        }
    }

    @Nonnull
    public static String urlNoFragString(@Nonnull URL url) {
        String file;
        String host;
        StringBuilder strForm = new StringBuilder();
        String protocol = url.getProtocol();
        if (protocol != null) {
            protocol = protocol.toLowerCase();
            strForm.append(protocol);
            strForm.append("://");
        }
        if ((host = url.getHost()) != null) {
            host = host.toLowerCase();
            strForm.append(host);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            if (port != -1) {
                strForm.append(":").append(port);
            }
        }
        if ((file = url.getFile()) != null) {
            strForm.append(file);
        }
        return strForm.toString();
    }

    public static void deleteMod() {
        Locations loc = location;
        if (loc != null && loc.modFile.isFile()) {
            Client.deleteMod(loc.modFile);
        }
    }

    static {
        mcversion = "1.12.1";
        forgeversion = ForgeVersion.getVersion();
        RootCommand cmd = rootCommand = new RootCommand();
        cmd.addChildCommand(new CommandVersion());
        cmd.addChildCommand(new CommandImage());
        schemes = ImmutableSet.of((Object)"http", (Object)"https");
    }

    public static class MovePos {
        @Nonnull
        public BlockPos pos;

        public MovePos(@Nonnull BlockPos pos) {
            Validate.notNull((Object)pos, (String)"MovePos needs position", (Object[])new Object[0]);
            this.pos = pos;
        }

        @Nullable
        public static RayTraceResult getMovingPos() {
            return Client.mc.field_71476_x;
        }

        @Nullable
        public static MovePos getBlockPos() {
            BlockPos pos;
            RayTraceResult movingPos = MovePos.getMovingPos();
            if (movingPos != null && (pos = movingPos.func_178782_a()) != null) {
                return new MovePos(pos);
            }
            return null;
        }

        @Nullable
        public static IBlockState getBlockState() {
            MovePos movePos = MovePos.getBlockPos();
            if (movePos != null) {
                return Client.mc.field_71441_e.func_180495_p(movePos.pos);
            }
            return null;
        }

        @Nullable
        public static TileEntity getTile() {
            MovePos movePos = MovePos.getBlockPos();
            if (movePos != null) {
                return Client.mc.field_71441_e.func_175625_s(movePos.pos);
            }
            return null;
        }

        @Nullable
        public static Block getBlock() {
            IBlockState blockState = MovePos.getBlockState();
            if (blockState != null) {
                return blockState.func_177230_c();
            }
            return null;
        }
    }
}

