/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic;

import com.google.common.collect.Sets;
import com.kamesuta.mc.signpic.CoreEvent;
import com.kamesuta.mc.signpic.image.ImageIOLoader;
import java.io.File;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import org.apache.commons.lang3.StringUtils;

public final class Config
extends Configuration {
    @Nullable
    private static Config instance;
    @Nonnull
    private final File configFile;
    @Nonnull
    private final Set<IReloadableConfig> configs = Sets.newHashSet();
    @Nonnull
    public final ConfigProperty<String> signpicDir = this.propertyString(this.get("General", "SignpicDir", "").setRequiresMcRestart(true));
    @Nonnull
    public final ConfigProperty<Boolean> signTooltip = this.propertyBoolean(this.get("General", "SignToolTip", false)).setComment("add tooltip line to sign");
    @Nonnull
    public final ConfigProperty<Integer> imageWidthLimit = this.propertyInteger(this.get("Image", "WidthLimit", 512)).setListener(new ConfigListener<Integer>(){

        @Override
        public void onChanged(@Nonnull Integer value) {
            ImageIOLoader.MAX_SIZE = ImageIOLoader.maxSize(value, Config.this.imageHeightLimit.get());
        }
    });
    @Nonnull
    public final ConfigProperty<Integer> imageHeightLimit = this.propertyInteger(this.get("Image", "HeightLimit", 512)).setListener(new ConfigListener<Integer>(){

        @Override
        public void onChanged(@Nonnull Integer value) {
            ImageIOLoader.MAX_SIZE = ImageIOLoader.maxSize(Config.this.imageWidthLimit.get(), value);
        }
    });
    @Nonnull
    public final ConfigProperty<Boolean> imageResizeFast = this.propertyBoolean(this.get("Image", "FastResize", false));
    @Nonnull
    public final ConfigProperty<Boolean> imageAnimationGif = this.propertyBoolean(this.get("Image", "AnimateGif", true).setRequiresMcRestart(true));
    @Nonnull
    public final ConfigProperty<Integer> entryGCtick = this.propertyInteger(this.get("Entry", "GCDelayTick", 300));
    @Nonnull
    public final ConfigProperty<Integer> communicateThreads = this.propertyInteger(this.get("Http", "HttpThreads", 3).setRequiresMcRestart(true)).setComment("parallel processing number such as Downloading");
    @Nonnull
    public final ConfigProperty<Integer> communicateDLTimedout = this.propertyInteger(this.get("Http", "DownloadTimedout", 15000).setRequiresMcRestart(true)).setComment("milliseconds of max waiting response time. 0 is infinity.");
    @Nonnull
    public final ConfigProperty<Integer> contentLoadThreads = this.propertyInteger(this.get("Content", "LoadThreads", 3).setRequiresMcRestart(true)).setComment("parallel processing number such as Image Loading");
    @Nonnull
    public final ConfigProperty<Integer> contentMaxByte = this.propertyInteger(this.get("Content", "MaxByte", 0x2000000)).setComment("limit of size before downloading. 0 is infinity.");
    @Nonnull
    public final ConfigProperty<Integer> contentGCtick = this.propertyInteger(this.get("Content", "GCDelayTick", 300)).setComment("delay ticks of Garbage Collection");
    @Nonnull
    public final ConfigProperty<Integer> contentLoadTick = this.propertyInteger(this.get("Content", "LoadStartIntervalTick", 0)).setComment("ticks of Load process starting delay (Is other threads, it does not disturb the operation) such as Downloading, File Loading...");
    @Nonnull
    public final ConfigProperty<Integer> contentSyncTick = this.propertyInteger(this.get("Content", "SyncLoadIntervalTick", 0)).setComment("ticks of Sync process interval (A drawing thread, affects the behavior. Please increase the value if the operation is heavy.) such as Gl Texture Uploading");
    @Nonnull
    public final ConfigProperty<Integer> contentMaxRetry = this.propertyInteger(this.get("Content", "MaxRetry", 3)).setComment("limit of retry count. 0 is infinity.");
    @Nonnull
    public final ConfigProperty<Boolean> informationNotice = this.propertyBoolean(this.get("Version", "Notice", true));
    @Nonnull
    public final ConfigProperty<Boolean> informationJoinBeta;
    @Nonnull
    public final ConfigProperty<Boolean> informationUpdateGui = this.propertyBoolean(this.get("Version", "UpdateGui", true));
    @Nonnull
    public final ConfigProperty<Boolean> informationTryNew = this.propertyBoolean(this.get("Version", "TryNew", false));
    @Nonnull
    public final ConfigProperty<Boolean> multiplayPAAS = this.propertyBoolean(this.get("Multiplay.PreventAntiAutoSign", "Enable", true));
    @Nonnull
    public final ConfigProperty<Integer> multiplayPAASMinEditTime = this.propertyInteger(this.get("Multiplay.PreventAntiAutoSign.Time", "minEditTime", 150));
    @Nonnull
    public final ConfigProperty<Integer> multiplayPAASMinLineTime = this.propertyInteger(this.get("Multiplay.PreventAntiAutoSign.Time", "minLineTime", 50));
    @Nonnull
    public final ConfigProperty<Integer> multiplayPAASMinCharTime = this.propertyInteger(this.get("Multiplay.PreventAntiAutoSign.Time", "minCharTime", 50));
    @Nonnull
    public final ConfigProperty<Boolean> chatpicEnable = this.propertyBoolean(this.get("ChatPicture", "Enable", true)).setComment("enable ChatPicture extension");
    @Nonnull
    public final ConfigProperty<Integer> chatpicLine = this.propertyInteger(this.get("ChatPicture", "ImageLines", 4)).setComment("how many lines does image use");
    @Nonnull
    public final ConfigProperty<Integer> chatpicStackTick = this.propertyInteger(this.get("ChatPicture", "StackTicks", 50)).setComment("stack chat lines within interval ticks");
    @Nonnull
    public final ConfigProperty<Boolean> renderOverlayPanel = this.propertyBoolean(this.get("Render", "OverlayPanel", true)).setComment("Overlay signpic!online");
    @Nonnull
    public final ConfigProperty<Boolean> renderGuiOverlay = this.propertyBoolean(this.get("Render", "GuiOverlay", true)).setComment("Overlay on GUI");
    @Nonnull
    public final ConfigProperty<Boolean> renderUseMipmap = this.propertyBoolean(this.get("Render", "Mipmap", true)).setComment("Require OpenGL 3.0 or later");
    @Nonnull
    public final ConfigProperty<Boolean> renderMipmapTypeNearest = this.propertyBoolean(this.get("Render", "MipmapTypeNearest", false)).setComment("true = Nearest, false = Linear");
    @Nonnull
    public final ConfigProperty<Double> renderSeeOpacity = this.propertyDouble(this.get("Render.Opacity", "ViewSign", 0.5));
    @Nonnull
    public final ConfigProperty<Double> renderPreviewFixedOpacity = this.propertyDouble(this.get("Render.Opacity", "PreviewFixedSign", 0.7f));
    @Nonnull
    public final ConfigProperty<Double> renderPreviewFloatedOpacity = this.propertyDouble(this.get("Render.Opacity", "PreviewFloatedSign", 0.4899999797344208));
    @Nonnull
    public final ConfigProperty<String> apiUploaderType = this.propertyString(this.get("Api.Upload", "Type", ""));
    @Nonnull
    public final ConfigProperty<String> apiUploaderKey = this.propertyString(this.get("Api.Upload", "Key", ""));
    @Nonnull
    public final ConfigProperty<String> apiShortenerType = this.propertyString(this.get("Api.Shortener", "Type", ""));
    @Nonnull
    public final ConfigProperty<String> apiShortenerKey = this.propertyString(this.get("Api.Shortener", "Key", ""));
    @Nonnull
    public final ConfigProperty<Boolean> debugLog = this.propertyBoolean(this.get("Debug", "DebugLog", false)).setComment("Output Debug Log");
    @Nonnull
    public final ConfigProperty<Boolean> guiExperienced = this.propertyBoolean(this.get("Internal", "GuiExperienced", false)).setComment("Have you ever opened SignPicture GUI yet?");

    @Nonnull
    public static Config getConfig() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("config not initialized");
    }

    public static void init(@Nonnull File cfgFile) {
        instance = new Config(cfgFile);
    }

    @Nonnull
    public <T extends IReloadableConfig> T registerReload(@Nonnull T config) {
        this.configs.add(config);
        return config;
    }

    public void reload() {
        for (IReloadableConfig config : this.configs) {
            config.reload();
        }
    }

    private Config(@Nonnull File configFile) {
        super(configFile);
        this.configFile = configFile;
        this.addCustomCategoryComment("Entry", "Entry(sign text parse cache) Management");
        this.addCustomCategoryComment("Content", "Content Data Management");
        this.addCustomCategoryComment("Multiplay.PreventAntiAutoSign", "Prevent from Anti-AutoSign Plugin such as NoCheatPlus. (ms)");
        this.addCustomCategoryComment("Api.Upload", "Api Upload Settings");
        Property joinBeta = this.get("Version", "JoinBeta", false);
        String[] v = StringUtils.split((String)"2.8.1", (String)"\\.");
        if (v.length >= 4 && StringUtils.equals((CharSequence)v[3], (CharSequence)"beta")) {
            joinBeta.set(true);
        }
        this.informationJoinBeta = this.propertyBoolean(joinBeta);
    }

    public void save() {
        if (this.hasChanged()) {
            super.save();
        }
    }

    @CoreEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (StringUtils.equals((CharSequence)eventArgs.getModID(), (CharSequence)"signpic")) {
            this.save();
            this.reload();
        }
    }

    @Nonnull
    public String getFilePath() {
        return this.configFile.getPath();
    }

    @Nonnull
    public ConfigProperty<String> propertyString(@Nonnull Property property) {
        return this.registerReload(ConfigProperty.propertyString(this, property));
    }

    @Nonnull
    public ConfigProperty<Boolean> propertyBoolean(@Nonnull Property property) {
        return this.registerReload(ConfigProperty.propertyBoolean(this, property));
    }

    @Nonnull
    public ConfigProperty<Double> propertyDouble(@Nonnull Property property) {
        return this.registerReload(ConfigProperty.propertyDouble(this, property));
    }

    @Nonnull
    public ConfigProperty<Integer> propertyInteger(@Nonnull Property property) {
        return this.registerReload(ConfigProperty.propertyInteger(this, property));
    }

    public static abstract class ConfigProperty<E>
    implements IReloadableConfig {
        @Nonnull
        protected final Configuration config;
        @Nonnull
        protected final Property property;
        @Nonnull
        private transient E prop;
        @Nullable
        private ConfigListener<E> listener;

        protected ConfigProperty(@Nonnull Configuration config, @Nonnull Property property, @Nonnull E prop) {
            this.config = config;
            this.property = property;
            this.prop = prop;
        }

        @Nonnull
        public ConfigProperty<E> setListener(@Nullable ConfigListener<E> listener) {
            this.listener = listener;
            return this;
        }

        @Nonnull
        public ConfigProperty<E> setComment(@Nonnull String comment) {
            this.property.setComment(comment);
            return this;
        }

        protected void setProp(@Nonnull E prop) {
            if (!this.property.requiresMcRestart()) {
                this.prop = prop;
                if (this.listener != null) {
                    this.listener.onChanged(prop);
                }
            }
        }

        @Nonnull
        public E get() {
            return this.prop;
        }

        @Nonnull
        public abstract ConfigProperty<E> set(@Nonnull E var1);

        @Nonnull
        public abstract ConfigProperty<E> reset();

        @Nonnull
        public static ConfigProperty<String> propertyString(@Nonnull Config config, @Nonnull Property property) {
            return new StringConfigProperty(config, property);
        }

        @Nonnull
        public static ConfigProperty<Boolean> propertyBoolean(@Nonnull Config config, @Nonnull Property property) {
            return new BooleanConfigProperty(config, property);
        }

        @Nonnull
        public static ConfigProperty<Double> propertyDouble(@Nonnull Config config, @Nonnull Property property) {
            return new DoubleConfigProperty(config, property);
        }

        @Nonnull
        public static ConfigProperty<Integer> propertyInteger(@Nonnull Config config, @Nonnull Property property) {
            return new IntegerConfigProperty(config, property);
        }

        private static class IntegerConfigProperty
        extends ConfigProperty<Integer> {
            protected IntegerConfigProperty(@Nonnull Configuration config, @Nonnull Property property) {
                super(config, property, property.getInt());
            }

            @Nonnull
            public IntegerConfigProperty set(@Nonnull Integer value) {
                this.property.set(value.intValue());
                this.setProp(value);
                this.config.save();
                return this;
            }

            @Nonnull
            public IntegerConfigProperty reset() {
                String p = this.property.getDefault();
                this.property.set(p);
                this.setProp(this.property.getInt());
                this.config.save();
                return this;
            }

            @Override
            public void reload() {
                this.setProp(this.property.getInt());
            }
        }

        private static class DoubleConfigProperty
        extends ConfigProperty<Double> {
            protected DoubleConfigProperty(@Nonnull Configuration config, @Nonnull Property property) {
                super(config, property, property.getDouble());
            }

            @Nonnull
            public DoubleConfigProperty set(@Nonnull Double value) {
                this.property.set(value.doubleValue());
                this.setProp(value);
                this.config.save();
                return this;
            }

            @Nonnull
            public DoubleConfigProperty reset() {
                String p = this.property.getDefault();
                this.property.set(p);
                this.setProp(this.property.getDouble());
                this.config.save();
                return this;
            }

            @Override
            public void reload() {
                this.setProp(this.property.getDouble());
            }
        }

        private static class BooleanConfigProperty
        extends ConfigProperty<Boolean> {
            protected BooleanConfigProperty(@Nonnull Configuration config, @Nonnull Property property) {
                super(config, property, property.getBoolean());
            }

            @Nonnull
            public BooleanConfigProperty set(@Nonnull Boolean value) {
                this.property.set(value.booleanValue());
                this.setProp(value);
                this.config.save();
                return this;
            }

            @Nonnull
            public BooleanConfigProperty reset() {
                String p = this.property.getDefault();
                this.property.set(p);
                this.setProp(this.property.getBoolean());
                this.config.save();
                return this;
            }

            @Override
            public void reload() {
                this.setProp(this.property.getBoolean());
            }
        }

        private static class StringConfigProperty
        extends ConfigProperty<String> {
            protected StringConfigProperty(@Nonnull Configuration config, @Nonnull Property property) {
                super(config, property, property.getString());
            }

            @Nonnull
            public StringConfigProperty set(@Nonnull String value) {
                this.property.set(value);
                this.setProp(value);
                this.config.save();
                return this;
            }

            @Nonnull
            public StringConfigProperty reset() {
                String p = this.property.getDefault();
                this.property.set(p);
                this.setProp(p);
                this.config.save();
                return this;
            }

            @Override
            public void reload() {
                this.setProp(this.property.getString());
            }
        }
    }

    public static interface ConfigListener<E> {
        public void onChanged(@Nonnull E var1);
    }

    public static interface IReloadableConfig {
        public void reload();
    }
}

