/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic;

import com.kamesuta.mc.signpic.Apis;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.entry.EntryManager;
import com.kamesuta.mc.signpic.entry.EntrySlot;
import com.kamesuta.mc.signpic.entry.content.ContentManager;
import com.kamesuta.mc.signpic.gui.OverlayFrame;
import com.kamesuta.mc.signpic.handler.KeyHandler;
import com.kamesuta.mc.signpic.handler.SignHandler;
import com.kamesuta.mc.signpic.http.Communicator;
import com.kamesuta.mc.signpic.http.ICommunicate;
import com.kamesuta.mc.signpic.http.ICommunicateCallback;
import com.kamesuta.mc.signpic.information.Informations;
import com.kamesuta.mc.signpic.render.CustomItemSignModel;
import com.kamesuta.mc.signpic.render.SignPicRender;
import com.kamesuta.mc.signpic.state.Progressable;
import com.kamesuta.mc.signpic.state.State;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.Timer;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class CoreHandler {
    @Nonnull
    public final Config configHandler = Config.getConfig();
    @Nonnull
    public final KeyHandler keyHandler = KeyHandler.instance;
    @Nonnull
    public final SignHandler signHandler = new SignHandler();
    @Nonnull
    public final EntryManager signEntryManager = EntryManager.instance;
    @Nonnull
    public final ContentManager contentManager = ContentManager.instance;
    @Nonnull
    public final SignPicRender renderHandler = new SignPicRender();
    @Nonnull
    public final OverlayFrame overlayHandler = OverlayFrame.instance;
    @Nonnull
    public final Informations informationHandler = Informations.instance;
    @Nonnull
    public final Apis apiHandler = Apis.instance;
    private boolean debugKey;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        KeyHandler.init();
        SignHandler.init();
        this.informationHandler.init();
        this.apiHandler.init();
    }

    @SubscribeEvent
    public void onKeyInput(@Nonnull InputEvent event) {
        this.keyHandler.onKeyInput(event);
    }

    @SubscribeEvent
    public void onRenderTick(@Nonnull TickEvent.RenderTickEvent event) {
        Timer.tick();
    }

    @SubscribeEvent
    public void onSign(@Nonnull GuiOpenEvent event) {
        this.signHandler.onSign(event);
    }

    @SubscribeEvent
    public void onClick(@Nonnull MouseEvent event) {
        this.signHandler.onClick(event);
    }

    @SubscribeEvent
    public void onTooltip(@Nonnull ItemTooltipEvent event) {
        this.signHandler.onTooltip(event);
    }

    @SubscribeEvent
    public void onRender(@Nonnull RenderWorldLastEvent event) {
        this.renderHandler.onRender(event);
    }

    @SubscribeEvent
    public void onDraw(@Nonnull RenderGameOverlayEvent.Post event) {
        this.renderHandler.onDraw(event);
        this.overlayHandler.onDraw(event);
    }

    @SubscribeEvent
    public void onDraw(@Nonnull GuiScreenEvent.DrawScreenEvent.Post event) {
        this.overlayHandler.onDraw(event);
        this.signHandler.onDraw(event);
    }

    @SubscribeEvent
    public void onText(@Nonnull RenderGameOverlayEvent.Text event) {
        this.renderHandler.onText(event);
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        this.configHandler.onConfigChanged(eventArgs);
    }

    @SubscribeEvent
    public void onResourceReloaded(@Nonnull TextureStitchEvent.Post event) {
        this.contentManager.onResourceReloaded(event);
    }

    @SubscribeEvent
    public void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Client.startSection("signpic_load");
            this.debugKey();
            this.signEntryManager.onTick();
            this.signHandler.onTick();
            this.contentManager.onTick();
            this.overlayHandler.onTick(event);
            this.informationHandler.onTick(event);
            EntrySlot.Tick();
            Client.endSection();
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)CustomItemSignModel.INSTANCE);
    }

    private void debugKey() {
        if (Keyboard.isKeyDown((int)23) && Keyboard.isKeyDown((int)24) && Keyboard.isKeyDown((int)25)) {
            if (!this.debugKey) {
                this.debug();
            }
            this.debugKey = true;
        } else {
            this.debugKey = false;
        }
    }

    private void debug() {
        DebugCommunicate debug = new DebugCommunicate();
        debug.getState().getMeta().put("gui.highlight", true);
        Communicator.instance.communicate(debug);
    }

    static class DebugCommunicate
    implements ICommunicate,
    Progressable {
        @Nonnull
        private final State state = new State();

        DebugCommunicate() {
            this.state.setName("Debug Progress").getProgress().setOverall(10L);
        }

        @Override
        public void cancel() {
        }

        @Override
        @Nonnull
        public State getState() {
            return this.state;
        }

        @Override
        public void communicate() {
            try {
                for (int i = 0; i < 10; ++i) {
                    Thread.sleep(100L);
                    this.state.getProgress().setDone(i + 1);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setCallback(@Nonnull ICommunicateCallback callback) {
        }
    }
}

