/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic;

import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.Log;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class Locations {
    @Nonnull
    public File mcDir;
    @Nonnull
    public File signpicDir;
    @Nonnull
    public File tempDir;
    @Nonnull
    public File cacheDir;
    @Nonnull
    public File metaDir;
    @Nonnull
    public File modDir;
    @Nonnull
    public File modFile;

    public Locations(@Nonnull File modFile, @Nonnull File mcdir) {
        this.mcDir = mcdir;
        this.signpicDir = this.getSignPicDir(mcdir);
        this.securementDirectory(this.signpicDir);
        this.tempDir = new File(this.signpicDir, "temp");
        this.securementDirectory(this.tempDir);
        this.cacheDir = new File(this.signpicDir, "cache");
        this.securementDirectory(this.cacheDir);
        this.metaDir = new File(this.signpicDir, "meta");
        this.securementDirectory(this.metaDir);
        this.modDir = new File(mcdir, "mods");
        this.modFile = modFile;
    }

    @Nonnull
    public File createCache(@Nonnull String pre) throws IOException {
        File f;
        while (!(f = new File(this.tempDir, pre + RandomStringUtils.randomAlphanumeric((int)8))).createNewFile()) {
        }
        return f;
    }

    @Nonnull
    private File getSignPicDir(@Nonnull File defaultdir) {
        File dir = new File(Config.getConfig().signpicDir.get());
        if (!StringUtils.isEmpty((CharSequence)Config.getConfig().signpicDir.get())) {
            if (dir.exists() && dir.isDirectory() && !dir.equals(defaultdir)) {
                return dir;
            }
            Log.dev.error("invalid signpic dir location! use default dir.");
        }
        return new File(defaultdir, "signpic");
    }

    private boolean securementDirectory(@Nonnull File cachedir) {
        if (cachedir.exists() && !cachedir.isDirectory()) {
            File to;
            int i = 2;
            do {
                to = new File(cachedir.getParent(), cachedir.getName() + i);
                ++i;
            } while (to.exists());
            cachedir.renameTo(to);
            Log.log.warn("non-directory conflicting file exists. renamed to " + to.getName());
            return true;
        }
        cachedir.mkdir();
        return false;
    }
}

