/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic;

import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.gui.OverlayFrame;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log {
    @Nonnull
    public static Logger log = LogManager.getLogger((String)"signpic");
    @Nonnull
    public static Logger dev = new DevLogger(log);

    public static void notice(@Nonnull Object notice, float duration) {
        OverlayFrame.instance.pane.addNotice1(notice.toString(), duration);
        dev.info(notice);
    }

    public static void notice(@Nonnull String notice, @Nonnull Throwable e, float duration) {
        OverlayFrame.instance.pane.addNotice1(notice, duration);
        dev.info(notice, e);
    }

    public static void notice(@Nonnull String notice) {
        Log.notice((Object)notice, 2.0f);
    }

    public static void notice(@Nonnull String notice, @Nonnull Throwable e) {
        Log.notice(notice, e, 2.0f);
    }

    private static class DevLogger
    extends AbstractLogger {
        private final Logger logger;

        public DevLogger(@Nonnull Logger logger) {
            this.logger = logger;
        }

        private boolean isEnabled() {
            Config cfg = Config.getConfig();
            Validate.notNull((Object)((Object)cfg), (String)"internal error: debug logger can be used after config loaded!", (Object[])new Object[0]);
            return Config.getConfig().debugLog.get();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable Message data, @Nullable Throwable t) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable Object data, @Nullable Throwable t) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String data) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String data, Object ... p1) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String data, @Nullable Throwable t) {
            return this.isEnabled();
        }

        public void log(@Nullable Level level, @Nullable Marker marker, @Nullable Message data, @Nullable Throwable t) {
            if (this.isEnabled() && data != null) {
                this.logger.log(level, marker, "[DEBUG] " + data.getFormattedMessage(), t);
            }
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable CharSequence message, @Nullable Throwable t) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
            return this.isEnabled();
        }

        public boolean isEnabled(@Nullable Level level, @Nullable Marker marker, @Nullable String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
            return this.isEnabled();
        }

        public void logMessage(@Nullable String fqcn, @Nullable Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable t) {
            this.log(level, marker, message, t);
        }

        public Level getLevel() {
            return Level.DEBUG;
        }
    }
}

