/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.asm.lib;

import com.kamesuta.mc.signpic.asm.lib.MappedType;
import com.kamesuta.mc.signpic.asm.lib.RefName;
import com.kamesuta.mc.signpic.asm.lib.VisitorHelper;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;

public class MethodMatcher {
    @Nonnull
    private final String clsName;
    @Nonnull
    private final String description;
    @Nonnull
    private final RefName refname;

    public MethodMatcher(@Nonnull String clsName, @Nonnull String description, @Nonnull RefName refname) {
        this.clsName = clsName;
        this.description = description;
        this.refname = refname;
    }

    public MethodMatcher(@Nonnull MappedType cls, @Nonnull String description, @Nonnull RefName refname) {
        this(cls.name(), description, refname);
    }

    public boolean match(@Nonnull String methodName, @Nonnull String methodDesc) {
        if (methodName.equals(this.refname.mcpName())) {
            return true;
        }
        if (!VisitorHelper.useSrgNames()) {
            return false;
        }
        String unmappedDesc = FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(methodDesc);
        if (!unmappedDesc.equals(this.description)) {
            return false;
        }
        String unmappedName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.clsName, methodName, methodDesc);
        return unmappedName.equals(this.refname.srgName());
    }

    @Nonnull
    public String toString() {
        return String.format("Matcher: %s.%s %s", this.clsName, this.refname, this.description);
    }
}

