/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.asm.lib;

import com.kamesuta.mc.signpic.asm.lib.StopTransforming;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.commons.lang3.Validate;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class VisitorHelper {
    public static byte[] apply(@Nonnull byte[] bytes, @Nonnull String name, @Nonnull TransformProvider context) {
        Validate.notNull((Object)bytes);
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(cr, context.flags);
        ClassVisitor mod = context.createVisitor(name, (ClassVisitor)cw);
        try {
            cr.accept(mod, 0);
            return cw.toByteArray();
        }
        catch (StopTransforming e) {
            return bytes;
        }
    }

    public static boolean useSrgNames() {
        Boolean deobfuscated = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return deobfuscated == null || deobfuscated == false;
    }

    @Nonnull
    public static String getMappedName(@Nonnull String clsName) {
        return VisitorHelper.useSrgNames() ? FMLDeobfuscatingRemapper.INSTANCE.unmap(clsName) : clsName;
    }

    public static abstract class TransformProvider {
        private final int flags;

        public TransformProvider(int flags) {
            this.flags = flags;
        }

        @Nonnull
        public abstract ClassVisitor createVisitor(@Nonnull String var1, @Nonnull ClassVisitor var2);
    }
}

