/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.attr.Attrs;
import com.kamesuta.mc.signpic.attr.PropReader;
import com.kamesuta.mc.signpic.attr.prop.AnimationData;
import com.kamesuta.mc.signpic.attr.prop.OffsetData;
import com.kamesuta.mc.signpic.attr.prop.RotationData;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.attr.prop.TextureData;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;

public class AttrReaders {
    @Nonnull
    public static final AttrReaders Blank = new AttrReaders();
    private boolean hasInvalidMeta;
    @Nonnull
    private Set<PropReader<?, ?, ?>> metas = Sets.newHashSet();
    @Nonnull
    public final PropReader<AnimationData, AnimationData, AnimationData> animations = this.add(new PropReader(Attrs.ANIMATION.getReader()));
    @Nonnull
    public final PropReader<SizeData, SizeData, SizeData> sizes = this.add(new PropReader(Attrs.SIZE.getReader()));
    @Nonnull
    public final PropReader<OffsetData, OffsetData, OffsetData> offsets = this.add(new PropReader(Attrs.OFFSET.getReader()));
    @Nonnull
    public final PropReader<OffsetData, OffsetData, OffsetData> centeroffsets = this.add(new PropReader(Attrs.OFFSET_CENTER.getReader()));
    @Nonnull
    public final PropReader<RotationData.KeyRotation, RotationData, RotationData.DiffRotation> rotations = this.add(new PropReader(Attrs.ROTATION.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> u = this.add(new PropReader(Attrs.TEXTURE_X.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> v = this.add(new PropReader(Attrs.TEXTURE_Y.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> w = this.add(new PropReader(Attrs.TEXTURE_W.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> h = this.add(new PropReader(Attrs.TEXTURE_H.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> c = this.add(new PropReader(Attrs.TEXTURE_SPLIT_W.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> s = this.add(new PropReader(Attrs.TEXTURE_SPLIT_H.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> o = this.add(new PropReader(Attrs.TEXTURE_OPACITY.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> f = this.add(new PropReader(Attrs.TEXTURE_LIGHT_X.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureFloat, TextureData.TextureFloat, TextureData.TextureFloat> g = this.add(new PropReader(Attrs.TEXTURE_LIGHT_Y.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureBoolean, TextureData.TextureBoolean, TextureData.TextureBoolean> r = this.add(new PropReader(Attrs.TEXTURE_REPEAT.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureBoolean, TextureData.TextureBoolean, TextureData.TextureBoolean> m = this.add(new PropReader(Attrs.TEXTURE_MIPMAP.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureBoolean, TextureData.TextureBoolean, TextureData.TextureBoolean> l = this.add(new PropReader(Attrs.TEXTURE_LIGHTING.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureBlend, TextureData.TextureBlend, TextureData.TextureBlend> b = this.add(new PropReader(Attrs.TEXTURE_BLEND_SRC.getReader()));
    @Nonnull
    public final PropReader<TextureData.TextureBlend, TextureData.TextureBlend, TextureData.TextureBlend> d = this.add(new PropReader(Attrs.TEXTURE_BLEND_DST.getReader()));

    @Nonnull
    private <E extends PropReader<?, ?, ?>> E add(@Nonnull E e) {
        this.metas.add(e);
        return e;
    }

    private AttrReaders() {
    }

    public AttrReaders(@Nonnull String src) {
        Validate.notNull((Object)src);
        TreeMap timeline = Maps.newTreeMap();
        Matcher mgb = Attrs.pg.matcher(src);
        String s = mgb.replaceAll("");
        timeline.put(Float.valueOf(0.0f), s);
        float current = 0.0f;
        Matcher mg = Attrs.pg.matcher(src);
        while (mg.find()) {
            int gcount = mg.groupCount();
            if (2 > gcount) continue;
            float time = NumberUtils.toFloat((String)mg.group(1), (float)0.0f);
            String before = (String)timeline.get(Float.valueOf(current += time));
            String meta = mg.group(2);
            if (before != null) {
                meta = before + meta;
            }
            timeline.put(Float.valueOf(current), meta);
        }
        boolean bb = true;
        for (Map.Entry entry : timeline.entrySet()) {
            float time = ((Float)entry.getKey()).floatValue();
            String meta = (String)entry.getValue();
            Matcher mp = Attrs.pp.matcher(meta);
            while (mp.find()) {
                String value;
                int gcount = mp.groupCount();
                if (1 > gcount) continue;
                String key = mp.group(1);
                String string = value = 2 <= gcount ? mp.group(2) : "";
                if (StringUtils.isEmpty((CharSequence)key) && StringUtils.isEmpty((CharSequence)value)) continue;
                boolean b = false;
                for (PropReader<?, ?, ?> m : this.metas) {
                    b = m.parse(src, key, value) || b;
                }
                bb = b && bb;
            }
            Easings easing = Easings.easeLinear;
            if (this.animations.isParsed()) {
                AnimationData anim = this.animations.getDiff();
                easing = anim.easing;
            }
            for (PropReader<?, ?, ?> m : this.metas) {
                m.next(time, easing);
            }
        }
        this.hasInvalidMeta = !bb;
        Log.dev.info("signmeta={" + src + "}, unsupported=" + !bb);
    }

    public boolean hasInvalidMeta() {
        return this.hasInvalidMeta;
    }

    public String toString() {
        return String.format("AttrReaders [hasInvalidMeta=%s, metas=%s, animations=%s, sizes=%s, offsets=%s, centeroffsets=%s, rotations=%s, u=%s, v=%s, w=%s, h=%s, c=%s, s=%s, o=%s, f=%s, g=%s, r=%s, m=%s, l=%s, b=%s, d=%s]", this.hasInvalidMeta, this.metas, this.animations, this.sizes, this.offsets, this.centeroffsets, this.rotations, this.u, this.v, this.w, this.h, this.c, this.s, this.o, this.f, this.g, this.r, this.m, this.l, this.b, this.d);
    }
}

