/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kamesuta.mc.bnnwidget.ShortestFloatFormatter;
import com.kamesuta.mc.signpic.attr.Attrs;
import com.kamesuta.mc.signpic.attr.IPropBuilder;
import com.kamesuta.mc.signpic.attr.prop.AnimationData;
import com.kamesuta.mc.signpic.attr.prop.OffsetData;
import com.kamesuta.mc.signpic.attr.prop.RotationData;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.attr.prop.TextureData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;

public class AttrWriters {
    @Nonnull
    private final TreeMap<Float, AttrWriter> frames = Maps.newTreeMap();

    @Nonnull
    public AttrWriter getFrame(float time) {
        AttrWriter attr = this.frames.get(Float.valueOf(time));
        if (attr == null) {
            attr = new AttrWriter();
            this.frames.put(Float.valueOf(time), attr);
        }
        return attr;
    }

    @Nonnull
    public AttrWriters parse(@Nonnull String src) {
        String meta;
        Validate.notNull((Object)src);
        TreeMap timeline = Maps.newTreeMap();
        Matcher mgb = Attrs.pg.matcher(src);
        String s = mgb.replaceAll("");
        this.getFrame(0.0f).parse(s);
        float current = 0.0f;
        Matcher mg = Attrs.pg.matcher(src);
        while (mg.find()) {
            int gcount = mg.groupCount();
            if (2 > gcount) continue;
            float time = NumberUtils.toFloat((String)mg.group(1), (float)0.0f);
            String before = (String)timeline.get(Float.valueOf(current += time));
            meta = mg.group(2);
            if (before != null) {
                meta = before + meta;
            }
            timeline.put(Float.valueOf(current), meta);
        }
        for (Map.Entry entry : timeline.entrySet()) {
            float time = ((Float)entry.getKey()).floatValue();
            meta = (String)entry.getValue();
            this.getFrame(time).parse(meta);
        }
        return this;
    }

    @Nonnull
    public String compose() {
        StringBuilder stb = new StringBuilder("{");
        AttrWriter first = this.getFrame(0.0f);
        if (!first.isEmpty()) {
            stb.append(first.compose());
        }
        float lasttime = 0.0f;
        for (Map.Entry<Float, AttrWriter> entry : this.frames.entrySet()) {
            AttrWriter attr;
            float time = entry.getKey().floatValue();
            if (time == 0.0f || (attr = entry.getValue()).isEmpty()) continue;
            float interval = time - lasttime;
            stb.append("(");
            if (interval != 0.0f) {
                stb.append(ShortestFloatFormatter.format(interval)).append("~");
            }
            stb.append(attr.compose()).append(")");
            lasttime = time;
        }
        return stb.append("}").toString();
    }

    public static class AttrWriter {
        @Nonnull
        private Set<IPropBuilder<?, ?>> metareader = Sets.newHashSet();
        @Nonnull
        private List<IPropBuilder<?, ?>> metawriter = Lists.newArrayList();
        @Nonnull
        private Map<String, IPropBuilder<?, ?>> str2attr = Maps.newHashMap();
        @Nonnull
        private Map<IPropBuilder<?, ?>, ImmutableSet<String>> attr2str = Maps.newHashMap();
        @Nonnull
        public final AnimationData.AnimationBuilder animation = (AnimationData.AnimationBuilder)this.init(Attrs.ANIMATION);
        @Nonnull
        public final SizeData.SizeBuilder size = (SizeData.SizeBuilder)this.init(Attrs.SIZE);
        @Nonnull
        public final OffsetData.OffsetBuilder offset = (OffsetData.OffsetBuilder)this.init(Attrs.OFFSET);
        @Nonnull
        public final OffsetData.OffsetBuilder centeroffset = (OffsetData.OffsetBuilder)this.init(Attrs.OFFSET_CENTER);
        @Nonnull
        public final RotationData.RotationBuilder rotation = (RotationData.RotationBuilder)this.init(Attrs.ROTATION);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder u = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_X);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder v = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_Y);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder w = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_W);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder h = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_H);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder c = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_SPLIT_W);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder s = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_SPLIT_H);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder o = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_OPACITY);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder f = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_LIGHT_X);
        @Nonnull
        public final TextureData.TextureFloat.TextureFloatBuilder g = (TextureData.TextureFloat.TextureFloatBuilder)this.init(Attrs.TEXTURE_LIGHT_Y);
        @Nonnull
        public final TextureData.TextureBoolean.TextureBooleanBuilder r = (TextureData.TextureBoolean.TextureBooleanBuilder)this.init(Attrs.TEXTURE_REPEAT);
        @Nonnull
        public final TextureData.TextureBoolean.TextureBooleanBuilder m = (TextureData.TextureBoolean.TextureBooleanBuilder)this.init(Attrs.TEXTURE_MIPMAP);
        @Nonnull
        public final TextureData.TextureBoolean.TextureBooleanBuilder l = (TextureData.TextureBoolean.TextureBooleanBuilder)this.init(Attrs.TEXTURE_LIGHTING);
        @Nonnull
        public final TextureData.TextureBlend.TextureBlendBuilder b = (TextureData.TextureBlend.TextureBlendBuilder)this.init(Attrs.TEXTURE_BLEND_SRC);
        @Nonnull
        public final TextureData.TextureBlend.TextureBlendBuilder d = (TextureData.TextureBlend.TextureBlendBuilder)this.init(Attrs.TEXTURE_BLEND_DST);

        @Nonnull
        private <T extends IPropBuilder<?, ?>, E extends Attrs.Attr<?, ?, T>> T init(@Nonnull E e) {
            T writer = e.getWriter();
            ImmutableSet<String> ids = e.getId();
            for (String id : ids) {
                this.str2attr.put(id, (IPropBuilder<?, ?>)writer);
            }
            this.attr2str.put((IPropBuilder<?, ?>)writer, ids);
            this.metareader.add((IPropBuilder<?, ?>)writer);
            return writer;
        }

        @Nonnull
        public IPropBuilder<?, ?> getAttr(@Nonnull String id) {
            return this.str2attr.get(id);
        }

        @Nonnull
        public ImmutableSet<String> getIds(@Nonnull IPropBuilder<?, ?> prop) {
            return this.attr2str.get(prop);
        }

        @Nonnull
        public List<IPropBuilder<?, ?>> getWriters() {
            return this.metawriter;
        }

        @Nonnull
        public AttrWriter add(@Nonnull IPropBuilder<?, ?> e) {
            if (!this.metawriter.contains(e)) {
                this.metawriter.add(e);
            }
            return this;
        }

        @Nonnull
        public AttrWriter remove(@Nonnull IPropBuilder<?, ?> e) {
            this.metawriter.remove(e);
            return this;
        }

        public boolean contains(@Nonnull IPropBuilder<?, ?> e) {
            return this.metawriter.contains(e);
        }

        public boolean isEmpty() {
            return this.metawriter.isEmpty();
        }

        public String toString() {
            return this.compose();
        }

        @Nonnull
        public AttrWriter parse(@Nonnull String src) {
            Validate.notNull((Object)src);
            Matcher mgb = Attrs.pg.matcher(src);
            String meta = mgb.replaceAll("");
            Matcher mp = Attrs.pp.matcher(meta);
            while (mp.find()) {
                String value;
                int gcount = mp.groupCount();
                if (1 > gcount) continue;
                String key = mp.group(1);
                String string = value = 2 <= gcount ? mp.group(2) : "";
                if (StringUtils.isEmpty((CharSequence)key) && StringUtils.isEmpty((CharSequence)value)) continue;
                this.size.parse(src, key, value);
                for (IPropBuilder<?, ?> m : this.metareader) {
                    if (!m.parse(src, key, value)) continue;
                    this.add(m);
                }
            }
            return this;
        }

        @Nonnull
        public String compose() {
            StringBuilder stb = new StringBuilder();
            if (this.metawriter.contains(this.size)) {
                stb.append(this.size.compose());
            }
            for (IPropBuilder<?, ?> m : this.metawriter) {
                if (m.equals(this.size)) continue;
                stb.append(m.compose());
            }
            return stb.toString();
        }
    }
}

