/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr;

import com.google.common.collect.Maps;
import com.kamesuta.mc.bnnwidget.motion.CompoundMotion;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.bnnwidget.motion.ICompoundMotion;
import com.kamesuta.mc.signpic.attr.IPropInterpolatable;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class PropReaderAnimation<KeyFrame extends IPropInterpolatable<InterFrame>, InterFrame> {
    @Nonnull
    private final ICompoundMotion motion = new CompoundMotion().setLoop(true).start();
    @Nonnull
    private final TreeMap<Float, KeyFrame> frames = Maps.newTreeMap();
    private float lasttime;

    public PropReaderAnimation(@Nonnull KeyFrame defaultframe) {
        this.frames.put(Float.valueOf(0.0f), defaultframe);
    }

    @Nonnull
    public InterFrame get() {
        if (this.frames.size() <= 1) {
            return ((IPropInterpolatable)this.frames.get(Float.valueOf(0.0f))).per();
        }
        float t = this.motion.get();
        Map.Entry<Float, KeyFrame> before = this.frames.floorEntry(Float.valueOf(t));
        Map.Entry<Float, KeyFrame> after = this.frames.higherEntry(Float.valueOf(t));
        if (before == null) {
            before = this.frames.firstEntry();
        }
        if (after != null) {
            float f1 = after.getKey().floatValue();
            float f2 = before.getKey().floatValue();
            return ((IPropInterpolatable)after.getValue()).per((t - f2) / (f1 - f2), ((IPropInterpolatable)before.getValue()).per());
        }
        return ((IPropInterpolatable)before.getValue()).per();
    }

    @Nonnull
    public PropReaderAnimation<KeyFrame, InterFrame> add(float time, @Nonnull KeyFrame frame, @Nonnull Easings easing) {
        float difftime = time - this.lasttime;
        this.motion.add(easing.move(difftime, time));
        this.lasttime = time;
        this.frames.put(Float.valueOf(time), frame);
        return this;
    }
}

