/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr.prop;

import com.google.common.collect.ImmutableMap;
import com.kamesuta.mc.bnnwidget.motion.Easings;
import com.kamesuta.mc.signpic.attr.IPropBuilder;
import com.kamesuta.mc.signpic.attr.IPropComposable;
import com.kamesuta.mc.signpic.attr.IPropInterpolatable;
import com.kamesuta.mc.signpic.attr.prop.PropSyntax;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AnimationData
implements IPropInterpolatable<AnimationData>,
IPropComposable {
    @Nonnull
    public final Easings easing;
    @Nonnull
    public final RSNeed redstone;

    public AnimationData(@Nonnull Easings easing, @Nonnull RSNeed redstone) {
        this.easing = easing;
        this.redstone = redstone;
    }

    @Override
    @Nonnull
    public AnimationData per() {
        return this;
    }

    @Override
    @Nonnull
    public AnimationData per(float per, @Nullable AnimationData before) {
        return this;
    }

    @Override
    @Nonnull
    public String compose() {
        StringBuilder stb = new StringBuilder();
        if (this.easing != Easings.easeLinear) {
            stb.append(PropSyntax.ANIMATION_EASING.id).append(this.easing.id);
        }
        if (this.redstone != RSNeed.IGNORE) {
            stb.append(PropSyntax.ANIMATION_REDSTONE.id).append(this.redstone.id);
        }
        return stb.toString();
    }

    @Nonnull
    public String toString() {
        return "AnimationData [easing=" + this.easing + ", redstone=" + (Object)((Object)this.redstone) + "]";
    }

    public static class AnimationBuilder
    implements IPropBuilder<AnimationData, AnimationData> {
        @Nonnull
        public Easings easing = Easings.easeLinear;
        @Nonnull
        public RSNeed redstone = RSNeed.IGNORE;

        @Override
        @Nonnull
        public AnimationData diff(@Nullable AnimationData base) {
            return new AnimationData(this.easing, this.redstone);
        }

        @Override
        public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.ANIMATION_EASING.id)) {
                this.easing = Easings.fromId(NumberUtils.toInt((String)value));
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)PropSyntax.ANIMATION_REDSTONE.id)) {
                this.redstone = RSNeed.fromId(NumberUtils.toInt((String)value));
            } else {
                return false;
            }
            return true;
        }

        @Override
        @Nonnull
        public String compose() {
            return this.diff(null).compose();
        }

        @Deprecated
        @Nonnull
        public String toString() {
            return this.compose();
        }
    }

    public static enum RSNeed {
        IGNORE(0),
        RS_ON(1),
        RS_OFF(2);

        public final int id;
        @Nonnull
        private static final ImmutableMap<Integer, RSNeed> rsIds;

        private RSNeed(int id) {
            this.id = id;
        }

        @Nonnull
        public static RSNeed fromId(int id) {
            RSNeed rs = (RSNeed)((Object)rsIds.get((Object)id));
            if (rs == null) {
                rs = IGNORE;
            }
            return rs;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (RSNeed easing : RSNeed.values()) {
                builder.put((Object)easing.id, (Object)easing);
            }
            rsIds = builder.build();
        }
    }
}

