/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.attr.prop;

import com.kamesuta.mc.bnnwidget.ShortestFloatFormatter;
import com.kamesuta.mc.signpic.attr.IPropBuilder;
import com.kamesuta.mc.signpic.attr.IPropInterpolatable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OffsetData
implements IPropInterpolatable<OffsetData> {
    public static final float defaultOffset = 0.5f;
    @Nonnull
    public final OffsetPropData x;
    @Nonnull
    public final OffsetPropData y;
    @Nonnull
    public final OffsetPropData z;

    public OffsetData(@Nonnull OffsetPropData x, @Nonnull OffsetPropData y, @Nonnull OffsetPropData z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    @Nonnull
    public OffsetData per() {
        return this;
    }

    @Override
    @Nonnull
    public OffsetData per(float per, @Nullable OffsetData before) {
        if (before == null) {
            return this;
        }
        return new OffsetData(this.x.per(per, before.x), this.y.per(per, before.y), this.z.per(per, before.z));
    }

    @Nonnull
    public String toString() {
        return "OffsetData [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    public static class OffsetDoublePropBuilder
    extends OffsetPropBuilder {
        @Nonnull
        public final String neg;

        public OffsetDoublePropBuilder(@Nonnull String neg, @Nonnull String pos) {
            super(pos);
            this.neg = neg;
        }

        @Override
        @Nonnull
        public String toString() {
            return "OffsetPropBuilder [neg=" + this.neg + ", pos=" + this.pos + ", offset=" + this.offset + "]";
        }

        @Override
        public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)this.neg)) {
                this.offset = StringUtils.isEmpty((CharSequence)value) ? (this.offset -= 0.5f) : (this.offset -= NumberUtils.toFloat((String)value, (float)0.0f));
            } else {
                return super.parse(src, key, value);
            }
            return true;
        }

        @Override
        @Nonnull
        public String compose() {
            if (this.offset != 0.0f) {
                if (this.offset < 0.0f) {
                    if (this.offset == -0.5f) {
                        return this.neg;
                    }
                    return this.neg + ShortestFloatFormatter.format(-this.offset);
                }
                return super.compose();
            }
            return "";
        }
    }

    public static class OffsetPropBuilder
    implements IPropBuilder<OffsetPropData, OffsetPropData> {
        @Nonnull
        public final String pos;
        protected float offset;

        public OffsetPropBuilder(@Nonnull String pos) {
            this.pos = pos;
        }

        @Override
        @Nonnull
        public OffsetPropData diff(@Nullable OffsetPropData base) {
            if (base == null) {
                return new OffsetPropData(this.offset);
            }
            return new OffsetPropData(base.offset + this.offset);
        }

        public void set(float offset) {
            this.offset = offset;
        }

        public float get() {
            return this.offset;
        }

        @Nonnull
        public String toString() {
            return "OffsetPropBuilder [pos=" + this.pos + ", offset=" + this.offset + "]";
        }

        @Override
        public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)this.pos)) {
                this.offset = StringUtils.isEmpty((CharSequence)value) ? (this.offset += 0.5f) : (this.offset += NumberUtils.toFloat((String)value, (float)0.0f));
            } else {
                return false;
            }
            return true;
        }

        @Override
        @Nonnull
        public String compose() {
            if (this.offset != 0.0f) {
                if (this.offset == 0.5f) {
                    return this.pos;
                }
                return this.pos + ShortestFloatFormatter.format(this.offset);
            }
            return "";
        }
    }

    public static class OffsetPropData
    implements IPropInterpolatable<OffsetPropData> {
        public final float offset;

        public OffsetPropData(float offset) {
            this.offset = offset;
        }

        @Override
        @Nonnull
        public OffsetPropData per() {
            return this;
        }

        @Override
        @Nonnull
        public OffsetPropData per(float per, @Nullable OffsetPropData before) {
            if (before == null) {
                return this;
            }
            return new OffsetPropData(this.offset * per + before.offset * (1.0f - per));
        }

        @Nonnull
        public String toString() {
            return "OffsetPropData [offset=" + this.offset + "]";
        }
    }

    public static class OffsetBuilder
    implements IPropBuilder<OffsetData, OffsetData> {
        @Nonnull
        public final OffsetPropBuilder x;
        @Nonnull
        public final OffsetPropBuilder y;
        @Nonnull
        public final OffsetPropBuilder z;

        public OffsetBuilder(@Nonnull OffsetPropBuilder x, @Nonnull OffsetPropBuilder y, @Nonnull OffsetPropBuilder z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean parse(@Nonnull String src, @Nonnull String key, @Nonnull String value) {
            boolean a = this.x.parse(src, key, value);
            boolean b = this.y.parse(src, key, value);
            boolean c = this.z.parse(src, key, value);
            return a || b || c;
        }

        @Override
        @Nonnull
        public String compose() {
            return this.x.compose() + this.y.compose() + this.z.compose();
        }

        @Override
        @Nonnull
        public OffsetData diff(@Nullable OffsetData base) {
            if (base == null) {
                return new OffsetData(this.x.diff(null), this.y.diff(null), this.z.diff(null));
            }
            return new OffsetData(this.x.diff(base.x), this.y.diff(base.y), this.z.diff(base.z));
        }

        @Nonnull
        public String toString() {
            return "OffsetBuilder [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
        }
    }
}

